<?php
/**
 * MeetPublicApi
 * PHP version 7.4
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CallNowButton API
 *
 * API for CallNowButton. Includes auth, domains, buttons/actions/conditions, but also chat and admin features.
 *
 * The version of the OpenAPI document: 0.0.219-local
 * Contact: support@nowbuttons.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace cnb\api\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use cnb\api\ApiException;
use cnb\api\Configuration;
use cnb\api\HeaderSelector;
use cnb\api\ObjectSerializer;

/**
 * MeetPublicApi Class Doc Comment
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class MeetPublicApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'claimAvailableSlot' => [
            'application/json',
        ],
        'getAvailableSlot' => [
            'application/json',
        ],
        'getAvailableSlots' => [
            'application/json',
        ],
        'getBookedSlot' => [
            'application/json',
        ],
        'getFields' => [
            'application/json',
        ],
        'getIcsForBookedSlot' => [
            'application/json',
        ],
        'getIcsForBookedSlotUrlEndpoint' => [
            'application/json',
        ],
        'isValid' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation claimAvailableSlot
     *
     * Claim an available slot for this account
     *
     * @param  string $workspace_slug workspace_slug (required)
     * @param  string $meet_id meet_id (required)
     * @param  string $slot_id slot_id (required)
     * @param  \cnb\api\Model\SlotClaim $slot_claim slot_claim (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['claimAvailableSlot'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\SlotClaimResponse
     */
    public function claimAvailableSlot($workspace_slug, $meet_id, $slot_id, $slot_claim, string $contentType = self::contentTypes['claimAvailableSlot'][0])
    {
        list($response) = $this->claimAvailableSlotWithHttpInfo($workspace_slug, $meet_id, $slot_id, $slot_claim, $contentType);
        return $response;
    }

    /**
     * Operation claimAvailableSlotWithHttpInfo
     *
     * Claim an available slot for this account
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $slot_id (required)
     * @param  \cnb\api\Model\SlotClaim $slot_claim (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['claimAvailableSlot'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\SlotClaimResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function claimAvailableSlotWithHttpInfo($workspace_slug, $meet_id, $slot_id, $slot_claim, string $contentType = self::contentTypes['claimAvailableSlot'][0])
    {
        $request = $this->claimAvailableSlotRequest($workspace_slug, $meet_id, $slot_id, $slot_claim, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\SlotClaimResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\SlotClaimResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\SlotClaimResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\SlotClaimResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\SlotClaimResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation claimAvailableSlotAsync
     *
     * Claim an available slot for this account
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $slot_id (required)
     * @param  \cnb\api\Model\SlotClaim $slot_claim (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['claimAvailableSlot'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function claimAvailableSlotAsync($workspace_slug, $meet_id, $slot_id, $slot_claim, string $contentType = self::contentTypes['claimAvailableSlot'][0])
    {
        return $this->claimAvailableSlotAsyncWithHttpInfo($workspace_slug, $meet_id, $slot_id, $slot_claim, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation claimAvailableSlotAsyncWithHttpInfo
     *
     * Claim an available slot for this account
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $slot_id (required)
     * @param  \cnb\api\Model\SlotClaim $slot_claim (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['claimAvailableSlot'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function claimAvailableSlotAsyncWithHttpInfo($workspace_slug, $meet_id, $slot_id, $slot_claim, string $contentType = self::contentTypes['claimAvailableSlot'][0])
    {
        $returnType = '\cnb\api\Model\SlotClaimResponse';
        $request = $this->claimAvailableSlotRequest($workspace_slug, $meet_id, $slot_id, $slot_claim, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'claimAvailableSlot'
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $slot_id (required)
     * @param  \cnb\api\Model\SlotClaim $slot_claim (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['claimAvailableSlot'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function claimAvailableSlotRequest($workspace_slug, $meet_id, $slot_id, $slot_claim, string $contentType = self::contentTypes['claimAvailableSlot'][0])
    {

        // verify the required parameter 'workspace_slug' is set
        if ($workspace_slug === null || (is_array($workspace_slug) && count($workspace_slug) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_slug when calling claimAvailableSlot'
            );
        }

        // verify the required parameter 'meet_id' is set
        if ($meet_id === null || (is_array($meet_id) && count($meet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $meet_id when calling claimAvailableSlot'
            );
        }

        // verify the required parameter 'slot_id' is set
        if ($slot_id === null || (is_array($slot_id) && count($slot_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $slot_id when calling claimAvailableSlot'
            );
        }

        // verify the required parameter 'slot_claim' is set
        if ($slot_claim === null || (is_array($slot_claim) && count($slot_claim) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $slot_claim when calling claimAvailableSlot'
            );
        }


        $resourcePath = '/v1/meet/public/{workspaceSlug}/{meetId}/available-slot/{slotId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_slug !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceSlug' . '}',
                ObjectSerializer::toPathValue($workspace_slug),
                $resourcePath
            );
        }
        // path params
        if ($meet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'meetId' . '}',
                ObjectSerializer::toPathValue($meet_id),
                $resourcePath
            );
        }
        // path params
        if ($slot_id !== null) {
            $resourcePath = str_replace(
                '{' . 'slotId' . '}',
                ObjectSerializer::toPathValue($slot_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($slot_claim)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($slot_claim));
            } else {
                $httpBody = $slot_claim;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAvailableSlot
     *
     * Get details on a single available slot
     *
     * @param  string $workspace_slug workspace_slug (required)
     * @param  string $meet_id meet_id (required)
     * @param  string $slot_id slot_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableSlot'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\AvailableSlotResponse
     */
    public function getAvailableSlot($workspace_slug, $meet_id, $slot_id, string $contentType = self::contentTypes['getAvailableSlot'][0])
    {
        list($response) = $this->getAvailableSlotWithHttpInfo($workspace_slug, $meet_id, $slot_id, $contentType);
        return $response;
    }

    /**
     * Operation getAvailableSlotWithHttpInfo
     *
     * Get details on a single available slot
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $slot_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableSlot'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\AvailableSlotResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAvailableSlotWithHttpInfo($workspace_slug, $meet_id, $slot_id, string $contentType = self::contentTypes['getAvailableSlot'][0])
    {
        $request = $this->getAvailableSlotRequest($workspace_slug, $meet_id, $slot_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\AvailableSlotResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\AvailableSlotResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\AvailableSlotResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\AvailableSlotResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\AvailableSlotResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAvailableSlotAsync
     *
     * Get details on a single available slot
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $slot_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableSlot'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAvailableSlotAsync($workspace_slug, $meet_id, $slot_id, string $contentType = self::contentTypes['getAvailableSlot'][0])
    {
        return $this->getAvailableSlotAsyncWithHttpInfo($workspace_slug, $meet_id, $slot_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAvailableSlotAsyncWithHttpInfo
     *
     * Get details on a single available slot
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $slot_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableSlot'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAvailableSlotAsyncWithHttpInfo($workspace_slug, $meet_id, $slot_id, string $contentType = self::contentTypes['getAvailableSlot'][0])
    {
        $returnType = '\cnb\api\Model\AvailableSlotResponse';
        $request = $this->getAvailableSlotRequest($workspace_slug, $meet_id, $slot_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAvailableSlot'
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $slot_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableSlot'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAvailableSlotRequest($workspace_slug, $meet_id, $slot_id, string $contentType = self::contentTypes['getAvailableSlot'][0])
    {

        // verify the required parameter 'workspace_slug' is set
        if ($workspace_slug === null || (is_array($workspace_slug) && count($workspace_slug) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_slug when calling getAvailableSlot'
            );
        }

        // verify the required parameter 'meet_id' is set
        if ($meet_id === null || (is_array($meet_id) && count($meet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $meet_id when calling getAvailableSlot'
            );
        }

        // verify the required parameter 'slot_id' is set
        if ($slot_id === null || (is_array($slot_id) && count($slot_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $slot_id when calling getAvailableSlot'
            );
        }


        $resourcePath = '/v1/meet/public/{workspaceSlug}/{meetId}/slot/{slotId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_slug !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceSlug' . '}',
                ObjectSerializer::toPathValue($workspace_slug),
                $resourcePath
            );
        }
        // path params
        if ($meet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'meetId' . '}',
                ObjectSerializer::toPathValue($meet_id),
                $resourcePath
            );
        }
        // path params
        if ($slot_id !== null) {
            $resourcePath = str_replace(
                '{' . 'slotId' . '}',
                ObjectSerializer::toPathValue($slot_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAvailableSlots
     *
     * Get all available slots for this account
     *
     * @param  string $workspace_slug workspace_slug (required)
     * @param  string $meet_id meet_id (required)
     * @param  \DateTime|null $date Optional date filter in yyyy-MM-dd format (e.g., 2025-09-14) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableSlots'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\AvailableSlotsResponse
     */
    public function getAvailableSlots($workspace_slug, $meet_id, $date = null, string $contentType = self::contentTypes['getAvailableSlots'][0])
    {
        list($response) = $this->getAvailableSlotsWithHttpInfo($workspace_slug, $meet_id, $date, $contentType);
        return $response;
    }

    /**
     * Operation getAvailableSlotsWithHttpInfo
     *
     * Get all available slots for this account
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  \DateTime|null $date Optional date filter in yyyy-MM-dd format (e.g., 2025-09-14) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableSlots'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\AvailableSlotsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAvailableSlotsWithHttpInfo($workspace_slug, $meet_id, $date = null, string $contentType = self::contentTypes['getAvailableSlots'][0])
    {
        $request = $this->getAvailableSlotsRequest($workspace_slug, $meet_id, $date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\AvailableSlotsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\AvailableSlotsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\AvailableSlotsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\AvailableSlotsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\AvailableSlotsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAvailableSlotsAsync
     *
     * Get all available slots for this account
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  \DateTime|null $date Optional date filter in yyyy-MM-dd format (e.g., 2025-09-14) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableSlots'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAvailableSlotsAsync($workspace_slug, $meet_id, $date = null, string $contentType = self::contentTypes['getAvailableSlots'][0])
    {
        return $this->getAvailableSlotsAsyncWithHttpInfo($workspace_slug, $meet_id, $date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAvailableSlotsAsyncWithHttpInfo
     *
     * Get all available slots for this account
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  \DateTime|null $date Optional date filter in yyyy-MM-dd format (e.g., 2025-09-14) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableSlots'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAvailableSlotsAsyncWithHttpInfo($workspace_slug, $meet_id, $date = null, string $contentType = self::contentTypes['getAvailableSlots'][0])
    {
        $returnType = '\cnb\api\Model\AvailableSlotsResponse';
        $request = $this->getAvailableSlotsRequest($workspace_slug, $meet_id, $date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAvailableSlots'
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  \DateTime|null $date Optional date filter in yyyy-MM-dd format (e.g., 2025-09-14) (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableSlots'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAvailableSlotsRequest($workspace_slug, $meet_id, $date = null, string $contentType = self::contentTypes['getAvailableSlots'][0])
    {

        // verify the required parameter 'workspace_slug' is set
        if ($workspace_slug === null || (is_array($workspace_slug) && count($workspace_slug) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_slug when calling getAvailableSlots'
            );
        }

        // verify the required parameter 'meet_id' is set
        if ($meet_id === null || (is_array($meet_id) && count($meet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $meet_id when calling getAvailableSlots'
            );
        }



        $resourcePath = '/v1/meet/public/{workspaceSlug}/{meetId}/available-slots';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date,
            'date', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($workspace_slug !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceSlug' . '}',
                ObjectSerializer::toPathValue($workspace_slug),
                $resourcePath
            );
        }
        // path params
        if ($meet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'meetId' . '}',
                ObjectSerializer::toPathValue($meet_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBookedSlot
     *
     * Return information about the already booked slot
     *
     * @param  string $workspace_slug workspace_slug (required)
     * @param  string $meet_id meet_id (required)
     * @param  string $confirmation_id confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBookedSlot'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\BookedAppointment
     */
    public function getBookedSlot($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getBookedSlot'][0])
    {
        list($response) = $this->getBookedSlotWithHttpInfo($workspace_slug, $meet_id, $confirmation_id, $contentType);
        return $response;
    }

    /**
     * Operation getBookedSlotWithHttpInfo
     *
     * Return information about the already booked slot
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBookedSlot'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\BookedAppointment, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBookedSlotWithHttpInfo($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getBookedSlot'][0])
    {
        $request = $this->getBookedSlotRequest($workspace_slug, $meet_id, $confirmation_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\BookedAppointment' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\BookedAppointment' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\BookedAppointment', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\BookedAppointment';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\BookedAppointment',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBookedSlotAsync
     *
     * Return information about the already booked slot
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBookedSlot'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBookedSlotAsync($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getBookedSlot'][0])
    {
        return $this->getBookedSlotAsyncWithHttpInfo($workspace_slug, $meet_id, $confirmation_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBookedSlotAsyncWithHttpInfo
     *
     * Return information about the already booked slot
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBookedSlot'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBookedSlotAsyncWithHttpInfo($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getBookedSlot'][0])
    {
        $returnType = '\cnb\api\Model\BookedAppointment';
        $request = $this->getBookedSlotRequest($workspace_slug, $meet_id, $confirmation_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBookedSlot'
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBookedSlot'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBookedSlotRequest($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getBookedSlot'][0])
    {

        // verify the required parameter 'workspace_slug' is set
        if ($workspace_slug === null || (is_array($workspace_slug) && count($workspace_slug) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_slug when calling getBookedSlot'
            );
        }

        // verify the required parameter 'meet_id' is set
        if ($meet_id === null || (is_array($meet_id) && count($meet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $meet_id when calling getBookedSlot'
            );
        }

        // verify the required parameter 'confirmation_id' is set
        if ($confirmation_id === null || (is_array($confirmation_id) && count($confirmation_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $confirmation_id when calling getBookedSlot'
            );
        }


        $resourcePath = '/v1/meet/public/{workspaceSlug}/{meetId}/booked-slot/{confirmationId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_slug !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceSlug' . '}',
                ObjectSerializer::toPathValue($workspace_slug),
                $resourcePath
            );
        }
        // path params
        if ($meet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'meetId' . '}',
                ObjectSerializer::toPathValue($meet_id),
                $resourcePath
            );
        }
        // path params
        if ($confirmation_id !== null) {
            $resourcePath = str_replace(
                '{' . 'confirmationId' . '}',
                ObjectSerializer::toPathValue($confirmation_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFields
     *
     * Get all available slots for this account
     *
     * @param  string $workspace_slug workspace_slug (required)
     * @param  string $meet_id meet_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFields'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\SlotFields
     */
    public function getFields($workspace_slug, $meet_id, string $contentType = self::contentTypes['getFields'][0])
    {
        list($response) = $this->getFieldsWithHttpInfo($workspace_slug, $meet_id, $contentType);
        return $response;
    }

    /**
     * Operation getFieldsWithHttpInfo
     *
     * Get all available slots for this account
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFields'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\SlotFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFieldsWithHttpInfo($workspace_slug, $meet_id, string $contentType = self::contentTypes['getFields'][0])
    {
        $request = $this->getFieldsRequest($workspace_slug, $meet_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\SlotFields' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\SlotFields' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\SlotFields', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\SlotFields';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\SlotFields',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getFieldsAsync
     *
     * Get all available slots for this account
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFields'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFieldsAsync($workspace_slug, $meet_id, string $contentType = self::contentTypes['getFields'][0])
    {
        return $this->getFieldsAsyncWithHttpInfo($workspace_slug, $meet_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getFieldsAsyncWithHttpInfo
     *
     * Get all available slots for this account
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFields'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFieldsAsyncWithHttpInfo($workspace_slug, $meet_id, string $contentType = self::contentTypes['getFields'][0])
    {
        $returnType = '\cnb\api\Model\SlotFields';
        $request = $this->getFieldsRequest($workspace_slug, $meet_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFields'
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFields'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getFieldsRequest($workspace_slug, $meet_id, string $contentType = self::contentTypes['getFields'][0])
    {

        // verify the required parameter 'workspace_slug' is set
        if ($workspace_slug === null || (is_array($workspace_slug) && count($workspace_slug) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_slug when calling getFields'
            );
        }

        // verify the required parameter 'meet_id' is set
        if ($meet_id === null || (is_array($meet_id) && count($meet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $meet_id when calling getFields'
            );
        }


        $resourcePath = '/v1/meet/public/{workspaceSlug}/{meetId}/fields';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_slug !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceSlug' . '}',
                ObjectSerializer::toPathValue($workspace_slug),
                $resourcePath
            );
        }
        // path params
        if ($meet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'meetId' . '}',
                ObjectSerializer::toPathValue($meet_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getIcsForBookedSlot
     *
     * Get the ICS for an already booked slot
     *
     * @param  string $workspace_slug workspace_slug (required)
     * @param  string $meet_id meet_id (required)
     * @param  string $confirmation_id confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getIcsForBookedSlot'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\SplFileObject
     */
    public function getIcsForBookedSlot($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getIcsForBookedSlot'][0])
    {
        list($response) = $this->getIcsForBookedSlotWithHttpInfo($workspace_slug, $meet_id, $confirmation_id, $contentType);
        return $response;
    }

    /**
     * Operation getIcsForBookedSlotWithHttpInfo
     *
     * Get the ICS for an already booked slot
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getIcsForBookedSlot'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getIcsForBookedSlotWithHttpInfo($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getIcsForBookedSlot'][0])
    {
        $request = $this->getIcsForBookedSlotRequest($workspace_slug, $meet_id, $confirmation_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SplFileObject' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\SplFileObject';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getIcsForBookedSlotAsync
     *
     * Get the ICS for an already booked slot
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getIcsForBookedSlot'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getIcsForBookedSlotAsync($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getIcsForBookedSlot'][0])
    {
        return $this->getIcsForBookedSlotAsyncWithHttpInfo($workspace_slug, $meet_id, $confirmation_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getIcsForBookedSlotAsyncWithHttpInfo
     *
     * Get the ICS for an already booked slot
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getIcsForBookedSlot'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getIcsForBookedSlotAsyncWithHttpInfo($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getIcsForBookedSlot'][0])
    {
        $returnType = '\SplFileObject';
        $request = $this->getIcsForBookedSlotRequest($workspace_slug, $meet_id, $confirmation_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getIcsForBookedSlot'
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getIcsForBookedSlot'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getIcsForBookedSlotRequest($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getIcsForBookedSlot'][0])
    {

        // verify the required parameter 'workspace_slug' is set
        if ($workspace_slug === null || (is_array($workspace_slug) && count($workspace_slug) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_slug when calling getIcsForBookedSlot'
            );
        }

        // verify the required parameter 'meet_id' is set
        if ($meet_id === null || (is_array($meet_id) && count($meet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $meet_id when calling getIcsForBookedSlot'
            );
        }

        // verify the required parameter 'confirmation_id' is set
        if ($confirmation_id === null || (is_array($confirmation_id) && count($confirmation_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $confirmation_id when calling getIcsForBookedSlot'
            );
        }


        $resourcePath = '/v1/meet/public/{workspaceSlug}/{meetId}/booked-slot/{confirmationId}.ics';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_slug !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceSlug' . '}',
                ObjectSerializer::toPathValue($workspace_slug),
                $resourcePath
            );
        }
        // path params
        if ($meet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'meetId' . '}',
                ObjectSerializer::toPathValue($meet_id),
                $resourcePath
            );
        }
        // path params
        if ($confirmation_id !== null) {
            $resourcePath = str_replace(
                '{' . 'confirmationId' . '}',
                ObjectSerializer::toPathValue($confirmation_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', 'text/calendar', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getIcsForBookedSlotUrlEndpoint
     *
     * Get the ICS URL endpoint for an already booked slot. This points to the public #getIcsForBookedSlot endpoint
     *
     * @param  string $workspace_slug workspace_slug (required)
     * @param  string $meet_id meet_id (required)
     * @param  string $confirmation_id confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getIcsForBookedSlotUrlEndpoint'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|string
     */
    public function getIcsForBookedSlotUrlEndpoint($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getIcsForBookedSlotUrlEndpoint'][0])
    {
        list($response) = $this->getIcsForBookedSlotUrlEndpointWithHttpInfo($workspace_slug, $meet_id, $confirmation_id, $contentType);
        return $response;
    }

    /**
     * Operation getIcsForBookedSlotUrlEndpointWithHttpInfo
     *
     * Get the ICS URL endpoint for an already booked slot. This points to the public #getIcsForBookedSlot endpoint
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getIcsForBookedSlotUrlEndpoint'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getIcsForBookedSlotUrlEndpointWithHttpInfo($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getIcsForBookedSlotUrlEndpoint'][0])
    {
        $request = $this->getIcsForBookedSlotUrlEndpointRequest($workspace_slug, $meet_id, $confirmation_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getIcsForBookedSlotUrlEndpointAsync
     *
     * Get the ICS URL endpoint for an already booked slot. This points to the public #getIcsForBookedSlot endpoint
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getIcsForBookedSlotUrlEndpoint'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getIcsForBookedSlotUrlEndpointAsync($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getIcsForBookedSlotUrlEndpoint'][0])
    {
        return $this->getIcsForBookedSlotUrlEndpointAsyncWithHttpInfo($workspace_slug, $meet_id, $confirmation_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getIcsForBookedSlotUrlEndpointAsyncWithHttpInfo
     *
     * Get the ICS URL endpoint for an already booked slot. This points to the public #getIcsForBookedSlot endpoint
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getIcsForBookedSlotUrlEndpoint'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getIcsForBookedSlotUrlEndpointAsyncWithHttpInfo($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getIcsForBookedSlotUrlEndpoint'][0])
    {
        $returnType = 'string';
        $request = $this->getIcsForBookedSlotUrlEndpointRequest($workspace_slug, $meet_id, $confirmation_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getIcsForBookedSlotUrlEndpoint'
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $confirmation_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getIcsForBookedSlotUrlEndpoint'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getIcsForBookedSlotUrlEndpointRequest($workspace_slug, $meet_id, $confirmation_id, string $contentType = self::contentTypes['getIcsForBookedSlotUrlEndpoint'][0])
    {

        // verify the required parameter 'workspace_slug' is set
        if ($workspace_slug === null || (is_array($workspace_slug) && count($workspace_slug) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_slug when calling getIcsForBookedSlotUrlEndpoint'
            );
        }

        // verify the required parameter 'meet_id' is set
        if ($meet_id === null || (is_array($meet_id) && count($meet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $meet_id when calling getIcsForBookedSlotUrlEndpoint'
            );
        }

        // verify the required parameter 'confirmation_id' is set
        if ($confirmation_id === null || (is_array($confirmation_id) && count($confirmation_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $confirmation_id when calling getIcsForBookedSlotUrlEndpoint'
            );
        }


        $resourcePath = '/v1/meet/public/{workspaceSlug}/{meetId}/booked-slot/{confirmationId}/ics';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_slug !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceSlug' . '}',
                ObjectSerializer::toPathValue($workspace_slug),
                $resourcePath
            );
        }
        // path params
        if ($meet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'meetId' . '}',
                ObjectSerializer::toPathValue($meet_id),
                $resourcePath
            );
        }
        // path params
        if ($confirmation_id !== null) {
            $resourcePath = str_replace(
                '{' . 'confirmationId' . '}',
                ObjectSerializer::toPathValue($confirmation_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation isValid
     *
     * Check if this domain is valid for this meeting
     *
     * @param  string $workspace_slug workspace_slug (required)
     * @param  string $meet_id meet_id (required)
     * @param  string $domain_name domain_name (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isValid'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ValidResponse
     */
    public function isValid($workspace_slug, $meet_id, $domain_name, string $contentType = self::contentTypes['isValid'][0])
    {
        list($response) = $this->isValidWithHttpInfo($workspace_slug, $meet_id, $domain_name, $contentType);
        return $response;
    }

    /**
     * Operation isValidWithHttpInfo
     *
     * Check if this domain is valid for this meeting
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $domain_name (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isValid'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ValidResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function isValidWithHttpInfo($workspace_slug, $meet_id, $domain_name, string $contentType = self::contentTypes['isValid'][0])
    {
        $request = $this->isValidRequest($workspace_slug, $meet_id, $domain_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ValidResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ValidResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ValidResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ValidResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ValidResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation isValidAsync
     *
     * Check if this domain is valid for this meeting
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $domain_name (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isValid'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function isValidAsync($workspace_slug, $meet_id, $domain_name, string $contentType = self::contentTypes['isValid'][0])
    {
        return $this->isValidAsyncWithHttpInfo($workspace_slug, $meet_id, $domain_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation isValidAsyncWithHttpInfo
     *
     * Check if this domain is valid for this meeting
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $domain_name (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isValid'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function isValidAsyncWithHttpInfo($workspace_slug, $meet_id, $domain_name, string $contentType = self::contentTypes['isValid'][0])
    {
        $returnType = '\cnb\api\Model\ValidResponse';
        $request = $this->isValidRequest($workspace_slug, $meet_id, $domain_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'isValid'
     *
     * @param  string $workspace_slug (required)
     * @param  string $meet_id (required)
     * @param  string $domain_name (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['isValid'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function isValidRequest($workspace_slug, $meet_id, $domain_name, string $contentType = self::contentTypes['isValid'][0])
    {

        // verify the required parameter 'workspace_slug' is set
        if ($workspace_slug === null || (is_array($workspace_slug) && count($workspace_slug) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_slug when calling isValid'
            );
        }

        // verify the required parameter 'meet_id' is set
        if ($meet_id === null || (is_array($meet_id) && count($meet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $meet_id when calling isValid'
            );
        }

        // verify the required parameter 'domain_name' is set
        if ($domain_name === null || (is_array($domain_name) && count($domain_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_name when calling isValid'
            );
        }


        $resourcePath = '/v1/meet/public/{workspaceSlug}/{meetId}/validation/{domainName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_slug !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceSlug' . '}',
                ObjectSerializer::toPathValue($workspace_slug),
                $resourcePath
            );
        }
        // path params
        if ($meet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'meetId' . '}',
                ObjectSerializer::toPathValue($meet_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_name !== null) {
            $resourcePath = str_replace(
                '{' . 'domainName' . '}',
                ObjectSerializer::toPathValue($domain_name),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
