<?php
/**
 * ChatApi
 * PHP version 7.4
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CallNowButton API
 *
 * API for CallNowButton. Includes auth, domains, buttons/actions/conditions, but also chat and admin features.
 *
 * The version of the OpenAPI document: 0.0.219-local
 * Contact: support@nowbuttons.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace cnb\api\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use cnb\api\ApiException;
use cnb\api\Configuration;
use cnb\api\HeaderSelector;
use cnb\api\ObjectSerializer;

/**
 * ChatApi Class Doc Comment
 *
 * @category Class
 * @package  cnb\api
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ChatApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'addMemberAsChatAgent' => [
            'application/json',
        ],
        'addParticipant' => [
            'application/json',
        ],
        'createPersona' => [
            'application/json',
        ],
        'createPrivateNote' => [
            'application/json',
        ],
        'createQuickReply' => [
            'application/json',
        ],
        'createWorkspaceDomainPersona' => [
            'application/json',
        ],
        'delete' => [
            'application/json',
        ],
        'deleteQuickReply' => [
            'application/json',
        ],
        'deleteWorkspace' => [
            'application/json',
        ],
        'disableChatUser' => [
            'application/json',
        ],
        'enableChatUser' => [
            'application/json',
        ],
        'events' => [
            'application/json',
        ],
        'exportChatChannelAsHtml' => [
            'application/json',
        ],
        'exportChatChannelAsPdf' => [
            'application/json',
        ],
        'get' => [
            'application/json',
        ],
        'getAll' => [
            'application/json',
        ],
        'getAllBots' => [
            'application/json',
        ],
        'getAllPersonas' => [
            'application/json',
        ],
        'getFull' => [
            'application/json',
        ],
        'getPersona' => [
            'application/json',
        ],
        'getPrivateNotes' => [
            'application/json',
        ],
        'getQuickReplies' => [
            'application/json',
        ],
        'getToken' => [
            'application/json',
        ],
        'history' => [
            'application/json',
        ],
        'participants' => [
            'application/json',
        ],
        'removeParticipant' => [
            'application/json',
        ],
        'updateChatClientPersona' => [
            'application/json',
        ],
        'updateName' => [
            'application/json',
        ],
        'updateParticipantLastReadMessage' => [
            'application/json',
        ],
        'updatePersona' => [
            'application/json',
        ],
        'updatePrivateNote' => [
            'application/json',
        ],
        'updateQuickReply' => [
            'application/json',
        ],
        'updateResolution' => [
            'application/json',
        ],
        'updateStatus' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation addMemberAsChatAgent
     *
     * Add a (new) &#x60;User&#x60; as a Member to a Workspace. Also creates a Chat Persona
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $member_id member_id (required)
     * @param  \cnb\api\Model\ChatAgentAddRequest $chat_agent_add_request chat_agent_add_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addMemberAsChatAgent'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\Workspace
     */
    public function addMemberAsChatAgent($workspace_id, $member_id, $chat_agent_add_request, string $contentType = self::contentTypes['addMemberAsChatAgent'][0])
    {
        list($response) = $this->addMemberAsChatAgentWithHttpInfo($workspace_id, $member_id, $chat_agent_add_request, $contentType);
        return $response;
    }

    /**
     * Operation addMemberAsChatAgentWithHttpInfo
     *
     * Add a (new) &#x60;User&#x60; as a Member to a Workspace. Also creates a Chat Persona
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  \cnb\api\Model\ChatAgentAddRequest $chat_agent_add_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addMemberAsChatAgent'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\Workspace, HTTP status code, HTTP response headers (array of strings)
     */
    public function addMemberAsChatAgentWithHttpInfo($workspace_id, $member_id, $chat_agent_add_request, string $contentType = self::contentTypes['addMemberAsChatAgent'][0])
    {
        $request = $this->addMemberAsChatAgentRequest($workspace_id, $member_id, $chat_agent_add_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\Workspace' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\Workspace' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\Workspace', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\Workspace';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\Workspace',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addMemberAsChatAgentAsync
     *
     * Add a (new) &#x60;User&#x60; as a Member to a Workspace. Also creates a Chat Persona
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  \cnb\api\Model\ChatAgentAddRequest $chat_agent_add_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addMemberAsChatAgent'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addMemberAsChatAgentAsync($workspace_id, $member_id, $chat_agent_add_request, string $contentType = self::contentTypes['addMemberAsChatAgent'][0])
    {
        return $this->addMemberAsChatAgentAsyncWithHttpInfo($workspace_id, $member_id, $chat_agent_add_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addMemberAsChatAgentAsyncWithHttpInfo
     *
     * Add a (new) &#x60;User&#x60; as a Member to a Workspace. Also creates a Chat Persona
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  \cnb\api\Model\ChatAgentAddRequest $chat_agent_add_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addMemberAsChatAgent'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addMemberAsChatAgentAsyncWithHttpInfo($workspace_id, $member_id, $chat_agent_add_request, string $contentType = self::contentTypes['addMemberAsChatAgent'][0])
    {
        $returnType = '\cnb\api\Model\Workspace';
        $request = $this->addMemberAsChatAgentRequest($workspace_id, $member_id, $chat_agent_add_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addMemberAsChatAgent'
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  \cnb\api\Model\ChatAgentAddRequest $chat_agent_add_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addMemberAsChatAgent'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addMemberAsChatAgentRequest($workspace_id, $member_id, $chat_agent_add_request, string $contentType = self::contentTypes['addMemberAsChatAgent'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling addMemberAsChatAgent'
            );
        }

        // verify the required parameter 'member_id' is set
        if ($member_id === null || (is_array($member_id) && count($member_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $member_id when calling addMemberAsChatAgent'
            );
        }

        // verify the required parameter 'chat_agent_add_request' is set
        if ($chat_agent_add_request === null || (is_array($chat_agent_add_request) && count($chat_agent_add_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chat_agent_add_request when calling addMemberAsChatAgent'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/member/{memberId}/addagent';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($member_id !== null) {
            $resourcePath = str_replace(
                '{' . 'memberId' . '}',
                ObjectSerializer::toPathValue($member_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($chat_agent_add_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($chat_agent_add_request));
            } else {
                $httpBody = $chat_agent_add_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addParticipant
     *
     * Add a Chat Agent as a participant to this Channel.
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $persona_id persona_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addParticipant'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel
     */
    public function addParticipant($workspace_id, $channel_id, $persona_id, string $contentType = self::contentTypes['addParticipant'][0])
    {
        list($response) = $this->addParticipantWithHttpInfo($workspace_id, $channel_id, $persona_id, $contentType);
        return $response;
    }

    /**
     * Operation addParticipantWithHttpInfo
     *
     * Add a Chat Agent as a participant to this Channel.
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addParticipant'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel, HTTP status code, HTTP response headers (array of strings)
     */
    public function addParticipantWithHttpInfo($workspace_id, $channel_id, $persona_id, string $contentType = self::contentTypes['addParticipant'][0])
    {
        $request = $this->addParticipantRequest($workspace_id, $channel_id, $persona_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannel' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannel' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannel', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannel';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannel',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addParticipantAsync
     *
     * Add a Chat Agent as a participant to this Channel.
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addParticipant'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addParticipantAsync($workspace_id, $channel_id, $persona_id, string $contentType = self::contentTypes['addParticipant'][0])
    {
        return $this->addParticipantAsyncWithHttpInfo($workspace_id, $channel_id, $persona_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addParticipantAsyncWithHttpInfo
     *
     * Add a Chat Agent as a participant to this Channel.
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addParticipant'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addParticipantAsyncWithHttpInfo($workspace_id, $channel_id, $persona_id, string $contentType = self::contentTypes['addParticipant'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannel';
        $request = $this->addParticipantRequest($workspace_id, $channel_id, $persona_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addParticipant'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addParticipant'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addParticipantRequest($workspace_id, $channel_id, $persona_id, string $contentType = self::contentTypes['addParticipant'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling addParticipant'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling addParticipant'
            );
        }

        // verify the required parameter 'persona_id' is set
        if ($persona_id === null || (is_array($persona_id) && count($persona_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $persona_id when calling addParticipant'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/participant/{personaId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }
        // path params
        if ($persona_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personaId' . '}',
                ObjectSerializer::toPathValue($persona_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPersona
     *
     * create a Chat User profile for the provided WorkspaceMember.
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $member_id member_id (required)
     * @param  \cnb\api\Model\ChatUserCreateRequest $chat_user_create_request chat_user_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPersona'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatAgentPersona|\cnb\api\Model\ApiServerExceptionResponse
     */
    public function createPersona($workspace_id, $member_id, $chat_user_create_request, string $contentType = self::contentTypes['createPersona'][0])
    {
        list($response) = $this->createPersonaWithHttpInfo($workspace_id, $member_id, $chat_user_create_request, $contentType);
        return $response;
    }

    /**
     * Operation createPersonaWithHttpInfo
     *
     * create a Chat User profile for the provided WorkspaceMember.
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  \cnb\api\Model\ChatUserCreateRequest $chat_user_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPersona'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatAgentPersona|\cnb\api\Model\ApiServerExceptionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPersonaWithHttpInfo($workspace_id, $member_id, $chat_user_create_request, string $contentType = self::contentTypes['createPersona'][0])
    {
        $request = $this->createPersonaRequest($workspace_id, $member_id, $chat_user_create_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatAgentPersona' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatAgentPersona' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatAgentPersona', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 406:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatAgentPersona';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatAgentPersona',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 406:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPersonaAsync
     *
     * create a Chat User profile for the provided WorkspaceMember.
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  \cnb\api\Model\ChatUserCreateRequest $chat_user_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPersonaAsync($workspace_id, $member_id, $chat_user_create_request, string $contentType = self::contentTypes['createPersona'][0])
    {
        return $this->createPersonaAsyncWithHttpInfo($workspace_id, $member_id, $chat_user_create_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPersonaAsyncWithHttpInfo
     *
     * create a Chat User profile for the provided WorkspaceMember.
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  \cnb\api\Model\ChatUserCreateRequest $chat_user_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPersonaAsyncWithHttpInfo($workspace_id, $member_id, $chat_user_create_request, string $contentType = self::contentTypes['createPersona'][0])
    {
        $returnType = '\cnb\api\Model\ChatAgentPersona';
        $request = $this->createPersonaRequest($workspace_id, $member_id, $chat_user_create_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPersona'
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  \cnb\api\Model\ChatUserCreateRequest $chat_user_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPersonaRequest($workspace_id, $member_id, $chat_user_create_request, string $contentType = self::contentTypes['createPersona'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling createPersona'
            );
        }

        // verify the required parameter 'member_id' is set
        if ($member_id === null || (is_array($member_id) && count($member_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $member_id when calling createPersona'
            );
        }

        // verify the required parameter 'chat_user_create_request' is set
        if ($chat_user_create_request === null || (is_array($chat_user_create_request) && count($chat_user_create_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chat_user_create_request when calling createPersona'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/member/{memberId}/persona';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($member_id !== null) {
            $resourcePath = str_replace(
                '{' . 'memberId' . '}',
                ObjectSerializer::toPathValue($member_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($chat_user_create_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($chat_user_create_request));
            } else {
                $httpBody = $chat_user_create_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPrivateNote
     *
     * Create a new private note for a channel
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  \cnb\api\Model\PrivateNoteRequest $private_note_request private_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPrivateNote'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel
     */
    public function createPrivateNote($workspace_id, $channel_id, $private_note_request, string $contentType = self::contentTypes['createPrivateNote'][0])
    {
        list($response) = $this->createPrivateNoteWithHttpInfo($workspace_id, $channel_id, $private_note_request, $contentType);
        return $response;
    }

    /**
     * Operation createPrivateNoteWithHttpInfo
     *
     * Create a new private note for a channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\PrivateNoteRequest $private_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPrivateNote'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPrivateNoteWithHttpInfo($workspace_id, $channel_id, $private_note_request, string $contentType = self::contentTypes['createPrivateNote'][0])
    {
        $request = $this->createPrivateNoteRequest($workspace_id, $channel_id, $private_note_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannel' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannel' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannel', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannel';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannel',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPrivateNoteAsync
     *
     * Create a new private note for a channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\PrivateNoteRequest $private_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPrivateNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPrivateNoteAsync($workspace_id, $channel_id, $private_note_request, string $contentType = self::contentTypes['createPrivateNote'][0])
    {
        return $this->createPrivateNoteAsyncWithHttpInfo($workspace_id, $channel_id, $private_note_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPrivateNoteAsyncWithHttpInfo
     *
     * Create a new private note for a channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\PrivateNoteRequest $private_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPrivateNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPrivateNoteAsyncWithHttpInfo($workspace_id, $channel_id, $private_note_request, string $contentType = self::contentTypes['createPrivateNote'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannel';
        $request = $this->createPrivateNoteRequest($workspace_id, $channel_id, $private_note_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPrivateNote'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\PrivateNoteRequest $private_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createPrivateNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createPrivateNoteRequest($workspace_id, $channel_id, $private_note_request, string $contentType = self::contentTypes['createPrivateNote'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling createPrivateNote'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling createPrivateNote'
            );
        }

        // verify the required parameter 'private_note_request' is set
        if ($private_note_request === null || (is_array($private_note_request) && count($private_note_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $private_note_request when calling createPrivateNote'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/notes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($private_note_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($private_note_request));
            } else {
                $httpBody = $private_note_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createQuickReply
     *
     * Create a quick reply
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $domain_id domain_id (required)
     * @param  \cnb\api\Model\CreateQuickReplyRequest $create_quick_reply_request create_quick_reply_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createQuickReply'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\QuickReply
     */
    public function createQuickReply($workspace_id, $domain_id, $create_quick_reply_request, string $contentType = self::contentTypes['createQuickReply'][0])
    {
        list($response) = $this->createQuickReplyWithHttpInfo($workspace_id, $domain_id, $create_quick_reply_request, $contentType);
        return $response;
    }

    /**
     * Operation createQuickReplyWithHttpInfo
     *
     * Create a quick reply
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  \cnb\api\Model\CreateQuickReplyRequest $create_quick_reply_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createQuickReply'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\QuickReply, HTTP status code, HTTP response headers (array of strings)
     */
    public function createQuickReplyWithHttpInfo($workspace_id, $domain_id, $create_quick_reply_request, string $contentType = self::contentTypes['createQuickReply'][0])
    {
        $request = $this->createQuickReplyRequest($workspace_id, $domain_id, $create_quick_reply_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\QuickReply' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\QuickReply' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\QuickReply', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\QuickReply';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\QuickReply',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createQuickReplyAsync
     *
     * Create a quick reply
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  \cnb\api\Model\CreateQuickReplyRequest $create_quick_reply_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createQuickReply'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createQuickReplyAsync($workspace_id, $domain_id, $create_quick_reply_request, string $contentType = self::contentTypes['createQuickReply'][0])
    {
        return $this->createQuickReplyAsyncWithHttpInfo($workspace_id, $domain_id, $create_quick_reply_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createQuickReplyAsyncWithHttpInfo
     *
     * Create a quick reply
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  \cnb\api\Model\CreateQuickReplyRequest $create_quick_reply_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createQuickReply'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createQuickReplyAsyncWithHttpInfo($workspace_id, $domain_id, $create_quick_reply_request, string $contentType = self::contentTypes['createQuickReply'][0])
    {
        $returnType = '\cnb\api\Model\QuickReply';
        $request = $this->createQuickReplyRequest($workspace_id, $domain_id, $create_quick_reply_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createQuickReply'
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  \cnb\api\Model\CreateQuickReplyRequest $create_quick_reply_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createQuickReply'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createQuickReplyRequest($workspace_id, $domain_id, $create_quick_reply_request, string $contentType = self::contentTypes['createQuickReply'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling createQuickReply'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling createQuickReply'
            );
        }

        // verify the required parameter 'create_quick_reply_request' is set
        if ($create_quick_reply_request === null || (is_array($create_quick_reply_request) && count($create_quick_reply_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_quick_reply_request when calling createQuickReply'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/{domainId}/quickreply';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domainId' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_quick_reply_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_quick_reply_request));
            } else {
                $httpBody = $create_quick_reply_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createWorkspaceDomainPersona
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $domain_id domain_id (required)
     * @param  \cnb\api\Model\WorkspaceDomainPersonaCreateRequest $workspace_domain_persona_create_request workspace_domain_persona_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWorkspaceDomainPersona'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createWorkspaceDomainPersona($workspace_id, $domain_id, $workspace_domain_persona_create_request, string $contentType = self::contentTypes['createWorkspaceDomainPersona'][0])
    {
        $this->createWorkspaceDomainPersonaWithHttpInfo($workspace_id, $domain_id, $workspace_domain_persona_create_request, $contentType);
    }

    /**
     * Operation createWorkspaceDomainPersonaWithHttpInfo
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  \cnb\api\Model\WorkspaceDomainPersonaCreateRequest $workspace_domain_persona_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWorkspaceDomainPersona'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWorkspaceDomainPersonaWithHttpInfo($workspace_id, $domain_id, $workspace_domain_persona_create_request, string $contentType = self::contentTypes['createWorkspaceDomainPersona'][0])
    {
        $request = $this->createWorkspaceDomainPersonaRequest($workspace_id, $domain_id, $workspace_domain_persona_create_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createWorkspaceDomainPersonaAsync
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  \cnb\api\Model\WorkspaceDomainPersonaCreateRequest $workspace_domain_persona_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWorkspaceDomainPersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWorkspaceDomainPersonaAsync($workspace_id, $domain_id, $workspace_domain_persona_create_request, string $contentType = self::contentTypes['createWorkspaceDomainPersona'][0])
    {
        return $this->createWorkspaceDomainPersonaAsyncWithHttpInfo($workspace_id, $domain_id, $workspace_domain_persona_create_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createWorkspaceDomainPersonaAsyncWithHttpInfo
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  \cnb\api\Model\WorkspaceDomainPersonaCreateRequest $workspace_domain_persona_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWorkspaceDomainPersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWorkspaceDomainPersonaAsyncWithHttpInfo($workspace_id, $domain_id, $workspace_domain_persona_create_request, string $contentType = self::contentTypes['createWorkspaceDomainPersona'][0])
    {
        $returnType = '';
        $request = $this->createWorkspaceDomainPersonaRequest($workspace_id, $domain_id, $workspace_domain_persona_create_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createWorkspaceDomainPersona'
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  \cnb\api\Model\WorkspaceDomainPersonaCreateRequest $workspace_domain_persona_create_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWorkspaceDomainPersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createWorkspaceDomainPersonaRequest($workspace_id, $domain_id, $workspace_domain_persona_create_request, string $contentType = self::contentTypes['createWorkspaceDomainPersona'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling createWorkspaceDomainPersona'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling createWorkspaceDomainPersona'
            );
        }

        // verify the required parameter 'workspace_domain_persona_create_request' is set
        if ($workspace_domain_persona_create_request === null || (is_array($workspace_domain_persona_create_request) && count($workspace_domain_persona_create_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_domain_persona_create_request when calling createWorkspaceDomainPersona'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/domain/{domainId}/persona';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domainId' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($workspace_domain_persona_create_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($workspace_domain_persona_create_request));
            } else {
                $httpBody = $workspace_domain_persona_create_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation delete
     *
     * Deletes a Chat Channel of this user
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['delete'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel
     */
    public function delete($workspace_id, $channel_id, string $contentType = self::contentTypes['delete'][0])
    {
        list($response) = $this->deleteWithHttpInfo($workspace_id, $channel_id, $contentType);
        return $response;
    }

    /**
     * Operation deleteWithHttpInfo
     *
     * Deletes a Chat Channel of this user
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['delete'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['delete'][0])
    {
        $request = $this->deleteRequest($workspace_id, $channel_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannel' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannel' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannel', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannel';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannel',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteAsync
     *
     * Deletes a Chat Channel of this user
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['delete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAsync($workspace_id, $channel_id, string $contentType = self::contentTypes['delete'][0])
    {
        return $this->deleteAsyncWithHttpInfo($workspace_id, $channel_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteAsyncWithHttpInfo
     *
     * Deletes a Chat Channel of this user
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['delete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAsyncWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['delete'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannel';
        $request = $this->deleteRequest($workspace_id, $channel_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'delete'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['delete'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteRequest($workspace_id, $channel_id, string $contentType = self::contentTypes['delete'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling delete'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling delete'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteQuickReply
     *
     * Delete a quick reply
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $domain_id domain_id (required)
     * @param  string $quick_reply_id quick_reply_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteQuickReply'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\DeleteQuickReplyResponse
     */
    public function deleteQuickReply($workspace_id, $domain_id, $quick_reply_id, string $contentType = self::contentTypes['deleteQuickReply'][0])
    {
        list($response) = $this->deleteQuickReplyWithHttpInfo($workspace_id, $domain_id, $quick_reply_id, $contentType);
        return $response;
    }

    /**
     * Operation deleteQuickReplyWithHttpInfo
     *
     * Delete a quick reply
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $quick_reply_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteQuickReply'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\DeleteQuickReplyResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteQuickReplyWithHttpInfo($workspace_id, $domain_id, $quick_reply_id, string $contentType = self::contentTypes['deleteQuickReply'][0])
    {
        $request = $this->deleteQuickReplyRequest($workspace_id, $domain_id, $quick_reply_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\DeleteQuickReplyResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\DeleteQuickReplyResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\DeleteQuickReplyResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\DeleteQuickReplyResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\DeleteQuickReplyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteQuickReplyAsync
     *
     * Delete a quick reply
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $quick_reply_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteQuickReply'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteQuickReplyAsync($workspace_id, $domain_id, $quick_reply_id, string $contentType = self::contentTypes['deleteQuickReply'][0])
    {
        return $this->deleteQuickReplyAsyncWithHttpInfo($workspace_id, $domain_id, $quick_reply_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteQuickReplyAsyncWithHttpInfo
     *
     * Delete a quick reply
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $quick_reply_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteQuickReply'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteQuickReplyAsyncWithHttpInfo($workspace_id, $domain_id, $quick_reply_id, string $contentType = self::contentTypes['deleteQuickReply'][0])
    {
        $returnType = '\cnb\api\Model\DeleteQuickReplyResponse';
        $request = $this->deleteQuickReplyRequest($workspace_id, $domain_id, $quick_reply_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteQuickReply'
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $quick_reply_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteQuickReply'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteQuickReplyRequest($workspace_id, $domain_id, $quick_reply_id, string $contentType = self::contentTypes['deleteQuickReply'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling deleteQuickReply'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling deleteQuickReply'
            );
        }

        // verify the required parameter 'quick_reply_id' is set
        if ($quick_reply_id === null || (is_array($quick_reply_id) && count($quick_reply_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $quick_reply_id when calling deleteQuickReply'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/{domainId}/quickreply/{quickReplyId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domainId' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }
        // path params
        if ($quick_reply_id !== null) {
            $resourcePath = str_replace(
                '{' . 'quickReplyId' . '}',
                ObjectSerializer::toPathValue($quick_reply_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteWorkspace
     *
     * Delete a Workspace. This is permanent and can only be done if a workspace does not contain any domains.
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWorkspace'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\DeleteWorkspaceResponse
     */
    public function deleteWorkspace($workspace_id, string $contentType = self::contentTypes['deleteWorkspace'][0])
    {
        list($response) = $this->deleteWorkspaceWithHttpInfo($workspace_id, $contentType);
        return $response;
    }

    /**
     * Operation deleteWorkspaceWithHttpInfo
     *
     * Delete a Workspace. This is permanent and can only be done if a workspace does not contain any domains.
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWorkspace'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\DeleteWorkspaceResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWorkspaceWithHttpInfo($workspace_id, string $contentType = self::contentTypes['deleteWorkspace'][0])
    {
        $request = $this->deleteWorkspaceRequest($workspace_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\DeleteWorkspaceResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\DeleteWorkspaceResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\DeleteWorkspaceResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\DeleteWorkspaceResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\DeleteWorkspaceResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteWorkspaceAsync
     *
     * Delete a Workspace. This is permanent and can only be done if a workspace does not contain any domains.
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWorkspace'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWorkspaceAsync($workspace_id, string $contentType = self::contentTypes['deleteWorkspace'][0])
    {
        return $this->deleteWorkspaceAsyncWithHttpInfo($workspace_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteWorkspaceAsyncWithHttpInfo
     *
     * Delete a Workspace. This is permanent and can only be done if a workspace does not contain any domains.
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWorkspace'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWorkspaceAsyncWithHttpInfo($workspace_id, string $contentType = self::contentTypes['deleteWorkspace'][0])
    {
        $returnType = '\cnb\api\Model\DeleteWorkspaceResponse';
        $request = $this->deleteWorkspaceRequest($workspace_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteWorkspace'
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWorkspace'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteWorkspaceRequest($workspace_id, string $contentType = self::contentTypes['deleteWorkspace'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling deleteWorkspace'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation disableChatUser
     *
     * Remove the chat user role from the current user
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disableChatUser'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\UserModifiedResponse|\cnb\api\Model\ApiServerException
     */
    public function disableChatUser(string $contentType = self::contentTypes['disableChatUser'][0])
    {
        list($response) = $this->disableChatUserWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation disableChatUserWithHttpInfo
     *
     * Remove the chat user role from the current user
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disableChatUser'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\UserModifiedResponse|\cnb\api\Model\ApiServerException, HTTP status code, HTTP response headers (array of strings)
     */
    public function disableChatUserWithHttpInfo(string $contentType = self::contentTypes['disableChatUser'][0])
    {
        $request = $this->disableChatUserRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\UserModifiedResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\UserModifiedResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\UserModifiedResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\cnb\api\Model\ApiServerException' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerException' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerException', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\UserModifiedResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\UserModifiedResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerException',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation disableChatUserAsync
     *
     * Remove the chat user role from the current user
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disableChatUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function disableChatUserAsync(string $contentType = self::contentTypes['disableChatUser'][0])
    {
        return $this->disableChatUserAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation disableChatUserAsyncWithHttpInfo
     *
     * Remove the chat user role from the current user
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disableChatUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function disableChatUserAsyncWithHttpInfo(string $contentType = self::contentTypes['disableChatUser'][0])
    {
        $returnType = '\cnb\api\Model\UserModifiedResponse';
        $request = $this->disableChatUserRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'disableChatUser'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disableChatUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function disableChatUserRequest(string $contentType = self::contentTypes['disableChatUser'][0])
    {


        $resourcePath = '/v1/chat/user/enable';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation enableChatUser
     *
     * Add the chat user role to the current user
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['enableChatUser'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\UserModifiedResponse|\cnb\api\Model\ApiServerException
     */
    public function enableChatUser(string $contentType = self::contentTypes['enableChatUser'][0])
    {
        list($response) = $this->enableChatUserWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation enableChatUserWithHttpInfo
     *
     * Add the chat user role to the current user
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['enableChatUser'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\UserModifiedResponse|\cnb\api\Model\ApiServerException, HTTP status code, HTTP response headers (array of strings)
     */
    public function enableChatUserWithHttpInfo(string $contentType = self::contentTypes['enableChatUser'][0])
    {
        $request = $this->enableChatUserRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\UserModifiedResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\UserModifiedResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\UserModifiedResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\cnb\api\Model\ApiServerException' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerException' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerException', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\UserModifiedResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\UserModifiedResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerException',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation enableChatUserAsync
     *
     * Add the chat user role to the current user
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['enableChatUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function enableChatUserAsync(string $contentType = self::contentTypes['enableChatUser'][0])
    {
        return $this->enableChatUserAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation enableChatUserAsyncWithHttpInfo
     *
     * Add the chat user role to the current user
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['enableChatUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function enableChatUserAsyncWithHttpInfo(string $contentType = self::contentTypes['enableChatUser'][0])
    {
        $returnType = '\cnb\api\Model\UserModifiedResponse';
        $request = $this->enableChatUserRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'enableChatUser'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['enableChatUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function enableChatUserRequest(string $contentType = self::contentTypes['enableChatUser'][0])
    {


        $resourcePath = '/v1/chat/user/enable';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation events
     *
     * Gets all Events of this Channel, ordered by createdAt
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['events'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannelEvent[]
     */
    public function events($workspace_id, $channel_id, string $contentType = self::contentTypes['events'][0])
    {
        list($response) = $this->eventsWithHttpInfo($workspace_id, $channel_id, $contentType);
        return $response;
    }

    /**
     * Operation eventsWithHttpInfo
     *
     * Gets all Events of this Channel, ordered by createdAt
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['events'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannelEvent[], HTTP status code, HTTP response headers (array of strings)
     */
    public function eventsWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['events'][0])
    {
        $request = $this->eventsRequest($workspace_id, $channel_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannelEvent[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannelEvent[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannelEvent[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannelEvent[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannelEvent[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation eventsAsync
     *
     * Gets all Events of this Channel, ordered by createdAt
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['events'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsAsync($workspace_id, $channel_id, string $contentType = self::contentTypes['events'][0])
    {
        return $this->eventsAsyncWithHttpInfo($workspace_id, $channel_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation eventsAsyncWithHttpInfo
     *
     * Gets all Events of this Channel, ordered by createdAt
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['events'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function eventsAsyncWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['events'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannelEvent[]';
        $request = $this->eventsRequest($workspace_id, $channel_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'events'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['events'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function eventsRequest($workspace_id, $channel_id, string $contentType = self::contentTypes['events'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling events'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling events'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/events';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation exportChatChannelAsHtml
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportChatChannelAsHtml'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function exportChatChannelAsHtml($workspace_id, $channel_id, string $contentType = self::contentTypes['exportChatChannelAsHtml'][0])
    {
        $this->exportChatChannelAsHtmlWithHttpInfo($workspace_id, $channel_id, $contentType);
    }

    /**
     * Operation exportChatChannelAsHtmlWithHttpInfo
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportChatChannelAsHtml'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function exportChatChannelAsHtmlWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['exportChatChannelAsHtml'][0])
    {
        $request = $this->exportChatChannelAsHtmlRequest($workspace_id, $channel_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation exportChatChannelAsHtmlAsync
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportChatChannelAsHtml'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportChatChannelAsHtmlAsync($workspace_id, $channel_id, string $contentType = self::contentTypes['exportChatChannelAsHtml'][0])
    {
        return $this->exportChatChannelAsHtmlAsyncWithHttpInfo($workspace_id, $channel_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation exportChatChannelAsHtmlAsyncWithHttpInfo
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportChatChannelAsHtml'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportChatChannelAsHtmlAsyncWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['exportChatChannelAsHtml'][0])
    {
        $returnType = '';
        $request = $this->exportChatChannelAsHtmlRequest($workspace_id, $channel_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'exportChatChannelAsHtml'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportChatChannelAsHtml'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function exportChatChannelAsHtmlRequest($workspace_id, $channel_id, string $contentType = self::contentTypes['exportChatChannelAsHtml'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling exportChatChannelAsHtml'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling exportChatChannelAsHtml'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/html';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation exportChatChannelAsPdf
     *
     * Export chat channel as PDF
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportChatChannelAsPdf'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\SplFileObject
     */
    public function exportChatChannelAsPdf($workspace_id, $channel_id, string $contentType = self::contentTypes['exportChatChannelAsPdf'][0])
    {
        list($response) = $this->exportChatChannelAsPdfWithHttpInfo($workspace_id, $channel_id, $contentType);
        return $response;
    }

    /**
     * Operation exportChatChannelAsPdfWithHttpInfo
     *
     * Export chat channel as PDF
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportChatChannelAsPdf'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function exportChatChannelAsPdfWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['exportChatChannelAsPdf'][0])
    {
        $request = $this->exportChatChannelAsPdfRequest($workspace_id, $channel_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SplFileObject' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\SplFileObject';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation exportChatChannelAsPdfAsync
     *
     * Export chat channel as PDF
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportChatChannelAsPdf'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportChatChannelAsPdfAsync($workspace_id, $channel_id, string $contentType = self::contentTypes['exportChatChannelAsPdf'][0])
    {
        return $this->exportChatChannelAsPdfAsyncWithHttpInfo($workspace_id, $channel_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation exportChatChannelAsPdfAsyncWithHttpInfo
     *
     * Export chat channel as PDF
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportChatChannelAsPdf'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportChatChannelAsPdfAsyncWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['exportChatChannelAsPdf'][0])
    {
        $returnType = '\SplFileObject';
        $request = $this->exportChatChannelAsPdfRequest($workspace_id, $channel_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'exportChatChannelAsPdf'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportChatChannelAsPdf'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function exportChatChannelAsPdfRequest($workspace_id, $channel_id, string $contentType = self::contentTypes['exportChatChannelAsPdf'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling exportChatChannelAsPdf'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling exportChatChannelAsPdf'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/pdf';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', 'application/pdf', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation get
     *
     * Get a chat channel for the user
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['get'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel
     */
    public function get($workspace_id, $channel_id, string $contentType = self::contentTypes['get'][0])
    {
        list($response) = $this->getWithHttpInfo($workspace_id, $channel_id, $contentType);
        return $response;
    }

    /**
     * Operation getWithHttpInfo
     *
     * Get a chat channel for the user
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['get'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['get'][0])
    {
        $request = $this->getRequest($workspace_id, $channel_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannel' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannel' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannel', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannel';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannel',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAsync
     *
     * Get a chat channel for the user
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['get'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAsync($workspace_id, $channel_id, string $contentType = self::contentTypes['get'][0])
    {
        return $this->getAsyncWithHttpInfo($workspace_id, $channel_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAsyncWithHttpInfo
     *
     * Get a chat channel for the user
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['get'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAsyncWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['get'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannel';
        $request = $this->getRequest($workspace_id, $channel_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'get'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['get'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getRequest($workspace_id, $channel_id, string $contentType = self::contentTypes['get'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling get'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling get'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAll
     *
     * Get all chat channels for the user
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAll'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel[]
     */
    public function getAll($workspace_id, string $contentType = self::contentTypes['getAll'][0])
    {
        list($response) = $this->getAllWithHttpInfo($workspace_id, $contentType);
        return $response;
    }

    /**
     * Operation getAllWithHttpInfo
     *
     * Get all chat channels for the user
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAll'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllWithHttpInfo($workspace_id, string $contentType = self::contentTypes['getAll'][0])
    {
        $request = $this->getAllRequest($workspace_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannel[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannel[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannel[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannel[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannel[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllAsync
     *
     * Get all chat channels for the user
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAll'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllAsync($workspace_id, string $contentType = self::contentTypes['getAll'][0])
    {
        return $this->getAllAsyncWithHttpInfo($workspace_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllAsyncWithHttpInfo
     *
     * Get all chat channels for the user
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAll'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllAsyncWithHttpInfo($workspace_id, string $contentType = self::contentTypes['getAll'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannel[]';
        $request = $this->getAllRequest($workspace_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAll'
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAll'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllRequest($workspace_id, string $contentType = self::contentTypes['getAll'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling getAll'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channels';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllBots
     *
     * Get all available bots for this Workspace domain.
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $domain_id domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllBots'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatWorkspaceDomainPersona[]
     */
    public function getAllBots($workspace_id, $domain_id, string $contentType = self::contentTypes['getAllBots'][0])
    {
        list($response) = $this->getAllBotsWithHttpInfo($workspace_id, $domain_id, $contentType);
        return $response;
    }

    /**
     * Operation getAllBotsWithHttpInfo
     *
     * Get all available bots for this Workspace domain.
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllBots'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatWorkspaceDomainPersona[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllBotsWithHttpInfo($workspace_id, $domain_id, string $contentType = self::contentTypes['getAllBots'][0])
    {
        $request = $this->getAllBotsRequest($workspace_id, $domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatWorkspaceDomainPersona[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatWorkspaceDomainPersona[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatWorkspaceDomainPersona[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatWorkspaceDomainPersona[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatWorkspaceDomainPersona[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllBotsAsync
     *
     * Get all available bots for this Workspace domain.
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllBots'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllBotsAsync($workspace_id, $domain_id, string $contentType = self::contentTypes['getAllBots'][0])
    {
        return $this->getAllBotsAsyncWithHttpInfo($workspace_id, $domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllBotsAsyncWithHttpInfo
     *
     * Get all available bots for this Workspace domain.
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllBots'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllBotsAsyncWithHttpInfo($workspace_id, $domain_id, string $contentType = self::contentTypes['getAllBots'][0])
    {
        $returnType = '\cnb\api\Model\ChatWorkspaceDomainPersona[]';
        $request = $this->getAllBotsRequest($workspace_id, $domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllBots'
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllBots'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllBotsRequest($workspace_id, $domain_id, string $contentType = self::contentTypes['getAllBots'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling getAllBots'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling getAllBots'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/domain/{domainId}/bots';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domainId' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllPersonas
     *
     * Get all ChatAgentPersona profiles for this Workspace.
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllPersonas'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatAgentPersona[]
     */
    public function getAllPersonas($workspace_id, string $contentType = self::contentTypes['getAllPersonas'][0])
    {
        list($response) = $this->getAllPersonasWithHttpInfo($workspace_id, $contentType);
        return $response;
    }

    /**
     * Operation getAllPersonasWithHttpInfo
     *
     * Get all ChatAgentPersona profiles for this Workspace.
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllPersonas'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatAgentPersona[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllPersonasWithHttpInfo($workspace_id, string $contentType = self::contentTypes['getAllPersonas'][0])
    {
        $request = $this->getAllPersonasRequest($workspace_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatAgentPersona[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatAgentPersona[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatAgentPersona[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatAgentPersona[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatAgentPersona[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllPersonasAsync
     *
     * Get all ChatAgentPersona profiles for this Workspace.
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllPersonas'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllPersonasAsync($workspace_id, string $contentType = self::contentTypes['getAllPersonas'][0])
    {
        return $this->getAllPersonasAsyncWithHttpInfo($workspace_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllPersonasAsyncWithHttpInfo
     *
     * Get all ChatAgentPersona profiles for this Workspace.
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllPersonas'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllPersonasAsyncWithHttpInfo($workspace_id, string $contentType = self::contentTypes['getAllPersonas'][0])
    {
        $returnType = '\cnb\api\Model\ChatAgentPersona[]';
        $request = $this->getAllPersonasRequest($workspace_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllPersonas'
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllPersonas'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllPersonasRequest($workspace_id, string $contentType = self::contentTypes['getAllPersonas'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling getAllPersonas'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/members/persona';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFull
     *
     * Get a chat channel w/ all metadata for the user
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFull'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannelFull
     */
    public function getFull($workspace_id, $channel_id, string $contentType = self::contentTypes['getFull'][0])
    {
        list($response) = $this->getFullWithHttpInfo($workspace_id, $channel_id, $contentType);
        return $response;
    }

    /**
     * Operation getFullWithHttpInfo
     *
     * Get a chat channel w/ all metadata for the user
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFull'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannelFull, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFullWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['getFull'][0])
    {
        $request = $this->getFullRequest($workspace_id, $channel_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannelFull' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannelFull' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannelFull', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannelFull';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannelFull',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getFullAsync
     *
     * Get a chat channel w/ all metadata for the user
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFull'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFullAsync($workspace_id, $channel_id, string $contentType = self::contentTypes['getFull'][0])
    {
        return $this->getFullAsyncWithHttpInfo($workspace_id, $channel_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getFullAsyncWithHttpInfo
     *
     * Get a chat channel w/ all metadata for the user
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFull'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFullAsyncWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['getFull'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannelFull';
        $request = $this->getFullRequest($workspace_id, $channel_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFull'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getFull'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getFullRequest($workspace_id, $channel_id, string $contentType = self::contentTypes['getFull'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling getFull'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling getFull'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/full';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPersona
     *
     * Get the Persona profile for this WorkspaceMember.
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $member_id member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersona'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatAgentPersona
     */
    public function getPersona($workspace_id, $member_id, string $contentType = self::contentTypes['getPersona'][0])
    {
        list($response) = $this->getPersonaWithHttpInfo($workspace_id, $member_id, $contentType);
        return $response;
    }

    /**
     * Operation getPersonaWithHttpInfo
     *
     * Get the Persona profile for this WorkspaceMember.
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersona'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatAgentPersona, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPersonaWithHttpInfo($workspace_id, $member_id, string $contentType = self::contentTypes['getPersona'][0])
    {
        $request = $this->getPersonaRequest($workspace_id, $member_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatAgentPersona' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatAgentPersona' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatAgentPersona', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatAgentPersona';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatAgentPersona',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPersonaAsync
     *
     * Get the Persona profile for this WorkspaceMember.
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPersonaAsync($workspace_id, $member_id, string $contentType = self::contentTypes['getPersona'][0])
    {
        return $this->getPersonaAsyncWithHttpInfo($workspace_id, $member_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPersonaAsyncWithHttpInfo
     *
     * Get the Persona profile for this WorkspaceMember.
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPersonaAsyncWithHttpInfo($workspace_id, $member_id, string $contentType = self::contentTypes['getPersona'][0])
    {
        $returnType = '\cnb\api\Model\ChatAgentPersona';
        $request = $this->getPersonaRequest($workspace_id, $member_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPersona'
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPersonaRequest($workspace_id, $member_id, string $contentType = self::contentTypes['getPersona'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling getPersona'
            );
        }

        // verify the required parameter 'member_id' is set
        if ($member_id === null || (is_array($member_id) && count($member_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $member_id when calling getPersona'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/member/{memberId}/persona';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($member_id !== null) {
            $resourcePath = str_replace(
                '{' . 'memberId' . '}',
                ObjectSerializer::toPathValue($member_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPrivateNotes
     *
     * Get all private notes for a channel
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPrivateNotes'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\PrivateNote[]
     */
    public function getPrivateNotes($workspace_id, $channel_id, string $contentType = self::contentTypes['getPrivateNotes'][0])
    {
        list($response) = $this->getPrivateNotesWithHttpInfo($workspace_id, $channel_id, $contentType);
        return $response;
    }

    /**
     * Operation getPrivateNotesWithHttpInfo
     *
     * Get all private notes for a channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPrivateNotes'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\PrivateNote[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getPrivateNotesWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['getPrivateNotes'][0])
    {
        $request = $this->getPrivateNotesRequest($workspace_id, $channel_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\PrivateNote[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\PrivateNote[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\PrivateNote[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\PrivateNote[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\PrivateNote[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPrivateNotesAsync
     *
     * Get all private notes for a channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPrivateNotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPrivateNotesAsync($workspace_id, $channel_id, string $contentType = self::contentTypes['getPrivateNotes'][0])
    {
        return $this->getPrivateNotesAsyncWithHttpInfo($workspace_id, $channel_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPrivateNotesAsyncWithHttpInfo
     *
     * Get all private notes for a channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPrivateNotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPrivateNotesAsyncWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['getPrivateNotes'][0])
    {
        $returnType = '\cnb\api\Model\PrivateNote[]';
        $request = $this->getPrivateNotesRequest($workspace_id, $channel_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPrivateNotes'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPrivateNotes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPrivateNotesRequest($workspace_id, $channel_id, string $contentType = self::contentTypes['getPrivateNotes'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling getPrivateNotes'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling getPrivateNotes'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/notes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getQuickReplies
     *
     * Get quick replies for a workspace domain
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $domain_id domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getQuickReplies'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\QuickReply[]
     */
    public function getQuickReplies($workspace_id, $domain_id, string $contentType = self::contentTypes['getQuickReplies'][0])
    {
        list($response) = $this->getQuickRepliesWithHttpInfo($workspace_id, $domain_id, $contentType);
        return $response;
    }

    /**
     * Operation getQuickRepliesWithHttpInfo
     *
     * Get quick replies for a workspace domain
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getQuickReplies'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\QuickReply[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getQuickRepliesWithHttpInfo($workspace_id, $domain_id, string $contentType = self::contentTypes['getQuickReplies'][0])
    {
        $request = $this->getQuickRepliesRequest($workspace_id, $domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\QuickReply[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\QuickReply[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\QuickReply[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\QuickReply[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\QuickReply[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getQuickRepliesAsync
     *
     * Get quick replies for a workspace domain
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getQuickReplies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getQuickRepliesAsync($workspace_id, $domain_id, string $contentType = self::contentTypes['getQuickReplies'][0])
    {
        return $this->getQuickRepliesAsyncWithHttpInfo($workspace_id, $domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getQuickRepliesAsyncWithHttpInfo
     *
     * Get quick replies for a workspace domain
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getQuickReplies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getQuickRepliesAsyncWithHttpInfo($workspace_id, $domain_id, string $contentType = self::contentTypes['getQuickReplies'][0])
    {
        $returnType = '\cnb\api\Model\QuickReply[]';
        $request = $this->getQuickRepliesRequest($workspace_id, $domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getQuickReplies'
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getQuickReplies'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getQuickRepliesRequest($workspace_id, $domain_id, string $contentType = self::contentTypes['getQuickReplies'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling getQuickReplies'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling getQuickReplies'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/{domainId}/quickreplies';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domainId' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getToken
     *
     * Get an Ably (refresh) token. This token also includes the Users&#39; metadata (notifications) channel.
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getToken'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\TokenRequest
     */
    public function getToken($workspace_id, string $contentType = self::contentTypes['getToken'][0])
    {
        list($response) = $this->getTokenWithHttpInfo($workspace_id, $contentType);
        return $response;
    }

    /**
     * Operation getTokenWithHttpInfo
     *
     * Get an Ably (refresh) token. This token also includes the Users&#39; metadata (notifications) channel.
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getToken'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\TokenRequest, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTokenWithHttpInfo($workspace_id, string $contentType = self::contentTypes['getToken'][0])
    {
        $request = $this->getTokenRequest($workspace_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\TokenRequest' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\TokenRequest' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\TokenRequest', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\TokenRequest';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\TokenRequest',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getTokenAsync
     *
     * Get an Ably (refresh) token. This token also includes the Users&#39; metadata (notifications) channel.
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getToken'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTokenAsync($workspace_id, string $contentType = self::contentTypes['getToken'][0])
    {
        return $this->getTokenAsyncWithHttpInfo($workspace_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTokenAsyncWithHttpInfo
     *
     * Get an Ably (refresh) token. This token also includes the Users&#39; metadata (notifications) channel.
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getToken'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTokenAsyncWithHttpInfo($workspace_id, string $contentType = self::contentTypes['getToken'][0])
    {
        $returnType = '\cnb\api\Model\TokenRequest';
        $request = $this->getTokenRequest($workspace_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getToken'
     *
     * @param  string $workspace_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getToken'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getTokenRequest($workspace_id, string $contentType = self::contentTypes['getToken'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling getToken'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/token';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation history
     *
     * Gets all Messages of this Channel
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['history'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatMessage[]
     */
    public function history($workspace_id, $channel_id, string $contentType = self::contentTypes['history'][0])
    {
        list($response) = $this->historyWithHttpInfo($workspace_id, $channel_id, $contentType);
        return $response;
    }

    /**
     * Operation historyWithHttpInfo
     *
     * Gets all Messages of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['history'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatMessage[], HTTP status code, HTTP response headers (array of strings)
     */
    public function historyWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['history'][0])
    {
        $request = $this->historyRequest($workspace_id, $channel_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatMessage[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatMessage[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatMessage[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatMessage[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatMessage[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation historyAsync
     *
     * Gets all Messages of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['history'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function historyAsync($workspace_id, $channel_id, string $contentType = self::contentTypes['history'][0])
    {
        return $this->historyAsyncWithHttpInfo($workspace_id, $channel_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation historyAsyncWithHttpInfo
     *
     * Gets all Messages of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['history'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function historyAsyncWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['history'][0])
    {
        $returnType = '\cnb\api\Model\ChatMessage[]';
        $request = $this->historyRequest($workspace_id, $channel_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'history'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['history'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function historyRequest($workspace_id, $channel_id, string $contentType = self::contentTypes['history'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling history'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling history'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/history';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation participants
     *
     * Gets all Participants of this Channel
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['participants'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\Participant[]
     */
    public function participants($workspace_id, $channel_id, string $contentType = self::contentTypes['participants'][0])
    {
        list($response) = $this->participantsWithHttpInfo($workspace_id, $channel_id, $contentType);
        return $response;
    }

    /**
     * Operation participantsWithHttpInfo
     *
     * Gets all Participants of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['participants'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\Participant[], HTTP status code, HTTP response headers (array of strings)
     */
    public function participantsWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['participants'][0])
    {
        $request = $this->participantsRequest($workspace_id, $channel_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\Participant[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\Participant[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\Participant[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\Participant[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\Participant[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation participantsAsync
     *
     * Gets all Participants of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['participants'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function participantsAsync($workspace_id, $channel_id, string $contentType = self::contentTypes['participants'][0])
    {
        return $this->participantsAsyncWithHttpInfo($workspace_id, $channel_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation participantsAsyncWithHttpInfo
     *
     * Gets all Participants of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['participants'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function participantsAsyncWithHttpInfo($workspace_id, $channel_id, string $contentType = self::contentTypes['participants'][0])
    {
        $returnType = '\cnb\api\Model\Participant[]';
        $request = $this->participantsRequest($workspace_id, $channel_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'participants'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['participants'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function participantsRequest($workspace_id, $channel_id, string $contentType = self::contentTypes['participants'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling participants'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling participants'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/participants';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation removeParticipant
     *
     * Remove a Chat Agent as a participant to this Channel.
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $persona_id persona_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['removeParticipant'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel
     */
    public function removeParticipant($workspace_id, $channel_id, $persona_id, string $contentType = self::contentTypes['removeParticipant'][0])
    {
        list($response) = $this->removeParticipantWithHttpInfo($workspace_id, $channel_id, $persona_id, $contentType);
        return $response;
    }

    /**
     * Operation removeParticipantWithHttpInfo
     *
     * Remove a Chat Agent as a participant to this Channel.
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['removeParticipant'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel, HTTP status code, HTTP response headers (array of strings)
     */
    public function removeParticipantWithHttpInfo($workspace_id, $channel_id, $persona_id, string $contentType = self::contentTypes['removeParticipant'][0])
    {
        $request = $this->removeParticipantRequest($workspace_id, $channel_id, $persona_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannel' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannel' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannel', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannel';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannel',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation removeParticipantAsync
     *
     * Remove a Chat Agent as a participant to this Channel.
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['removeParticipant'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function removeParticipantAsync($workspace_id, $channel_id, $persona_id, string $contentType = self::contentTypes['removeParticipant'][0])
    {
        return $this->removeParticipantAsyncWithHttpInfo($workspace_id, $channel_id, $persona_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation removeParticipantAsyncWithHttpInfo
     *
     * Remove a Chat Agent as a participant to this Channel.
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['removeParticipant'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function removeParticipantAsyncWithHttpInfo($workspace_id, $channel_id, $persona_id, string $contentType = self::contentTypes['removeParticipant'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannel';
        $request = $this->removeParticipantRequest($workspace_id, $channel_id, $persona_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'removeParticipant'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['removeParticipant'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function removeParticipantRequest($workspace_id, $channel_id, $persona_id, string $contentType = self::contentTypes['removeParticipant'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling removeParticipant'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling removeParticipant'
            );
        }

        // verify the required parameter 'persona_id' is set
        if ($persona_id === null || (is_array($persona_id) && count($persona_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $persona_id when calling removeParticipant'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/participant/{personaId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }
        // path params
        if ($persona_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personaId' . '}',
                ObjectSerializer::toPathValue($persona_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateChatClientPersona
     *
     * updates a ChatClientPersona profile.
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $persona_id persona_id (required)
     * @param  \cnb\api\Model\ChatClientPersonaUpdateRequest $chat_client_persona_update_request chat_client_persona_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateChatClientPersona'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel
     */
    public function updateChatClientPersona($workspace_id, $channel_id, $persona_id, $chat_client_persona_update_request, string $contentType = self::contentTypes['updateChatClientPersona'][0])
    {
        list($response) = $this->updateChatClientPersonaWithHttpInfo($workspace_id, $channel_id, $persona_id, $chat_client_persona_update_request, $contentType);
        return $response;
    }

    /**
     * Operation updateChatClientPersonaWithHttpInfo
     *
     * updates a ChatClientPersona profile.
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  \cnb\api\Model\ChatClientPersonaUpdateRequest $chat_client_persona_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateChatClientPersona'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateChatClientPersonaWithHttpInfo($workspace_id, $channel_id, $persona_id, $chat_client_persona_update_request, string $contentType = self::contentTypes['updateChatClientPersona'][0])
    {
        $request = $this->updateChatClientPersonaRequest($workspace_id, $channel_id, $persona_id, $chat_client_persona_update_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannel' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannel' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannel', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannel';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannel',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateChatClientPersonaAsync
     *
     * updates a ChatClientPersona profile.
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  \cnb\api\Model\ChatClientPersonaUpdateRequest $chat_client_persona_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateChatClientPersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateChatClientPersonaAsync($workspace_id, $channel_id, $persona_id, $chat_client_persona_update_request, string $contentType = self::contentTypes['updateChatClientPersona'][0])
    {
        return $this->updateChatClientPersonaAsyncWithHttpInfo($workspace_id, $channel_id, $persona_id, $chat_client_persona_update_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateChatClientPersonaAsyncWithHttpInfo
     *
     * updates a ChatClientPersona profile.
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  \cnb\api\Model\ChatClientPersonaUpdateRequest $chat_client_persona_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateChatClientPersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateChatClientPersonaAsyncWithHttpInfo($workspace_id, $channel_id, $persona_id, $chat_client_persona_update_request, string $contentType = self::contentTypes['updateChatClientPersona'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannel';
        $request = $this->updateChatClientPersonaRequest($workspace_id, $channel_id, $persona_id, $chat_client_persona_update_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateChatClientPersona'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  \cnb\api\Model\ChatClientPersonaUpdateRequest $chat_client_persona_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateChatClientPersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateChatClientPersonaRequest($workspace_id, $channel_id, $persona_id, $chat_client_persona_update_request, string $contentType = self::contentTypes['updateChatClientPersona'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updateChatClientPersona'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling updateChatClientPersona'
            );
        }

        // verify the required parameter 'persona_id' is set
        if ($persona_id === null || (is_array($persona_id) && count($persona_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $persona_id when calling updateChatClientPersona'
            );
        }

        // verify the required parameter 'chat_client_persona_update_request' is set
        if ($chat_client_persona_update_request === null || (is_array($chat_client_persona_update_request) && count($chat_client_persona_update_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chat_client_persona_update_request when calling updateChatClientPersona'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/persona/{personaId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }
        // path params
        if ($persona_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personaId' . '}',
                ObjectSerializer::toPathValue($persona_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($chat_client_persona_update_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($chat_client_persona_update_request));
            } else {
                $httpBody = $chat_client_persona_update_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateName
     *
     * Updates the name of this Channel
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  \cnb\api\Model\ChatChannelNameUpdateRequest $chat_channel_name_update_request chat_channel_name_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateName'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel
     */
    public function updateName($workspace_id, $channel_id, $chat_channel_name_update_request, string $contentType = self::contentTypes['updateName'][0])
    {
        list($response) = $this->updateNameWithHttpInfo($workspace_id, $channel_id, $chat_channel_name_update_request, $contentType);
        return $response;
    }

    /**
     * Operation updateNameWithHttpInfo
     *
     * Updates the name of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\ChatChannelNameUpdateRequest $chat_channel_name_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateName'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateNameWithHttpInfo($workspace_id, $channel_id, $chat_channel_name_update_request, string $contentType = self::contentTypes['updateName'][0])
    {
        $request = $this->updateNameRequest($workspace_id, $channel_id, $chat_channel_name_update_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannel' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannel' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannel', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannel';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannel',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateNameAsync
     *
     * Updates the name of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\ChatChannelNameUpdateRequest $chat_channel_name_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateNameAsync($workspace_id, $channel_id, $chat_channel_name_update_request, string $contentType = self::contentTypes['updateName'][0])
    {
        return $this->updateNameAsyncWithHttpInfo($workspace_id, $channel_id, $chat_channel_name_update_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateNameAsyncWithHttpInfo
     *
     * Updates the name of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\ChatChannelNameUpdateRequest $chat_channel_name_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateNameAsyncWithHttpInfo($workspace_id, $channel_id, $chat_channel_name_update_request, string $contentType = self::contentTypes['updateName'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannel';
        $request = $this->updateNameRequest($workspace_id, $channel_id, $chat_channel_name_update_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateName'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\ChatChannelNameUpdateRequest $chat_channel_name_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateNameRequest($workspace_id, $channel_id, $chat_channel_name_update_request, string $contentType = self::contentTypes['updateName'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updateName'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling updateName'
            );
        }

        // verify the required parameter 'chat_channel_name_update_request' is set
        if ($chat_channel_name_update_request === null || (is_array($chat_channel_name_update_request) && count($chat_channel_name_update_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chat_channel_name_update_request when calling updateName'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/name';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($chat_channel_name_update_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($chat_channel_name_update_request));
            } else {
                $httpBody = $chat_channel_name_update_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateParticipantLastReadMessage
     *
     * Update a Participant&#39;s last read message in this Channel.
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $persona_id persona_id (required)
     * @param  string $message_id message_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateParticipantLastReadMessage'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel
     */
    public function updateParticipantLastReadMessage($workspace_id, $channel_id, $persona_id, $message_id, string $contentType = self::contentTypes['updateParticipantLastReadMessage'][0])
    {
        list($response) = $this->updateParticipantLastReadMessageWithHttpInfo($workspace_id, $channel_id, $persona_id, $message_id, $contentType);
        return $response;
    }

    /**
     * Operation updateParticipantLastReadMessageWithHttpInfo
     *
     * Update a Participant&#39;s last read message in this Channel.
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  string $message_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateParticipantLastReadMessage'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateParticipantLastReadMessageWithHttpInfo($workspace_id, $channel_id, $persona_id, $message_id, string $contentType = self::contentTypes['updateParticipantLastReadMessage'][0])
    {
        $request = $this->updateParticipantLastReadMessageRequest($workspace_id, $channel_id, $persona_id, $message_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannel' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannel' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannel', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannel';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannel',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateParticipantLastReadMessageAsync
     *
     * Update a Participant&#39;s last read message in this Channel.
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  string $message_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateParticipantLastReadMessage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateParticipantLastReadMessageAsync($workspace_id, $channel_id, $persona_id, $message_id, string $contentType = self::contentTypes['updateParticipantLastReadMessage'][0])
    {
        return $this->updateParticipantLastReadMessageAsyncWithHttpInfo($workspace_id, $channel_id, $persona_id, $message_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateParticipantLastReadMessageAsyncWithHttpInfo
     *
     * Update a Participant&#39;s last read message in this Channel.
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  string $message_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateParticipantLastReadMessage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateParticipantLastReadMessageAsyncWithHttpInfo($workspace_id, $channel_id, $persona_id, $message_id, string $contentType = self::contentTypes['updateParticipantLastReadMessage'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannel';
        $request = $this->updateParticipantLastReadMessageRequest($workspace_id, $channel_id, $persona_id, $message_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateParticipantLastReadMessage'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $persona_id (required)
     * @param  string $message_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateParticipantLastReadMessage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateParticipantLastReadMessageRequest($workspace_id, $channel_id, $persona_id, $message_id, string $contentType = self::contentTypes['updateParticipantLastReadMessage'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updateParticipantLastReadMessage'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling updateParticipantLastReadMessage'
            );
        }

        // verify the required parameter 'persona_id' is set
        if ($persona_id === null || (is_array($persona_id) && count($persona_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $persona_id when calling updateParticipantLastReadMessage'
            );
        }

        // verify the required parameter 'message_id' is set
        if ($message_id === null || (is_array($message_id) && count($message_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $message_id when calling updateParticipantLastReadMessage'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/participant/{personaId}/lastReadMessage/{messageId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }
        // path params
        if ($persona_id !== null) {
            $resourcePath = str_replace(
                '{' . 'personaId' . '}',
                ObjectSerializer::toPathValue($persona_id),
                $resourcePath
            );
        }
        // path params
        if ($message_id !== null) {
            $resourcePath = str_replace(
                '{' . 'messageId' . '}',
                ObjectSerializer::toPathValue($message_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePersona
     *
     * updates a ChatAgentPersona profile for the provided WorkspaceMember.
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $member_id member_id (required)
     * @param  \cnb\api\Model\ChatUserUpdateRequest $chat_user_update_request chat_user_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePersona'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatAgentPersona
     */
    public function updatePersona($workspace_id, $member_id, $chat_user_update_request, string $contentType = self::contentTypes['updatePersona'][0])
    {
        list($response) = $this->updatePersonaWithHttpInfo($workspace_id, $member_id, $chat_user_update_request, $contentType);
        return $response;
    }

    /**
     * Operation updatePersonaWithHttpInfo
     *
     * updates a ChatAgentPersona profile for the provided WorkspaceMember.
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  \cnb\api\Model\ChatUserUpdateRequest $chat_user_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePersona'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatAgentPersona, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePersonaWithHttpInfo($workspace_id, $member_id, $chat_user_update_request, string $contentType = self::contentTypes['updatePersona'][0])
    {
        $request = $this->updatePersonaRequest($workspace_id, $member_id, $chat_user_update_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatAgentPersona' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatAgentPersona' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatAgentPersona', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatAgentPersona';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatAgentPersona',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updatePersonaAsync
     *
     * updates a ChatAgentPersona profile for the provided WorkspaceMember.
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  \cnb\api\Model\ChatUserUpdateRequest $chat_user_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePersonaAsync($workspace_id, $member_id, $chat_user_update_request, string $contentType = self::contentTypes['updatePersona'][0])
    {
        return $this->updatePersonaAsyncWithHttpInfo($workspace_id, $member_id, $chat_user_update_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePersonaAsyncWithHttpInfo
     *
     * updates a ChatAgentPersona profile for the provided WorkspaceMember.
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  \cnb\api\Model\ChatUserUpdateRequest $chat_user_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePersonaAsyncWithHttpInfo($workspace_id, $member_id, $chat_user_update_request, string $contentType = self::contentTypes['updatePersona'][0])
    {
        $returnType = '\cnb\api\Model\ChatAgentPersona';
        $request = $this->updatePersonaRequest($workspace_id, $member_id, $chat_user_update_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePersona'
     *
     * @param  string $workspace_id (required)
     * @param  string $member_id (required)
     * @param  \cnb\api\Model\ChatUserUpdateRequest $chat_user_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePersona'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePersonaRequest($workspace_id, $member_id, $chat_user_update_request, string $contentType = self::contentTypes['updatePersona'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updatePersona'
            );
        }

        // verify the required parameter 'member_id' is set
        if ($member_id === null || (is_array($member_id) && count($member_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $member_id when calling updatePersona'
            );
        }

        // verify the required parameter 'chat_user_update_request' is set
        if ($chat_user_update_request === null || (is_array($chat_user_update_request) && count($chat_user_update_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chat_user_update_request when calling updatePersona'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/member/{memberId}/persona';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($member_id !== null) {
            $resourcePath = str_replace(
                '{' . 'memberId' . '}',
                ObjectSerializer::toPathValue($member_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($chat_user_update_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($chat_user_update_request));
            } else {
                $httpBody = $chat_user_update_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePrivateNote
     *
     * Update the status of a private note
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  string $note_id note_id (required)
     * @param  \cnb\api\Model\UpdatePrivateNoteRequest $update_private_note_request update_private_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePrivateNote'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel
     */
    public function updatePrivateNote($workspace_id, $channel_id, $note_id, $update_private_note_request, string $contentType = self::contentTypes['updatePrivateNote'][0])
    {
        list($response) = $this->updatePrivateNoteWithHttpInfo($workspace_id, $channel_id, $note_id, $update_private_note_request, $contentType);
        return $response;
    }

    /**
     * Operation updatePrivateNoteWithHttpInfo
     *
     * Update the status of a private note
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $note_id (required)
     * @param  \cnb\api\Model\UpdatePrivateNoteRequest $update_private_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePrivateNote'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePrivateNoteWithHttpInfo($workspace_id, $channel_id, $note_id, $update_private_note_request, string $contentType = self::contentTypes['updatePrivateNote'][0])
    {
        $request = $this->updatePrivateNoteRequest($workspace_id, $channel_id, $note_id, $update_private_note_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannel' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannel' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannel', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannel';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannel',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updatePrivateNoteAsync
     *
     * Update the status of a private note
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $note_id (required)
     * @param  \cnb\api\Model\UpdatePrivateNoteRequest $update_private_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePrivateNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePrivateNoteAsync($workspace_id, $channel_id, $note_id, $update_private_note_request, string $contentType = self::contentTypes['updatePrivateNote'][0])
    {
        return $this->updatePrivateNoteAsyncWithHttpInfo($workspace_id, $channel_id, $note_id, $update_private_note_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePrivateNoteAsyncWithHttpInfo
     *
     * Update the status of a private note
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $note_id (required)
     * @param  \cnb\api\Model\UpdatePrivateNoteRequest $update_private_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePrivateNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePrivateNoteAsyncWithHttpInfo($workspace_id, $channel_id, $note_id, $update_private_note_request, string $contentType = self::contentTypes['updatePrivateNote'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannel';
        $request = $this->updatePrivateNoteRequest($workspace_id, $channel_id, $note_id, $update_private_note_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePrivateNote'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  string $note_id (required)
     * @param  \cnb\api\Model\UpdatePrivateNoteRequest $update_private_note_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updatePrivateNote'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updatePrivateNoteRequest($workspace_id, $channel_id, $note_id, $update_private_note_request, string $contentType = self::contentTypes['updatePrivateNote'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updatePrivateNote'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling updatePrivateNote'
            );
        }

        // verify the required parameter 'note_id' is set
        if ($note_id === null || (is_array($note_id) && count($note_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $note_id when calling updatePrivateNote'
            );
        }

        // verify the required parameter 'update_private_note_request' is set
        if ($update_private_note_request === null || (is_array($update_private_note_request) && count($update_private_note_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_private_note_request when calling updatePrivateNote'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/note/{noteId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }
        // path params
        if ($note_id !== null) {
            $resourcePath = str_replace(
                '{' . 'noteId' . '}',
                ObjectSerializer::toPathValue($note_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_private_note_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_private_note_request));
            } else {
                $httpBody = $update_private_note_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateQuickReply
     *
     * Create a quick reply
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $domain_id domain_id (required)
     * @param  string $quick_reply_id quick_reply_id (required)
     * @param  \cnb\api\Model\CreateQuickReplyRequest $create_quick_reply_request create_quick_reply_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateQuickReply'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\QuickReply
     */
    public function updateQuickReply($workspace_id, $domain_id, $quick_reply_id, $create_quick_reply_request, string $contentType = self::contentTypes['updateQuickReply'][0])
    {
        list($response) = $this->updateQuickReplyWithHttpInfo($workspace_id, $domain_id, $quick_reply_id, $create_quick_reply_request, $contentType);
        return $response;
    }

    /**
     * Operation updateQuickReplyWithHttpInfo
     *
     * Create a quick reply
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $quick_reply_id (required)
     * @param  \cnb\api\Model\CreateQuickReplyRequest $create_quick_reply_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateQuickReply'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\QuickReply, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateQuickReplyWithHttpInfo($workspace_id, $domain_id, $quick_reply_id, $create_quick_reply_request, string $contentType = self::contentTypes['updateQuickReply'][0])
    {
        $request = $this->updateQuickReplyRequest($workspace_id, $domain_id, $quick_reply_id, $create_quick_reply_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\QuickReply' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\QuickReply' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\QuickReply', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\QuickReply';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\QuickReply',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateQuickReplyAsync
     *
     * Create a quick reply
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $quick_reply_id (required)
     * @param  \cnb\api\Model\CreateQuickReplyRequest $create_quick_reply_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateQuickReply'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateQuickReplyAsync($workspace_id, $domain_id, $quick_reply_id, $create_quick_reply_request, string $contentType = self::contentTypes['updateQuickReply'][0])
    {
        return $this->updateQuickReplyAsyncWithHttpInfo($workspace_id, $domain_id, $quick_reply_id, $create_quick_reply_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateQuickReplyAsyncWithHttpInfo
     *
     * Create a quick reply
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $quick_reply_id (required)
     * @param  \cnb\api\Model\CreateQuickReplyRequest $create_quick_reply_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateQuickReply'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateQuickReplyAsyncWithHttpInfo($workspace_id, $domain_id, $quick_reply_id, $create_quick_reply_request, string $contentType = self::contentTypes['updateQuickReply'][0])
    {
        $returnType = '\cnb\api\Model\QuickReply';
        $request = $this->updateQuickReplyRequest($workspace_id, $domain_id, $quick_reply_id, $create_quick_reply_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateQuickReply'
     *
     * @param  string $workspace_id (required)
     * @param  string $domain_id (required)
     * @param  string $quick_reply_id (required)
     * @param  \cnb\api\Model\CreateQuickReplyRequest $create_quick_reply_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateQuickReply'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateQuickReplyRequest($workspace_id, $domain_id, $quick_reply_id, $create_quick_reply_request, string $contentType = self::contentTypes['updateQuickReply'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updateQuickReply'
            );
        }

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling updateQuickReply'
            );
        }

        // verify the required parameter 'quick_reply_id' is set
        if ($quick_reply_id === null || (is_array($quick_reply_id) && count($quick_reply_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $quick_reply_id when calling updateQuickReply'
            );
        }

        // verify the required parameter 'create_quick_reply_request' is set
        if ($create_quick_reply_request === null || (is_array($create_quick_reply_request) && count($create_quick_reply_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_quick_reply_request when calling updateQuickReply'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/{domainId}/quickreply/{quickReplyId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domainId' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }
        // path params
        if ($quick_reply_id !== null) {
            $resourcePath = str_replace(
                '{' . 'quickReplyId' . '}',
                ObjectSerializer::toPathValue($quick_reply_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_quick_reply_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_quick_reply_request));
            } else {
                $httpBody = $create_quick_reply_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateResolution
     *
     * Updates the resolution of this Channel
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  \cnb\api\Model\ChatChannelResolutionUpdateRequest $chat_channel_resolution_update_request chat_channel_resolution_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateResolution'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel
     */
    public function updateResolution($workspace_id, $channel_id, $chat_channel_resolution_update_request, string $contentType = self::contentTypes['updateResolution'][0])
    {
        list($response) = $this->updateResolutionWithHttpInfo($workspace_id, $channel_id, $chat_channel_resolution_update_request, $contentType);
        return $response;
    }

    /**
     * Operation updateResolutionWithHttpInfo
     *
     * Updates the resolution of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\ChatChannelResolutionUpdateRequest $chat_channel_resolution_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateResolution'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateResolutionWithHttpInfo($workspace_id, $channel_id, $chat_channel_resolution_update_request, string $contentType = self::contentTypes['updateResolution'][0])
    {
        $request = $this->updateResolutionRequest($workspace_id, $channel_id, $chat_channel_resolution_update_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannel' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannel' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannel', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannel';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannel',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateResolutionAsync
     *
     * Updates the resolution of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\ChatChannelResolutionUpdateRequest $chat_channel_resolution_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateResolution'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateResolutionAsync($workspace_id, $channel_id, $chat_channel_resolution_update_request, string $contentType = self::contentTypes['updateResolution'][0])
    {
        return $this->updateResolutionAsyncWithHttpInfo($workspace_id, $channel_id, $chat_channel_resolution_update_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateResolutionAsyncWithHttpInfo
     *
     * Updates the resolution of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\ChatChannelResolutionUpdateRequest $chat_channel_resolution_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateResolution'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateResolutionAsyncWithHttpInfo($workspace_id, $channel_id, $chat_channel_resolution_update_request, string $contentType = self::contentTypes['updateResolution'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannel';
        $request = $this->updateResolutionRequest($workspace_id, $channel_id, $chat_channel_resolution_update_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateResolution'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\ChatChannelResolutionUpdateRequest $chat_channel_resolution_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateResolution'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateResolutionRequest($workspace_id, $channel_id, $chat_channel_resolution_update_request, string $contentType = self::contentTypes['updateResolution'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updateResolution'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling updateResolution'
            );
        }

        // verify the required parameter 'chat_channel_resolution_update_request' is set
        if ($chat_channel_resolution_update_request === null || (is_array($chat_channel_resolution_update_request) && count($chat_channel_resolution_update_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chat_channel_resolution_update_request when calling updateResolution'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/resolution';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($chat_channel_resolution_update_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($chat_channel_resolution_update_request));
            } else {
                $httpBody = $chat_channel_resolution_update_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateStatus
     *
     * Updates the status of this Channel
     *
     * @param  string $workspace_id workspace_id (required)
     * @param  string $channel_id channel_id (required)
     * @param  \cnb\api\Model\ChatChannelStatusUpdateRequest $chat_channel_status_update_request chat_channel_status_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStatus'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel
     */
    public function updateStatus($workspace_id, $channel_id, $chat_channel_status_update_request, string $contentType = self::contentTypes['updateStatus'][0])
    {
        list($response) = $this->updateStatusWithHttpInfo($workspace_id, $channel_id, $chat_channel_status_update_request, $contentType);
        return $response;
    }

    /**
     * Operation updateStatusWithHttpInfo
     *
     * Updates the status of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\ChatChannelStatusUpdateRequest $chat_channel_status_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStatus'] to see the possible values for this operation
     *
     * @throws \cnb\api\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \cnb\api\Model\ApiServerExceptionResponse|\cnb\api\Model\ChatChannel, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateStatusWithHttpInfo($workspace_id, $channel_id, $chat_channel_status_update_request, string $contentType = self::contentTypes['updateStatus'][0])
    {
        $request = $this->updateStatusRequest($workspace_id, $channel_id, $chat_channel_status_update_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 401:
                    if ('\cnb\api\Model\ApiServerExceptionResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ApiServerExceptionResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ApiServerExceptionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 200:
                    if ('\cnb\api\Model\ChatChannel' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\cnb\api\Model\ChatChannel' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\cnb\api\Model\ChatChannel', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\cnb\api\Model\ChatChannel';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ApiServerExceptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\cnb\api\Model\ChatChannel',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateStatusAsync
     *
     * Updates the status of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\ChatChannelStatusUpdateRequest $chat_channel_status_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateStatusAsync($workspace_id, $channel_id, $chat_channel_status_update_request, string $contentType = self::contentTypes['updateStatus'][0])
    {
        return $this->updateStatusAsyncWithHttpInfo($workspace_id, $channel_id, $chat_channel_status_update_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateStatusAsyncWithHttpInfo
     *
     * Updates the status of this Channel
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\ChatChannelStatusUpdateRequest $chat_channel_status_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateStatusAsyncWithHttpInfo($workspace_id, $channel_id, $chat_channel_status_update_request, string $contentType = self::contentTypes['updateStatus'][0])
    {
        $returnType = '\cnb\api\Model\ChatChannel';
        $request = $this->updateStatusRequest($workspace_id, $channel_id, $chat_channel_status_update_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateStatus'
     *
     * @param  string $workspace_id (required)
     * @param  string $channel_id (required)
     * @param  \cnb\api\Model\ChatChannelStatusUpdateRequest $chat_channel_status_update_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateStatusRequest($workspace_id, $channel_id, $chat_channel_status_update_request, string $contentType = self::contentTypes['updateStatus'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updateStatus'
            );
        }

        // verify the required parameter 'channel_id' is set
        if ($channel_id === null || (is_array($channel_id) && count($channel_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $channel_id when calling updateStatus'
            );
        }

        // verify the required parameter 'chat_channel_status_update_request' is set
        if ($chat_channel_status_update_request === null || (is_array($chat_channel_status_update_request) && count($chat_channel_status_update_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $chat_channel_status_update_request when calling updateStatus'
            );
        }


        $resourcePath = '/v1/chat/workspace/{workspaceId}/channel/{channelId}/status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspaceId' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($channel_id !== null) {
            $resourcePath = str_replace(
                '{' . 'channelId' . '}',
                ObjectSerializer::toPathValue($channel_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/html', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($chat_channel_status_update_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($chat_channel_status_update_request));
            } else {
                $httpBody = $chat_channel_status_update_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('SESSION');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('x-cnb-api-key');
        if ($apiKey !== null) {
            $headers['x-cnb-api-key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PATCH',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
