(function(){
    const container = document.getElementById('calendareto-valentine-countdown');
    if(!container) return;
    const el = document.getElementById('calendareto-valentine-countdown-timer');
    if(!el) return;

    function getCalendaretoDates(now){
        let year = now.getFullYear();
        const start = new Date(year, 1, 14, 0, 0, 0);
        const end   = new Date(year, 1, 15, 0, 0, 0);
        
        if( now < start ) return {start, end};
        if( now >= start && now <= end ) return {start, end, today: true};
        year++;
        return {
            start: new Date(year, 1, 14, 0, 0, 0),
            end:   new Date(year, 1, 15, 0, 0, 0)
        };
    }

    const bgClasses = ['bg-animate-1','bg-animate-2'];
    let bgIndex = 0;

    function updateCountdown(){
        const now = new Date();
        const dates = getCalendaretoDates(now);

        if(dates.today){
            el.innerHTML = el.dataset.today;
            container.classList.add('today-is-holiday');
            return;
        }

        const diff = dates.start - now;
        const d = Math.floor(diff / (1000*60*60*24));
        const h = Math.floor((diff / (1000*60*60)) % 24);
        const m = Math.floor((diff / (1000*60)) % 60);
        const s = Math.floor((diff / 1000) % 60);
        var to_print = '';
        if( d>0 ) to_print += `${d}<i>d</i> `;
        to_print += `${h}<u>:</u>${m}<u>:</u>${s}`;
        //el.innerHTML = `${d}d ${h}h ${m}m ${s}s`;
        el.innerHTML = to_print;

        container.classList.remove(...bgClasses);
        container.classList.add(bgClasses[bgIndex]);
        bgIndex = (bgIndex + 1) % bgClasses.length;
    }

    updateCountdown();
    setInterval(updateCountdown, 1000);
    
})();
