<?php

namespace calendareto;

if (!function_exists('calendareto_get_valentine_translations')) {
    function calendareto_get_valentine_translations( $lang_code = 'en' ) {
        $langs = [
            'en' => [
                'title'   => '❤️ Valentine’s Day Countdown',
                'loading' => 'Loading...',
                'day'     => 'Valentine’s Day: ',
                'more'    => 'More about Valentine’s Day →',
                'today'   => '💘 It’s Valentine’s Day!'
            ],
            'nl' => [
                'title'   => '❤️ Aftellen tot Valentijnsdag',
                'loading' => 'Bezig met laden...',
                'day'     => 'Valentijnsdag: ',
                'more'    => 'Meer over Valentijnsdag →',
                'today'   => '💘 Het is Valentijnsdag!'
            ],
            'tr' => [
                'title'   => '❤️ Sevgililer Günü Geri Sayımı',
                'loading' => 'Yükleniyor...',
                'day'     => 'Sevgililer Günü: ',
                'more'    => 'Sevgililer Günü hakkında daha fazlası →',
                'today'   => '💘 Bugün Sevgililer Günü!'
            ],
            'fa' => [
                'title'   => '❤️ شمارش معکوس روز ولنتاین',
                'loading' => 'در حال بارگذاری...',
                'day'     => 'روز ولنتاین: ',
                'more'    => 'بیشتر درباره روز ولنتاین →',
                'today'   => '💘 امروز روز ولنتاین است!'
            ],
        ];

        return $langs[$lang_code] ?? $langs['en'];
    }
}
