<?php
/**
 * Calendareto.com
 * @package           Calendareto Valentine Countdown
 * @author            Jafar Naghizadeh
 * @copyright         2025 Calendareto.com
 * @license           GPL-2.0-or-later
 * @wordpress-plugin
 * Plugin Name:       Calendareto Valentine Countdown
 * Plugin URI:        https://calendareto.com
 * Description:       Simple countdown timer for Valentine’s Day ❤️ Add via shortcode [calendareto valentine countdown]. Developed by Jafar Naghizadeh with 💙 for wordpress ;)
 * Version:           1.0.4
 * Requires at least: 4.7
 * Requires PHP:      7.2
 * Author:            Jafar Naghizadeh
 * Author URI:        https://matisweb.com
 * Text Domain:       calendareto-valentine-countdown
 * License:           GPL v2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 

if ( ! function_exists( 'calendareto_com_shortcode_runner' ) ) {
    function calendareto_com_shortcode_runner( $atts ) {
        $default_output = ( defined('WP_DEBUG') && WP_DEBUG ) ?'Calendareto: Countdown plugin missing!' :'';
        return apply_filters( 'calendareto_com_countdown_render_output', $default_output, $atts );
    }
    add_shortcode( 'calendareto', 'calendareto_com_shortcode_runner' );
}

if (!function_exists('calendareto_com_valentine_countdown_render')) {
    function calendareto_com_valentine_countdown_render( $output, $atts ) {

        $atts = array_values($atts);
        if ( ! isset($atts[0]) || strtolower($atts[0]) !== "valentine"
            || ! isset($atts[1]) || strtolower($atts[1]) !== "countdown" )
            return $output;

        require_once "includes/lang.php";
        $lang_code = isset($atts[2]) ? strtolower($atts[2]) : 'en';
        $lang = calendareto\calendareto_get_valentine_translations( $lang_code );
        $now = current_time('timestamp');
        $year = gmdate('Y', $now);
        $valentine = mktime(0, 0, 0, 2, 14, $year);
        $valentine_date_str = '';
        if ( date('md', $now) !== '0214' ) {
            if ( $now > $valentine ){
                $year++;
                //$valentine = mktime(0, 0, 0, 2, 14, $year);
            }
            $valentine_date_str = "{$lang['day']} February 14, $year";
        }

        ob_start(); ?>
        <div id="calendareto-valentine-countdown">
            <h3><?php echo esc_html($lang['title']); ?></h3>
            <div id="calendareto-valentine-countdown-timer" data-today="<?php echo esc_attr($lang['today']); ?>"><?php echo esc_html($lang['loading']); ?></div>
            <?php echo $valentine_date_str ? "<small>".esc_html( $valentine_date_str )."</small>" : ""; ?>
        </div>
        <?php
        return ob_get_clean();
    }
    
    //add_shortcode( 'calendareto', 'calendareto_com_valentine_countdown_shortcode' );
    add_filter( 'calendareto_com_countdown_render_output', 'calendareto_com_valentine_countdown_render', 10, 2 );
}



if (!function_exists('calendareto_com_valentine_enqueue_assets')) {
    function calendareto_com_valentine_enqueue_assets() {
        wp_enqueue_style(
            'calendareto-valentine-style',
            plugin_dir_url(__FILE__) . 'assets/css/style.css',
            [],
            '1.0.3'
        );

        wp_enqueue_script(
            'calendareto-valentine-script',
            plugin_dir_url(__FILE__) . 'js/countdown.js',
            [],
            '1.0.3',
            true
        );
    }
    add_action('wp_enqueue_scripts', 'calendareto_com_valentine_enqueue_assets');
}


if (!function_exists('calendareto_com_valentine_countdown_install')) {
    function calendareto_com_valentine_countdown_install() {
        add_option( 'calendareto_valentine_version', '1.0.0' );
    }
    register_activation_hook( __FILE__, 'calendareto_com_valentine_countdown_install' );
}

if (!function_exists('calendareto_com_valentine_countdown_uninstall')) {
    function calendareto_com_valentine_countdown_uninstall() {
        delete_option( 'calendareto_valentine_version' );
    }
    register_uninstall_hook( __FILE__, 'calendareto_com_valentine_countdown_uninstall' );
}

