<?php

namespace calendareto;

if (!function_exists('calendareto_get_christmas_translations')) {
    function calendareto_get_christmas_translations( $lang_code = 'en' ) {
        $langs = [
            'en' => [
                'title'   => '🎄 Christmas Countdown',
                'loading' => 'Loading...',
                'day'     => 'Christmas Day: ',
                'more'    => 'More about Christmas →',
                'today'   => '🎅 It’s Christmas Day!'
            ],
            'nl' => [
                'title'   => '🎄 Aftellen tot Kerstmis',
                'loading' => 'Bezig met laden...',
                'day'     => 'Kerstmis: ',
                'more'    => 'Meer over Kerstmis →',
                'today'   => '🎅 Het is Kerstmis!'
            ],
            'tr' => [
                'title'   => '🎄 Noel Geri Sayımı',
                'loading' => 'Yükleniyor...',
                'day'     => 'Noel Günü: ',
                'more'    => 'Noel hakkında daha fazlası →',
                'today'   => '🎅 Bugün Noel!'
            ],
            'fa' => [
                'title'   => '🎄 شمارش معکوس تا کریسمس',
                'loading' => 'در حال بارگذاری...',
                'day'     => 'روز کریسمس: ',
                'more'    => 'بیشتر درباره کریسمس →',
                'today'   => '🎅 امروز روز کریسمس است!'
            ],
        ];

        return $langs[$lang_code] ?? $langs['en'];
    }
}
