<?php
/**
 * Calendareto.com
 * @package           Calendareto Christmas Countdown
 * @author            Jafar Naghizadeh
 * @copyright         2025 Calendareto.com
 * @license           GPL-2.0-or-later
 * @wordpress-plugin
 * Plugin Name:       Calendareto Christmas Countdown
 * Plugin URI:        https://calendareto.com
 * Description:       Simple countdown timer for Christmas Day ❤️ Add via shortcode [calendareto christmas countdown]. Developed by Jafar Naghizadeh with 💙 for wordpress ;)
 * Version:           1.0.1
 * Requires at least: 4.7
 * Requires PHP:      7.2
 * Author:            Jafar Naghizadeh
 * Author URI:        https://matisweb.com
 * Text Domain:       calendareto-christmas-countdown
 * License:           GPL v2 or later
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 

if ( ! function_exists( 'calendareto_com_shortcode_runner' ) ) {
    function calendareto_com_shortcode_runner( $atts ) {
        $default_output = ( defined('WP_DEBUG') && WP_DEBUG ) ?'Calendareto: Countdown plugin missing!' :'';
        return apply_filters( 'calendareto_com_countdown_render_output', $default_output, $atts );
    }
    add_shortcode( 'calendareto', 'calendareto_com_shortcode_runner' );
}

if (!function_exists('calendareto_com_christmas_countdown_render')) {
    function calendareto_com_christmas_countdown_render( $output, $atts ) {

        $atts = array_values($atts);
        if ( ! isset($atts[0]) || strtolower($atts[0]) !== "christmas"
            || ! isset($atts[1]) || strtolower($atts[1]) !== "countdown" )
            return $output;

        require_once "includes/lang.php";
        $lang_code = isset($atts[2]) ? strtolower($atts[2]) : 'en';
        $lang = calendareto\calendareto_get_christmas_translations( $lang_code );
        $now = current_time('timestamp');
        $year = gmdate('Y', $now);
        $christmas = mktime(0, 0, 0, 12, 25, $year);
        $christmas_date_str = '';
        if ( gmdate('md', $now) !== '1225' ) {
            if ( $now > $christmas ){
                $year++;
                //$christmas = mktime(0, 0, 0, 12, 25, $year);
            }
            $christmas_date_str = "{$lang['day']} December 25, $year";
        }

        ob_start(); ?>
        <div id="calendareto-christmas-countdown">
            <h3><?php echo esc_html($lang['title']); ?></h3>
            <div id="calendareto-christmas-countdown-timer" data-today="<?php echo esc_attr($lang['today']); ?>"><?php echo esc_html($lang['loading']); ?></div>
            <?php echo $christmas_date_str ? "<small>".esc_html( $christmas_date_str )."</small>" : ""; ?>
        </div>
        <?php
        return ob_get_clean();
    }

    //add_shortcode( 'calendareto', 'calendareto_com_christmas_countdown_shortcode' );
    add_filter( 'calendareto_com_countdown_render_output', 'calendareto_com_christmas_countdown_render', 10, 2 );

}

if (!function_exists('calendareto_com_christmas_enqueue_assets')) {
    function calendareto_com_christmas_enqueue_assets() {
        wp_enqueue_style(
            'calendareto-christmas-style',
            plugin_dir_url(__FILE__) . 'assets/css/style.css',
            [],
            '1.0'
        );

        wp_enqueue_script(
            'calendareto-christmas-script',
            plugin_dir_url(__FILE__) . 'js/countdown.js',
            [],
            '1.0',
            true
        );
    }
    add_action('wp_enqueue_scripts', 'calendareto_com_christmas_enqueue_assets');
}


if (!function_exists('calendareto_com_christmas_countdown_install')) {
    function calendareto_com_christmas_countdown_install() {
        add_option( 'calendareto_christmas_version', '1.0.0' );
    }
    register_activation_hook( __FILE__, 'calendareto_com_christmas_countdown_install' );
}

if (!function_exists('calendareto_com_christmas_countdown_uninstall')) {
    function calendareto_com_christmas_countdown_uninstall() {
        delete_option( 'calendareto_christmas_version' );
    }
    register_uninstall_hook( __FILE__, 'calendareto_com_christmas_countdown_uninstall' );
}

