fbuilderjQuery = (typeof fbuilderjQuery != 'undefined' ) ? fbuilderjQuery : jQuery;
fbuilderjQuery[ 'fbuilder' ] = fbuilderjQuery[ 'fbuilder' ] || {};
fbuilderjQuery[ 'fbuilder' ][ 'modules' ] = fbuilderjQuery[ 'fbuilder' ][ 'modules' ] || {};

fbuilderjQuery[ 'fbuilder' ][ 'modules' ][ 'health' ] = {
	'tutorial' : 'https://cff.dwbooster.com/documentation#health-module',
	'toolbars'		: {
		'health' : {
			'label' : 'Health-Related Operations',
			'buttons' : [
							{ "value" : "IDEALWEIGHTCALCULATOR", "code" : "IDEALWEIGHTCALCULATOR(", "tip" : "<p>Calculates the ideal weight based on gender and height. <strong>IDEALWEIGHTCALCULATOR( gender, height, system of units )</strong></p><p><b>gender</b>: male or female<br><b>height</b>: height in centimeters or inches<br><b>system of units</b>: metric or imperial (optional parameter, metric is used by default)</p><p><strong>IDEALWEIGHTCALCULATOR(&quot;male&quot;, 180, &quot;metric&quot;)</strong></p><p>Result: <strong>72</strong></p>" },

							{ "value" : "BMICALCULATOR", "code" : "BMICALCULATOR(", "tip" : "<p>Calculates the BMI (Body Mass Index). <strong>BMICALCULATOR( height, weight, system of units, return as text )</strong></p><p><b>height</b>: height in centimeters or inches<br><b>weight</b>: weight in kilograms or pounds<br><b>system of units</b>: metric or imperial (optional parameter, metric is used by default)<br><b>return as text</b>: true or false (optional parameter, false used by default). If return as a text is true, the operation returns one of the Underweight, Normal, Overweight, or Obese</p><p><strong>BMICALCULATOR(169, 70, &quot;metric&quot;, true)</strong></p><p>Result: <strong>Normal</strong></p><p><strong>BMICALCULATOR(169, 70, &quot;metric&quot;, false)</strong></p><p>Result: <strong>24.51</strong></p>" },

							{ "value" : "BMRCALCULATOR", "code" : "BMRCALCULATOR(", "tip" : "<p>Calculates the BMR (Basal Metabolic Rate). <strong>BMRCALCULATOR( age, gender, height, weight, system of units )</strong></p><p><b>age</b>: age in years<br><b>gender</b>: male or female<br><b>height</b>: height in centimeters or inches<br><b>weight</b>: weight in kilograms or pounds<br><b>system of units</b>: metric or imperial (optional parameter, metric is used by default)</p><p><strong>BMRCALCULATOR(47, &quot;male&quot;, 169, 70, &quot;metric&quot;)</strong></p><p>Result: <strong>1526.25</strong></p>" },

							{ "value" : "MAINTENANCECALORIESCALCULATOR", "code" : "MAINTENANCECALORIESCALCULATOR(", "tip" : "<p>Calculates the number of calories a person needs to consume each day to maintain their weight. <strong>MAINTENANCECALORIESCALCULATOR( age, gender, height, weight, system of units, activity )</strong></p><p><b>age</b>: age in years<br><b>gender</b>: male or female<br><b>height</b>: height in centimeters or inches<br><b>weight</b>: weight in kilograms or pounds<br><b>system of units</b>: metric or imperial (optional parameter, metric is used by default)<br><b>activity</b>: any of the texts: <br><br>sedentary (for little or no exercise), <br>light (exercise 1-3 times/week), <br>moderate (exercise 4-5 times/week), <br>active (daily exercise or intense exercise 3-4 times/week), <br>very (intense exercise 6-7 times/week), <br>extra (very intense exercise daily, or physical job) (optional parameter, moderate is used by default)</p><p><strong>MAINTENANCECALORIESCALCULATOR(47, &quot;male&quot;, 169, 70, &quot;metric&quot;, &quot;moderate&quot;)</strong></p><p>Result: <strong>2236</strong></p>" },

							{ "value" : "BYGOALCALORIESCALCULATOR", "code" : "BYGOALCALORIESCALCULATOR(", "tip" : "<p>Calculates the number of calories a person needs to consume each day to reach their weight goal. <strong>BYGOALCALORIESCALCULATOR( age, gender, height, weight, system of units, activity, goal, get details )</strong></p><p><b>age</b>: age in years<br><b>gender</b>: male or female<br><b>height</b>: height in centimeters or inches<br><b>weight</b>: weight in kilograms or pounds<br><b>system of units</b>: metric or imperial (optional parameter, metric is used by default)<br><b>activity</b>: daily activity descriptor: <br><br>sedentary (for little or no exercise), <br>light (exercise 1-3 times/week), <br>moderate (exercise 4-5 times/week), <br>active (daily exercise or intense exercise 3-4 times/week), <br>very (intense exercise 6-7 times/week), <br>extra (very intense exercise daily, or physical job) (optional parameter, moderate is used by default)<br><br><b>goal</b>: weight goal, accept any of the following terms: lose, maintain, or gain (optional, maintain by default)<br><b>get details</b>: accept true or false (optional, false by default). If get details is false, the BYGOALCALORIESCALCULATOR operation returns the number of calories to consume to reach the goal. If it is true, returns a plain object with the following properties:<br><br>calories: daily calories to consume<br>proteins: recommended grams of proteins<br>carbs: recommended grams of carbs<br>fat: recommended grams of fat</p><p><strong>BYGOALCALORIESCALCULATOR(47, &quot;male&quot;, 169, 70, &quot;metric&quot;, &quot;moderate&quot;,&quot;lose&quot;,true)</strong></p><p>Result: <strong>{calories: 1736, proteins: 154, fat: 48, carbs: 172}</strong></p>" },

							{ "value" : "WATERINTAKECALCULATOR", "code" : "WATERINTAKECALCULATOR(", "tip" : "<p>Calculates how many liters of water a person should consume daily. <strong>WATERINTAKECALCULATOR( age, gender, weight, system of units, activity, climate )</strong></p><p><b>age</b>: age in years<br><b>gender</b>: male or female<br><b>weight</b>: weight in kilograms or pounds<br><b>system of units</b>: metric or imperial (optional parameter, metric is used by default)<br><b>activity</b>: daily activity descriptor: <br><br>sedentary (for little or no exercise), <br>light (exercise 1-3 times/week), <br>moderate (exercise 4-5 times/week), <br>very (intense exercise 6-7 times/week), <br>extra (very intense exercise daily, or physical job) (optional parameter, moderate is used by default)<br><br><b>climate</b>: accept any of the following terms: cold, mild, warm, or hot (optional, mild by default)</p><p><strong>WATERINTAKECALCULATOR(47, &quot;male&quot;, 70, &quot;metric&quot;, &quot;sedentary&quot;,&quot;cold&quot;)</strong></p><p>Result: <strong>3.09</strong></p>" },

							{ "value" : "HIPTOWAISTRATIOCALCULATOR", "code" : "HIPTOWAISTRATIOCALCULATOR(", "tip" : "<p>Calculates the hip to waist ratio, the body shape, health risks, and the hip-to-waist ideal ratio. <strong>HIPTOWAISTRATIOCALCULATOR( gender, hip measurement, waist measurement )</strong></p><p><b>gender</b>: male or female<br><b>hip measurement</b><br><b>waist measurement</b></p><p>Return a plain object with the properties:<br><br>ratio: hip-to-waist ratio<br>ideal: ideal ratio range<br>shape: body shape (pear, avocado, or apple)<br>rist: health risk based on hip-to-waist ratio (Low health risk, Moderate health risk, High health risk)</p><p><strong>HIPTOWAISTRATIOCALCULATOR(&quot;male&quot;, 91, 86)</strong></p><p>Result: <strong>{ratio: 0.95, shape: avocado, risk: Low health risk, ideal: 0.9-1.0}</strong></p>" }
						]
		}
	}
};