<?php
/**
 * Chat Widget Template for Bytesweavers AI Chat Master.
 *
 * This file outputs the front-end chat widget, including its toggle, header, messages,
 * typing indicator, and input form.
 *
 * @package AI_Chat_Master
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Determine the icon animation state based on the option.
$animation_enabled = get_option( 'aicw_enable_icon_animation', true );
$animation_class   = $animation_enabled ? 'aicw-animate-enabled' : 'aicw-animate-disabled';
?>
<div id="aicw-container" style="--primary-color: <?php echo esc_attr( $settings['primary_color'] ); ?>;">
    <div class="aicw-toggle <?php echo esc_attr( $position_class . ' ' . $animation_class ); ?>">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
            <path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-2 12H6v-2h12v2zm0-3H6V9h12v2zm0-3H6V6h12v2z"/>
        </svg>
        <div class="aicw-hover-message"><?php esc_html_e( 'How can I help you?', 'bytesweavers-ai-chat-master' ); ?></div>
    </div>
    <div class="aicw-widget <?php echo esc_attr( $position_class ); ?>" style="width: <?php echo esc_attr( $settings['width'] ); ?>px; height: <?php echo esc_attr( $settings['height'] ); ?>px;">
        <div class="aicw-header">
            <div class="aicw-header-text">
                <div class="aicw-title-container">
                    <div class="aicw-default-logo">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100">
                            <rect x="20" y="20" width="60" height="60" rx="10" fill="#1E3A8A" />
                            <circle cx="40" cy="45" r="8" fill="#F0F9FF" />
                            <circle cx="60" cy="45" r="8" fill="#F0F9FF" />
                            <circle cx="40" cy="45" r="4" fill="#0F172A" />
                            <circle cx="60" cy="45" r="4" fill="#0F172A" />
                            <rect x="35" y="65" width="30" height="5" rx="2" fill="#F0F9FF" />
                            <line x1="50" y1="20" x2="50" y2="10" stroke="#1E3A8A" stroke-width="4" />
                            <circle cx="50" cy="8" r="4" fill="#DC2626" />
                            <circle cx="43" cy="42" r="2" fill="#F0F9FF" />
                            <circle cx="63" cy="42" r="2" fill="#F0F9FF" />
                        </svg>
                    </div>
                    <div class="aicw-title-text">
                        <h3 class="aicw-title"><?php echo esc_html( $settings['title'] ); ?></h3>
                        <div class="aicw-online-status">
                            <span class="aicw-status-dot"></span>
                            <span class="aicw-status-text"><?php esc_html_e( 'Online', 'bytesweavers-ai-chat-master' ); ?></span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="aicw-menu-container">
                <div class="aicw-close">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="white">
                        <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z"/>
                    </svg>
                </div>
            </div>
        </div>
        <div class="aicw-messages">
            <?php 
            // Set up a default welcome message.
            $welcome_content = __( "👋 Hello! How can I help you today?", "bytesweavers-ai-chat-master" );
            $welcome_message = array(
                array(
                    'content'   => $welcome_content,
                    'type'      => 'assistant',
                    'timestamp' => current_time( 'H:i' ),
                    'isWelcome' => true
                )
            );
            ?>
            <script type="text/javascript">
                window.aicwInitialMessages = <?php echo wp_json_encode( $welcome_message ); ?>;
            </script>
        </div>
        <div class="aicw-typing">
            <div class="aicw-typing-indicator">
                <span></span>
                <span></span>
                <span></span>
            </div>
            <span class="aicw-typing-text"><?php echo esc_html( get_option( 'aicw_typing_indicator_text', __( 'AI is typing...', 'bytesweavers-ai-chat-master' ) ) ); ?></span>
        </div>
        <div class="aicw-input-container">
            <form class="aicw-input-form">
                <input type="text" 
                       class="aicw-input" 
                       placeholder="<?php esc_attr_e( 'Type your message...', 'bytesweavers-ai-chat-master' ); ?>" 
                       autocomplete="off"
                       aria-label="<?php esc_attr_e( 'Chat message', 'bytesweavers-ai-chat-master' ); ?>">
                <button type="submit" class="aicw-send" aria-label="<?php esc_attr_e( 'Send message', 'bytesweavers-ai-chat-master' ); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                        <path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z"/>
                    </svg>
                </button>
            </form>
        </div>
    </div>
</div>