<?php
/*
 * Admin Settings Template for Bytesweavers AI Chat Master plugin.
 * Provides the main settings interface in WordPress admin panel.
 * Includes tabs for General, API, Model, Appearance, Knowledge Base settings,
 * and Pro version upgrade options.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Verify nonce before processing form data
$settings_updated = false;
if ( isset( $_GET['settings-updated'] ) ) {
	if ( wp_verify_nonce( wp_create_nonce( 'aicw_settings_nonce' ), 'aicw_settings' ) ) {
		$settings_updated = true;
	}
}
?>
<div class="wrap">
	<h1><?php esc_html_e( 'Bytesweavers AI Chat Master Settings', 'bytesweavers-ai-chat-master' ); ?></h1>

	<?php settings_errors( 'aicw_options' ); ?>

	<?php if ( $settings_updated ) : ?>
		<div class="notice notice-success is-dismissible">
			<p><?php esc_html_e( 'Settings saved successfully!', 'bytesweavers-ai-chat-master' ); ?></p>
		</div>
	<?php endif; ?>

	<form method="post" action="options.php">
		<?php 
		settings_fields( 'aicw_options' );
		wp_nonce_field( 'aicw_settings', 'aicw_settings_nonce' );
		?>

		<div class="nav-tab-wrapper">
			<a href="#general" class="nav-tab nav-tab-active"><?php esc_html_e( 'General', 'bytesweavers-ai-chat-master' ); ?></a>
			<a href="#api" class="nav-tab"><?php esc_html_e( 'API Settings', 'bytesweavers-ai-chat-master' ); ?></a>
			<a href="#model" class="nav-tab"><?php esc_html_e( 'Model Settings', 'bytesweavers-ai-chat-master' ); ?></a>
			<a href="#appearance" class="nav-tab"><?php esc_html_e( 'Appearance', 'bytesweavers-ai-chat-master' ); ?></a>
			<a href="#knowledge" class="nav-tab"><?php esc_html_e( 'Knowledge Base', 'bytesweavers-ai-chat-master' ); ?></a>
			<a href="#upgrade" class="nav-tab"><?php esc_html_e( 'Upgrade to Pro', 'bytesweavers-ai-chat-master' ); ?></a>
			<a href="#about" class="nav-tab"><?php esc_html_e( 'About', 'bytesweavers-ai-chat-master' ); ?></a>
		</div>

		<!-- General Tab Content -->
		<div id="general" class="tab-content" style="display:block;">
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Enable AI Chat Widget', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<label>
							<input type="checkbox" name="aicw_enable_widget" value="1" <?php checked( get_option( 'aicw_enable_widget' ), 1 ); ?>>
							<?php esc_html_e( 'Enable the AI Chat Widget', 'bytesweavers-ai-chat-master' ); ?>
						</label>
						<p class="description"><?php esc_html_e( 'Check to enable the chat widget on your site.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Display On', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<select name="aicw_display_option" id="aicw_display_option">
							<option value="all" <?php selected( get_option( 'aicw_display_option' ), 'all' ); ?>><?php esc_html_e( 'All Pages', 'bytesweavers-ai-chat-master' ); ?></option>
							<option value="some" <?php selected( get_option( 'aicw_display_option' ), 'some' ); ?>><?php esc_html_e( 'Specific Pages', 'bytesweavers-ai-chat-master' ); ?></option>
						</select>
						<p class="description"><?php esc_html_e( 'Choose whether the chat widget is displayed on all pages or only specific pages.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr id="aicw_specific_pages_row" style="display:none;">
					<th scope="row"><?php esc_html_e( 'Specific Page IDs', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="text" name="aicw_specific_pages" class="regular-text" value="<?php echo esc_attr( get_option( 'aicw_specific_pages' ) ); ?>">
						<p class="description"><?php esc_html_e( 'Enter a comma-separated list of page IDs on which the chat widget should appear. Example: 12, 25, 98', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Widget Title (Chatbot Name)', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="text" name="aicw_widget_title" class="regular-text" value="<?php echo esc_attr( get_option( 'aicw_widget_title', AICW_DEFAULT_WIDGET_TITLE ) ); ?>">
						<p class="description"><?php esc_html_e( 'The title/name displayed at the top of the chat widget.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Widget Subtitle', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="text" name="aicw_widget_subtitle" class="regular-text" value="<?php echo esc_attr( get_option( 'aicw_widget_subtitle' ) ); ?>">
						<p class="description"><?php esc_html_e( 'A brief welcome message or description.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<?php esc_html_e( 'Chat History', 'bytesweavers-ai-chat-master' ); ?>
						<span class="pro-badge"><a href="javascript:void(0)" class="upgrade-pro-link">Upgrade to Pro</a></span>
					</th>
					<td>
						<label>
							<input type="checkbox" name="aicw_chat_history" value="1" disabled>
							<?php esc_html_e( 'Enable chat history storage', 'bytesweavers-ai-chat-master' ); ?>
						</label>
						<p class="description"><?php esc_html_e( 'Store chat histories for returning visitors.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<?php esc_html_e( 'Memory', 'bytesweavers-ai-chat-master' ); ?>
						<span class="pro-badge"><a href="javascript:void(0)" class="upgrade-pro-link">Upgrade to Pro</a></span>
					</th>
					<td>
						<label>
							<input type="checkbox" name="aicw_memory_enabled" value="1" disabled>
							<?php esc_html_e( 'Enable Memory (remember previous conversation in a single chat)', 'bytesweavers-ai-chat-master' ); ?>
						</label>
						<p class="description"><?php esc_html_e( 'Pass previous conversation messages as context to the AI.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<?php esc_html_e( 'Require User Details', 'bytesweavers-ai-chat-master' ); ?>
						<span class="pro-badge"><a href="javascript:void(0)" class="upgrade-pro-link">Upgrade to Pro</a></span>
					</th>
					<td>
						<label>
							<input type="checkbox" name="aicw_require_user_details" value="1" disabled>
							<?php esc_html_e( 'Require email and name before starting chat', 'bytesweavers-ai-chat-master' ); ?>
						</label>
						<p class="description"><?php esc_html_e( 'Users must provide email and name to initiate a chat.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<?php esc_html_e( 'Voice to Text Support', 'bytesweavers-ai-chat-master' ); ?>
						<span class="pro-badge"><a href="javascript:void(0)" class="upgrade-pro-link">Upgrade to Pro</a></span>
					</th>
					<td>
						<label>
							<input type="checkbox" name="aicw_enable_voice_to_text" value="1" disabled>
							<?php esc_html_e( 'Enable voice to text feature in chat widget', 'bytesweavers-ai-chat-master' ); ?>
						</label>
						<p class="description"><?php esc_html_e( 'Allows users to dictate messages using their microphone.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<?php esc_html_e( 'File Upload Support', 'bytesweavers-ai-chat-master' ); ?>
						<span class="pro-badge"><a href="javascript:void(0)" class="upgrade-pro-link">Upgrade to Pro</a></span>
					</th>
					<td>
						<label>
							<input type="checkbox" name="aicw_enable_file_upload" value="1" disabled>
							<?php esc_html_e( 'Enable file upload feature in chat widget', 'bytesweavers-ai-chat-master' ); ?>
						</label>
						<p class="description"><?php esc_html_e( 'Allows users to upload images and documents.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
			</table>
            <div class="submit-wrapper">
                <?php submit_button( __( 'Save Settings', 'bytesweavers-ai-chat-master' ) ); ?>
            </div>
		</div>

		<!-- API Settings Tab Content -->
		<div id="api" class="tab-content" style="display: none;">
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'AI Model', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<select name="aicw_selected_model" id="aicw_selected_model" class="regular-text">
							<optgroup label="<?php esc_attr_e( 'OpenAI Models', 'bytesweavers-ai-chat-master' ); ?>">
								<option value="gpt-4o-2024-08-06" <?php selected( get_option( 'aicw_selected_model' ), 'gpt-4o-2024-08-06' ); ?>><?php esc_html_e( 'GPT-4o (Ultra-fast, high accuracy)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="gpt-4o-mini-2024-07-18" <?php selected( get_option( 'aicw_selected_model' ), 'gpt-4o-mini-2024-07-18' ); ?>><?php esc_html_e( 'GPT-4o Mini (Budget-friendly, efficient)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="chatgpt-4o-latest" <?php selected( get_option( 'aicw_selected_model' ), 'chatgpt-4o-latest' ); ?>><?php esc_html_e( 'ChatGPT-4o Latest (Enhanced reasoning)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="gpt-4-turbo-preview" <?php selected( get_option( 'aicw_selected_model' ), 'gpt-4-turbo-preview' ); ?>><?php esc_html_e( 'GPT-4 Turbo (128K context)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="gpt-4" <?php selected( get_option( 'aicw_selected_model' ), 'gpt-4' ); ?>><?php esc_html_e( 'GPT-4 (8K context)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="gpt-3.5-turbo" <?php selected( get_option( 'aicw_selected_model' ), 'gpt-3.5-turbo' ); ?>><?php esc_html_e( 'GPT-3.5 Turbo (16K context)', 'bytesweavers-ai-chat-master' ); ?></option>
							</optgroup>
							<optgroup label="<?php esc_attr_e( 'Anthropic Models', 'bytesweavers-ai-chat-master' ); ?>">
								<option value="claude-3-7-sonnet-20250219" <?php selected( get_option( 'aicw_selected_model' ), 'claude-3-7-sonnet-20250219' ); ?>><?php esc_html_e( 'Claude 3.7 Sonnet (Latest & most advanced)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="claude-3-5-sonnet-20241022" <?php selected( get_option( 'aicw_selected_model' ), 'claude-3-5-sonnet-20241022' ); ?>><?php esc_html_e( 'Claude 3.5 Sonnet (High intelligence)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="claude-3-5-haiku-20241022" <?php selected( get_option( 'aicw_selected_model' ), 'claude-3-5-haiku-20241022' ); ?>><?php esc_html_e( 'Claude 3.5 Haiku (Fast & cost-effective)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="claude-3-opus-20240229" <?php selected( get_option( 'aicw_selected_model' ), 'claude-3-opus-20240229' ); ?>><?php esc_html_e( 'Claude 3 Opus (200K context)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="claude-3-sonnet-20240229" <?php selected( get_option( 'aicw_selected_model' ), 'claude-3-sonnet-20240229' ); ?>><?php esc_html_e( 'Claude 3 Sonnet (200K context)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="claude-3-haiku-20240307" <?php selected( get_option( 'aicw_selected_model' ), 'claude-3-haiku-20240307' ); ?>><?php esc_html_e( 'Claude 3 Haiku (200K context)', 'bytesweavers-ai-chat-master' ); ?></option>
							</optgroup>
							<optgroup label="<?php esc_attr_e( 'Google Models', 'bytesweavers-ai-chat-master' ); ?>">
								<option value="gemini-2.0-pro-exp-02-05" <?php selected( get_option( 'aicw_selected_model' ), 'gemini-2.0-pro-exp-02-05' ); ?>><?php esc_html_e( 'Gemini 2.0 Pro (2M context)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="gemini-2.0-flash" <?php selected( get_option( 'aicw_selected_model' ), 'gemini-2.0-flash' ); ?>><?php esc_html_e( 'Gemini 2.0 Flash (Balanced performance)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="gemini-2.0-flash-lite-preview-02-05" <?php selected( get_option( 'aicw_selected_model' ), 'gemini-2.0-flash-lite-preview-02-05' ); ?>><?php esc_html_e( 'Gemini 2.0 Flash-Lite (Cost-effective)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="gemini-1.5-pro" <?php selected( get_option( 'aicw_selected_model' ), 'gemini-1.5-pro' ); ?>><?php esc_html_e( 'Gemini 1.5 Pro (1M context)', 'bytesweavers-ai-chat-master' ); ?></option>
								<option value="gemini-1.5-flash" <?php selected( get_option( 'aicw_selected_model' ), 'gemini-1.5-flash' ); ?>><?php esc_html_e( 'Gemini 1.5 Flash (1M context)', 'bytesweavers-ai-chat-master' ); ?></option>
							</optgroup>
						</select>
						<div id="model_context_info" class="description"></div>
					</td>
				</tr>
				<tr id="aicw_openai_key_field" class="api-key-field">
					<th scope="row"><?php esc_html_e( 'OpenAI API Key', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="password" name="aicw_openai_key" id="aicw_openai_key" class="regular-text" value="<?php echo esc_attr( get_option( 'aicw_openai_key' ) ); ?>">
						<button class="button test-api-connection"><?php esc_html_e( 'Test Connection', 'bytesweavers-ai-chat-master' ); ?></button>
					</td>
				</tr>
				<tr id="aicw_anthropic_key_field" class="api-key-field">
					<th scope="row"><?php esc_html_e( 'Anthropic API Key', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="password" name="aicw_anthropic_key" id="aicw_anthropic_key" class="regular-text" value="<?php echo esc_attr( get_option( 'aicw_anthropic_key' ) ); ?>">
						<button class="button test-api-connection"><?php esc_html_e( 'Test Connection', 'bytesweavers-ai-chat-master' ); ?></button>
					</td>
				</tr>
				<tr id="aicw_gemini_key_field" class="api-key-field">
					<th scope="row"><?php esc_html_e( 'Google API Key', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="password" name="aicw_gemini_key" id="aicw_gemini_key" class="regular-text" value="<?php echo esc_attr( get_option( 'aicw_gemini_key' ) ); ?>">
						<button class="button test-api-connection"><?php esc_html_e( 'Test Connection', 'bytesweavers-ai-chat-master' ); ?></button>
					</td>
				</tr>
			</table>
            <div class="submit-wrapper">
                <?php submit_button( __( 'Save Settings', 'bytesweavers-ai-chat-master' ) ); ?>
            </div>
		</div>

		<!-- Model Settings Tab Content -->
		<div id="model" class="tab-content" style="display: none;">
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Temperature', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="range" name="aicw_temperature" min="0" max="1" step="0.1" value="<?php echo esc_attr( get_option( 'aicw_temperature', '0.7' ) ); ?>">
						<span class="temperature-value"></span>
						<p class="description"><?php esc_html_e( 'Controls randomness in responses (0 = focused, 1 = creative).', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Max Response Length', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="number" name="aicw_max_tokens" min="100" max="4000" step="100" value="<?php echo esc_attr( get_option( 'aicw_max_tokens', '1000' ) ); ?>">
						<p class="description max-tokens-info"><?php esc_html_e( 'Maximum number of tokens in the response', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Top P', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="number" name="aicw_top_p" min="0" max="1" step="0.1" value="<?php echo esc_attr( get_option( 'aicw_top_p', '1.0' ) ); ?>">
						<p class="description"><?php esc_html_e( 'Controls diversity of responses (lower values = more focused)', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Frequency Penalty', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="number" name="aicw_frequency_penalty" min="-2.0" max="2.0" step="0.1" value="<?php echo esc_attr( get_option( 'aicw_frequency_penalty', '0.0' ) ); ?>">
						<p class="description"><?php esc_html_e( 'Reduces repetition of similar phrases (-2.0 to 2.0)', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Presence Penalty', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="number" name="aicw_presence_penalty" min="-2.0" max="2.0" step="0.1" value="<?php echo esc_attr( get_option( 'aicw_presence_penalty', '0.0' ) ); ?>">
						<p class="description"><?php esc_html_e( 'Encourages discussing new topics (-2.0 to 2.0)', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
			</table>
            <div class="submit-wrapper">
                <?php submit_button( __( 'Save Settings', 'bytesweavers-ai-chat-master' ) ); ?>
            </div>
		</div>

		<!-- Appearance Tab Content -->
		<div id="appearance" class="tab-content" style="display: none;">
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Primary Color', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="text" name="aicw_primary_color" class="aicw-color-picker" value="<?php echo esc_attr( get_option( 'aicw_primary_color', '#007bff' ) ); ?>">
						<p class="description"><?php esc_html_e( 'Main color used for the chat widget.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Chat Width', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="number" name="aicw_chat_width" min="300" max="800" step="10" value="<?php echo esc_attr( get_option( 'aicw_chat_width', '380' ) ); ?>">
						<p class="description"><?php esc_html_e( 'Width of the chat widget in pixels (300-800).', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Chat Height', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="number" name="aicw_chat_height" min="400" max="800" step="10" value="<?php echo esc_attr( get_option( 'aicw_chat_height', '600' ) ); ?>">
						<p class="description"><?php esc_html_e( 'Height of the chat widget in pixels (400-800).', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Typing Indicator Text', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<input type="text" name="aicw_typing_indicator_text" class="regular-text" value="<?php echo esc_attr( get_option( 'aicw_typing_indicator_text', 'AI is typing...' ) ); ?>">
						<p class="description"><?php esc_html_e( 'Customize the text displayed when the AI is typing.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Widget Icon Animation', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<label>
							<input type="checkbox" name="aicw_enable_icon_animation" value="1" <?php checked( get_option( 'aicw_enable_icon_animation' ), true ); ?>>
							<?php esc_html_e( 'Enable tilt animation on widget icon hover', 'bytesweavers-ai-chat-master' ); ?>
						</label>
						<p class="description"><?php esc_html_e( 'Enables a slight tilt animation when users hover over the chat widget icon.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Assistant Logo', 'bytesweavers-ai-chat-master' ); ?> <span class="pro-badge"><a href="javascript:void(0)" class="upgrade-pro-link">Upgrade to Pro</a></span></th>
					<td>
						<input type="hidden" name="aicw_assistant_logo" id="aicw_assistant_logo" value="<?php echo esc_attr( get_option( 'aicw_assistant_logo' ) ); ?>">
						<button type="button" class="button aicw-upload-logo" disabled><?php esc_html_e( 'Upload Logo', 'bytesweavers-ai-chat-master' ); ?></button>
						<button type="button" class="button aicw-remove-logo" style="<?php echo get_option( 'aicw_assistant_logo' ) ? '' : 'display:none;'; ?>" disabled><?php esc_html_e( 'Remove Logo', 'bytesweavers-ai-chat-master' ); ?></button>
						<div class="aicw-logo-preview">
							<?php
							$logo_id = get_option( 'aicw_assistant_logo' );
							if ( $logo_id ) {
								echo wp_get_attachment_image( $logo_id, 'thumbnail', false, array( 'alt' => esc_attr__( 'Assistant Logo', 'bytesweavers-ai-chat-master' ) ) );
							}
							?>
						</div>
						<p class="description"><?php esc_html_e( 'Upload a logo for your AI assistant. Recommended size: 64x64px.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Widget Icon', 'bytesweavers-ai-chat-master' ); ?> <span class="pro-badge"><a href="javascript:void(0)" class="upgrade-pro-link">Upgrade to Pro</a></span></th>
					<td>
						<select name="aicw_widget_icon" id="aicw_widget_icon" disabled>
							<option value="chat" selected><?php esc_html_e( 'Chat Bubble', 'bytesweavers-ai-chat-master' ); ?></option>
						</select>
						<div id="aicw_custom_icon_wrapper" style="display: none; margin-top: 10px;">
							<textarea name="aicw_custom_icon_svg" id="aicw_custom_icon_svg" class="large-text code" rows="5" placeholder="<?php esc_attr_e( 'Paste your SVG code here...', 'bytesweavers-ai-chat-master' ); ?>" disabled><?php echo esc_textarea( get_option( 'aicw_custom_icon_svg' ) ); ?></textarea>
							<p class="description"><?php esc_html_e( 'Paste your custom SVG icon code.', 'bytesweavers-ai-chat-master' ); ?></p>
						</div>
						<p class="description"><?php esc_html_e( 'Choose or customize the chat widget icon.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
			</table>
            <div class="submit-wrapper">
                <?php submit_button( __( 'Save Settings', 'bytesweavers-ai-chat-master' ) ); ?>
            </div>
		</div>

		<!-- Knowledge Base Tab Content -->
		<div id="knowledge" class="tab-content" style="display: none;">
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e( 'Knowledge Base', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<button type="button" id="trigger-scrape" class="button"><?php esc_html_e( 'Scrape Website Content Now', 'bytesweavers-ai-chat-master' ); ?></button>
						<p class="description"><?php esc_html_e( 'Click the button to manually update the knowledge base with website content.', 'bytesweavers-ai-chat-master' ); ?></p>
						<textarea name="aicw_knowledge_base" id="aicw_knowledge_base" rows="10" class="large-text"><?php echo esc_textarea( get_option( 'aicw_knowledge_base' ) ); ?></textarea>
						<p class="description"><?php esc_html_e( 'Edit the knowledge base content manually if needed.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e( 'Custom Instructions', 'bytesweavers-ai-chat-master' ); ?></th>
					<td>
						<textarea name="aicw_custom_instructions" rows="4" class="large-text"><?php echo esc_textarea( get_option( 'aicw_custom_instructions' ) ); ?></textarea>
						<p class="description"><?php esc_html_e( 'Add custom instructions or knowledge for the AI assistant.', 'bytesweavers-ai-chat-master' ); ?></p>
					</td>
				</tr>
			</table>
            <div class="submit-wrapper">
                <?php submit_button( __( 'Save Settings', 'bytesweavers-ai-chat-master' ) ); ?>
            </div>
		</div>

		<!-- Upgrade Tab Content (No Save Button here) -->
		<div id="upgrade" class="tab-content" style="display: none;">
			<div class="upgrade-container">
				<div class="upgrade-header">
					<h2><?php esc_html_e( 'Upgrade to Pro', 'bytesweavers-ai-chat-master' ); ?></h2>
					<p><?php esc_html_e( 'Unlock advanced features and enhance your AI chat experience', 'bytesweavers-ai-chat-master' ); ?></p>
				</div>
				<div class="upgrade-features">
					<div class="feature-card">
						<h3><span class="dashicons dashicons-saved"></span> <?php esc_html_e( 'Enhanced Memory', 'bytesweavers-ai-chat-master' ); ?></h3>
						<p><?php esc_html_e( 'Context-aware conversations with advanced memory capabilities', 'bytesweavers-ai-chat-master' ); ?></p>
					</div>
					<div class="feature-card">
						<h3><span class="dashicons dashicons-groups"></span> <?php esc_html_e( 'User Management', 'bytesweavers-ai-chat-master' ); ?></h3>
						<p><?php esc_html_e( 'Track conversations and analyze chat patterns', 'bytesweavers-ai-chat-master' ); ?></p>
					</div>
					<div class="feature-card">
						<h3><span class="dashicons dashicons-welcome-write-blog"></span> <?php esc_html_e( 'Custom Welcome', 'bytesweavers-ai-chat-master' ); ?></h3>
						<p><?php esc_html_e( 'Personalized welcome messages and suggested questions', 'bytesweavers-ai-chat-master' ); ?></p>
					</div>
					<div class="feature-card">
						<h3><span class="dashicons dashicons-microphone"></span> <?php esc_html_e( 'Voice Input', 'bytesweavers-ai-chat-master' ); ?></h3>
						<p><?php esc_html_e( 'Enable voice-to-text capabilities for chat', 'bytesweavers-ai-chat-master' ); ?></p>
					</div>
					<div class="feature-card">
						<h3><span class="dashicons dashicons-upload"></span> <?php esc_html_e( 'File Handling', 'bytesweavers-ai-chat-master' ); ?></h3>
						<p><?php esc_html_e( 'Allow users to upload and process files', 'bytesweavers-ai-chat-master' ); ?></p>
					</div>
					<div class="feature-card">
						<h3><span class="dashicons dashicons-admin-customizer"></span> <?php esc_html_e( 'Advanced Customization', 'bytesweavers-ai-chat-master' ); ?></h3>
						<p><?php esc_html_e( 'Custom styling, branding, and appearance options', 'bytesweavers-ai-chat-master' ); ?></p>
					</div>
				</div>
				<div class="upgrade-cta">
					<h3><?php esc_html_e( 'Get All Pro Features Today', 'bytesweavers-ai-chat-master' ); ?></h3>
					<div class="price"><?php esc_html_e( '$14', 'bytesweavers-ai-chat-master' ); ?> <small><?php esc_html_e( 'one-time payment', 'bytesweavers-ai-chat-master' ); ?></small></div>
					<p>
						<strong><?php esc_html_e( '✓ 30-day money-back guarantee', 'bytesweavers-ai-chat-master' ); ?></strong> &nbsp;•&nbsp; 
						<strong><?php esc_html_e( '✓ Lifetime updates', 'bytesweavers-ai-chat-master' ); ?></strong> &nbsp;•&nbsp; 
						<strong><?php esc_html_e( '✓ Premium support', 'bytesweavers-ai-chat-master' ); ?></strong>
					</p>
					<a href="https://www.codester.com/items/54119/ai-chat-master-pro-pro-ai-chatbot-plugin" target="_blank" class="buy-now-btn">
						<?php esc_html_e( 'Upgrade to Pro Now', 'bytesweavers-ai-chat-master' ); ?>
					</a>
				</div>
			</div>
		</div>

		<!-- About Tab Content (No Save Button here) -->
		<div id="about" class="tab-content" style="display: none;">
			<h2><?php esc_html_e( 'Bytesweavers AI Chat Master - Free Version', 'bytesweavers-ai-chat-master' ); ?></h2>
			<div class="about-section">
				<h3><?php esc_html_e( 'Created by BytesWeavers', 'bytesweavers-ai-chat-master' ); ?></h3>
				<p><?php esc_html_e( 'Bytesweavers AI Chat Master is developed by BytesWeavers.tech, specializing in innovative WordPress solutions and AI integrations.', 'bytesweavers-ai-chat-master' ); ?></p>
				<h3><?php esc_html_e( 'Version Information', 'bytesweavers-ai-chat-master' ); ?></h3>
				<p><?php esc_html_e( 'Current Version:', 'bytesweavers-ai-chat-master' ); ?> <?php echo esc_html( AICW_VERSION ); ?></p>
				<h3><?php esc_html_e( 'Features', 'bytesweavers-ai-chat-master' ); ?></h3>
				<ul>
					<li><?php esc_html_e( 'Multi-model AI support (OpenAI, Anthropic, Google)', 'bytesweavers-ai-chat-master' ); ?></li>
					<li><?php esc_html_e( 'Customizable chat interface', 'bytesweavers-ai-chat-master' ); ?></li>
					<li><?php esc_html_e( 'Knowledge base integration', 'bytesweavers-ai-chat-master' ); ?></li>
					<li><?php esc_html_e( 'Context-aware responses', 'bytesweavers-ai-chat-master' ); ?></li>
					<li><?php esc_html_e( 'Mobile-responsive design', 'bytesweavers-ai-chat-master' ); ?></li>
				</ul>
				<h3><?php esc_html_e( 'Note', 'bytesweavers-ai-chat-master' ); ?></h3>
				<p><?php esc_html_e( 'This is the free version of Bytesweavers AI Chat Master. Upgrade to the Pro version to unlock additional features such as chat history, memory, user data collection, welcome questions, voice-to-text, file uploads, and custom branding options.', 'bytesweavers-ai-chat-master' ); ?></p>
				<h3><?php esc_html_e( 'Support', 'bytesweavers-ai-chat-master' ); ?></h3>
				<p><?php esc_html_e( 'For support inquiries, please visit our', 'bytesweavers-ai-chat-master' ); ?> <a href="https://bytesweavers.tech/support" target="_blank"><?php esc_html_e( 'support portal', 'bytesweavers-ai-chat-master' ); ?></a>.</p>
			</div>
		</div>
	</form>
</div>