<?php

/**
 * Chat Processor class for Bytesweavers AI Chat Master.
 *
 * This class handles processing of chat messages by obtaining website context
 * and passing user messages through the API Handler.
 *
 * @package Bytesweavers_AI_Chat_Master
 */

namespace AICW;

class Chat_Processor {
    private $api_handler;
    private $data_scraper;

    /**
     * Constructor.
     */
    public function __construct() {
        $this->api_handler = new API_Handler();
        $this->data_scraper = new Data_Scraper();
    }

    /**
     * Process a chat message.
     *
     * @param string $message User message.
     * @param string $session_id Session ID.
     * @return array Response array.
     */
    public function process_message($message, $session_id) {
        // Retrieve website context.
        $context = $this->data_scraper->get_website_summary();

        // Process the message using the API Handler.
        $response = $this->api_handler->process_message($message, $context);

        if (is_array($response) && isset($response['error'])) {
            return array(
                'success' => false,
                'response' => __('Sorry, there was an error processing your request: ', 'bytesweavers-ai-chat-master') . $response['error'],
                'timestamp' => current_time('mysql')
            );
        }

        return array(
            'success' => true,
            'response' => $response,
            'timestamp' => current_time('mysql')
        );
    }
}