<?php

/**
 * Plugin Name: Bytesweavers AI Chat Master
 * Plugin URI: https://bytesweavers.tech/ai-chat-master
 * Description: A robust AI chat plugin for WordPress providing multi-model support.
 * Version: 1.0.0
 * Author: Bytesweavers
 * Author URI: https://bytesweavers.tech
 * License: GPLv2 or later
 * Text Domain: bytesweavers-ai-chat-master
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Early version checks.
if ( version_compare( PHP_VERSION, '7.4', '<' ) ) {
	die( 'This plugin requires PHP 7.4 or higher.' );
}
if ( version_compare( $GLOBALS['wp_version'], '5.0', '<' ) ) {
	die( 'This plugin requires WordPress 5.0 or higher.' );
}

define( 'AICW_VERSION', '1.0.0' );
define( 'AICW_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'AICW_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

// Autoloader for namespaced classes.
spl_autoload_register( function ( $class ) {
	$prefix   = 'AICW\\';
	$base_dir = AICW_PLUGIN_DIR . 'includes/';
	$len      = strlen( $prefix );
	if ( strncmp( $prefix, $class, $len ) !== 0 ) {
		return;
	}
	$relative_class = substr( $class, $len );
	$file = $base_dir . 'class-' . strtolower( str_replace( '\\', '-', $relative_class ) ) . '.php';
	if ( file_exists( $file ) ) {
		require $file;
	}
} );

// Activation hook.
function aicw_activate() {
	update_option( 'aicw_db_version', AICW_VERSION );
}
register_activation_hook( __FILE__, 'aicw_activate' );

// Deactivation hook.
function aicw_deactivate() {
	delete_option( 'aicw_db_version' );
}
register_deactivation_hook( __FILE__, 'aicw_deactivate' );

// Initialize the plugin.
function aicw_init() {
	// Load additional files.
	require_once AICW_PLUGIN_DIR . 'includes/class-admin-settings.php';
	require_once AICW_PLUGIN_DIR . 'includes/class-api-handler.php';
	require_once AICW_PLUGIN_DIR . 'includes/class-data-scraper.php';
	require_once AICW_PLUGIN_DIR . 'includes/class-chat-processor.php';
	require_once AICW_PLUGIN_DIR . 'includes/class-widget.php';

	new AICW\Admin_Settings();
	new AICW\Widget();
}
add_action( 'plugins_loaded', 'aicw_init' );