<?php
namespace BIEL;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

// Deactivate feedback form.

if ( ! is_admin() ) {
	return;
}

global $pagenow;

// Define your plugin or theme version.
define( 'BIEL_DEACTIVATE_PLUGIN_VERSION', '1.0.0' );

if ( 'plugins.php' !== $pagenow ) {
	return;
}

if ( defined( 'BIEL_DEACTIVATE_FEEDBACK_FORM_INCLUDED' ) ) {
	return;
}
define( 'BIEL_DEACTIVATE_FEEDBACK_FORM_INCLUDED', true );

add_action(
	'admin_enqueue_scripts',
	function () {
		// Enqueue scripts.
		wp_enqueue_script( 'biel-remodal', plugin_dir_url( __FILE__ ) . 'remodal.js', array( 'jquery' ), BIEL_DEACTIVATE_PLUGIN_VERSION, false );
		wp_enqueue_style( 'biel-remodal', plugin_dir_url( __FILE__ ) . 'remodal.css', array(), BIEL_DEACTIVATE_PLUGIN_VERSION, 'all' );
		wp_enqueue_style( 'biel-remodal-default-theme', plugin_dir_url( __FILE__ ) . 'remodal-default-theme.css', array(), BIEL_DEACTIVATE_PLUGIN_VERSION, 'all' );

		wp_enqueue_script( 'biel-codecabin-deactivate-feedback-form', plugin_dir_url( __FILE__ ) . 'deactivate-feedback-form.js', array( 'jquery' ), BIEL_DEACTIVATE_PLUGIN_VERSION, false );
		wp_enqueue_style( 'biel-codecabin-deactivate-feedback-form', plugin_dir_url( __FILE__ ) . 'deactivate-feedback-form.css', array(), BIEL_DEACTIVATE_PLUGIN_VERSION, 'all' );

		// Localized strings.
		wp_localize_script(
			'biel-codecabin-deactivate-feedback-form',
			'codecabin_deactivate_feedback_form_strings',
			array(
				'quick_feedback'        => __( 'Quick Feedback', 'bytes-import-export-lite' ),
				'foreword'              => __( 'If you would be kind enough, please tell us why you\'re deactivating?', 'bytes-import-export-lite' ),
				'better_plugins_name'   => __( 'Please tell us which plugin?', 'bytes-import-export-lite' ),
				'please_tell_us'        => __( 'Please tell us the reason so we can improve the plugin', 'bytes-import-export-lite' ),
				'do_not_attach_email'   => __( 'Do not send my e-mail address with this feedback', 'bytes-import-export-lite' ),

				'brief_description'     => __( 'Please give us any feedback that could help us improve', 'bytes-import-export-lite' ),

				'cancel'                => __( 'Cancel', 'bytes-import-export-lite' ),
				'skip_and_deactivate'   => __( 'Skip &amp; Deactivate', 'bytes-import-export-lite' ),
				'submit_and_deactivate' => __( 'Submit &amp; Deactivate', 'bytes-import-export-lite' ),
				'please_wait'           => __( 'Please wait', 'bytes-import-export-lite' ),
				'thank_you'             => __( 'Thank you!', 'bytes-import-export-lite' ),
				'deactivate_ajax_url'   => admin_url( 'admin-ajax.php' ),
				'nonce'                 => wp_create_nonce( 'biel_deactivate_feedback_nonce' ),
			)
		);

		// Plugins.
		$plugins = apply_filters( 'biel_codecabin_deactivate_feedback_form_plugins', array() );

		// Reasons.
		$default_reasons = array(
			'suddenly-stopped-working' => __( 'The plugin suddenly stopped working', 'bytes-import-export-lite' ),
			'plugin-broke-site'        => __( 'The plugin broke my site', 'bytes-import-export-lite' ),
			'no-longer-needed'         => __( 'I don\'t need this plugin any more', 'bytes-import-export-lite' ),
			'found-better-plugin'      => __( 'I found a better plugin', 'bytes-import-export-lite' ),
			'temporary-deactivation'   => __( 'It\'s a temporary deactivation, I\'m troubleshooting', 'bytes-import-export-lite' ),
			'other'                    => __( 'Other', 'bytes-import-export-lite' ),
		);

		foreach ( $plugins as $plugin ) {
			$plugin->reasons = apply_filters( 'biel_codecabin_deactivate_feedback_form_reasons', $default_reasons, $plugin );
		}

		// Send plugin data.
		wp_localize_script( 'biel-codecabin-deactivate-feedback-form', 'biel_codecabin_deactivate_feedback_form_plugins', $plugins );
	}
);

/**
 * Hook for adding plugins, pass an array of objects in the following format:
 *  'slug'      => 'plugin-slug'
 *  'version'   => 'plugin-version'
 *
 * @return array The plugins in the format described above
 */
add_filter(
	'biel_codecabin_deactivate_feedback_form_plugins',
	function ( $plugins ) {
		return $plugins;
	}
);
