<?php
/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Bytes_Import_Export_Lite
 * @subpackage Bytes_Import_Export_Lite/includes
 * @author     Bytes Technolab <info@bytestechnolab.com>
 */
if(!class_exists('BIEL_Bytes_Import_Export_Lite_I18n')){
	class BIEL_Bytes_Import_Export_Lite_I18n {
		/**
		 * Load the plugin text domain for translation.
		 *
		 * @since    1.0.0
		 */
		public function load_plugin_textdomain() {
			load_plugin_textdomain(
				'bytes-import-export-lite',
				false,
				dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
			);
		}
	}
}
