<?php
/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Bytes_Import_Export_Lite
 * @subpackage Bytes_Import_Export_Lite/includes
 * @author     Bytes Technolab <info@bytestechnolab.com>
 */
if(!class_exists('BIEL_Bytes_Import_Export_Lite_Activator')){
	class BIEL_Bytes_Import_Export_Lite_Activator {
		/**
		 * Short Description. (use period)
		 *
		 * Long Description.
		 *
		 * @since    1.0.0
		 */
		public static function activate() {
			// Set default export posts field settings.
			$export_posts_fields = array(
				'title'            => '1',
				'content'          => '1',
				'excerpt'          => '1',
				'featured_image'   => '1',
				'taxonomies'       => '1',
				'post_meta_fields' => '1',
				'date'             => '0',
			);
			// On plugin activation, check options and update if necessary.
			if ( empty( get_option( 'biel_bytes_posts_import_export_option' ) ) || get_option( 'biel_bytes_posts_import_export_option' ) !== '1' ) {
				update_option( 'biel_bytes_import_export_posts_fields', $export_posts_fields );
				update_option( 'biel_bytes_import_export_posts_status', 'publish' );
				update_option( 'biel_bytes_posts_import_export_option', '1' );
			}
		}
	}
}
