<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.bytestechnolab.com
 * @since             1.0.0
 * @package           Bytes_Import_Export_Lite
 *
 * @wordpress-plugin
 * Plugin Name:       Bytes Import/Export Lite
 * Plugin URI:        https://www.bytestechnolab.com
 * Description:       The most powerful plugin for exporting default posts, pages, and custom post types with all metadata to a JSON file, setting the exported data, and then re-importing it to another WordPress website.
 * Version:           1.0.0
 * Author:            Bytes Technolab
 * Author URI:        https://www.bytestechnolab.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       bytes-import-export-lite
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'BIEL_BYTES_IMPORT_EXPORT_LITE_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-bytes-import-export-lite-activator.php
 */
function biel_activate_bytes_import_export_lite() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-bytes-import-export-lite-activator.php';
	BIEL_Bytes_Import_Export_Lite_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-bytes-import-export-lite-deactivator.php
 */
function biel_deactivate_bytes_import_export_lite() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-bytes-import-export-lite-deactivator.php';
	BIEL_Bytes_Import_Export_Lite_Deactivator::deactivate();
}

/**
 * Register activation and deactivation hooks
 */
register_activation_hook( __FILE__, 'biel_activate_bytes_import_export_lite' );
register_deactivation_hook( __FILE__, 'biel_deactivate_bytes_import_export_lite' );

/**
 * Define plugin constants
 */
define( 'BIEL_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
define( 'BIEL_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
define( 'BIEL_BASENAME', plugin_basename( __FILE__ ) );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-bytes-import-export-lite.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function biel_run_bytes_import_export_lite() {
	$plugin = new BIEL_Bytes_Import_Export_Lite();
	$plugin->run();
}
biel_run_bytes_import_export_lite();
