<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

// Retrieve the selected status value from options.
$biel_bytes_import_export_posts_status = get_option( 'biel_bytes_import_export_posts_status' );

// Output a dropdown select element for post statuses.
?>
<select name="biel_bytes_import_export_posts_status" id="post-status">
	<option value="0"><?php esc_html_e( 'All', 'bytes-import-export-lite' ); ?></option>
	<?php
	// Get all post statuses.
	$post_stati = get_post_stati( array( 'internal' => false ), 'objects' );
	foreach ( $post_stati as $status_val ) :
		// Check if the current status is selected.
		$selected = ( esc_attr( $status_val->name ) === $biel_bytes_import_export_posts_status ) ? 'selected' : '';
		?>
		<option value="<?php echo esc_attr( $status_val->name ); ?>" <?php echo esc_attr( $selected ); ?>><?php echo esc_html( $status_val->label ); ?></option>
	<?php endforeach; ?>
</select>
