<?php
	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

	// Load the saved options for selected post fields.
	$biel_bytes_import_export_posts_fields = get_option( 'biel_bytes_import_export_posts_fields' );
	// Define the list of exportable post fields.
	$posts_fields = array(
		'title',
		'content',
		'excerpt',
		'featured_image',
		'taxonomies',
		'post_meta_fields',
		'date',
	); ?>
	<div class="bytes_import_export_selected_posts_fields">
		<?php
			// Loop through all fields.
		foreach ( $posts_fields as $field ) :
			?>
				<div class="selected_posts_fields">
					<label for="<?php echo esc_attr( "biel_bytes_import_export_posts_fields[$field]" ); ?>">
						<input name="<?php echo esc_attr( "biel_bytes_import_export_posts_fields[$field]" ); ?>" id="<?php echo esc_attr( "biel_bytes_import_export_posts_fields[$field]" ); ?>" type="checkbox" value="1" <?php isset( $biel_bytes_import_export_posts_fields[ $field ] ) ? checked( '1', $biel_bytes_import_export_posts_fields[ $field ] ) : ''; ?> /><?php echo esc_html( ucfirst( $field ) ); ?>
					</label>
				</div>
		<?php endforeach; ?>
	</div>
	