<?php
	/**
	 * Import post data
	 *
	 * @package    Bytes_Import_Export_Lite
	 */

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

?>
<div class="wrap custom-user-wrap bytes-import-export-lite-import">
	<hr class="wp-header-end">
	<h1 class="wp-heading-inline"><?php esc_html_e( 'Import Post', 'bytes-import-export-lite' ); ?></h1>
	<?php
	// Check if form has been submitted and referer check has passed.
	if ( isset( $_POST['upload_submit'] ) && check_admin_referer( 'import-upload-data' ) && isset( $_GET['step'] ) && ( '1' === $_GET['step'] ) && current_user_can( 'manage_options' ) ) {
		$file_name      = isset( $_FILES['import']['name'] ) ? sanitize_file_name( $_FILES['import']['name'] ) : '';
		$file_extension = pathinfo( $file_name, PATHINFO_EXTENSION );

		if ( 'json' !== $file_extension ) {
			echo esc_html__( 'Error: Please upload a .json file.', 'bytes-import-export-lite' );
			return false;
		}

		$overrides = array(
			'test_form' => false,
			'test_type' => false,
		);

		$upload = wp_handle_upload( $_FILES['import'], $overrides );

		if ( isset( $upload['error'] ) ) {
			echo esc_html( $upload['error'] ) . '</p>';
			return false;
		}

		// Construct the attachment array.
		$attachment = array(
			'post_title'     => wp_basename( $upload['file'] ),
			'post_content'   => $upload['url'],
			'post_mime_type' => $upload['type'],
			'guid'           => $upload['url'],
			'context'        => 'import',
			'post_status'    => 'private',
		);

		// Save the data.
		$custom_id = wp_insert_attachment( $attachment, $upload['file'] );

		/*
		 * Schedule a cleanup for one hour from now in case of failed
		 * import or missing wp_import_cleanup() call.
		 */
		$hour_in_seond = 3600;
		wp_schedule_single_event( time() + $hour_in_seond, 'importer_scheduled_cleanup', array( $custom_id ) );

		$file = array(
			'file' => $upload['file'],
			'id'   => $custom_id,
		);

		if ( isset( $file['error'] ) ) {
			echo '<p><strong>' . esc_html__( 'Sorry, there has been an error.', 'bytes-import-export-lite' ) . '</strong><br />';
			echo esc_html( $file['error'] ) . '</p>';
			return false;
		} elseif ( ! file_exists( $file['file'] ) ) {
			echo '<p><strong>' . esc_html__( 'Sorry, there has been an error.', 'bytes-import-export-lite' ) . '</strong><br />';
			// translators: %s is the file path where the export file could not be found.
			printf( esc_html__( 'The export file could not be found at <code>%s</code>. It is likely that this was caused by a permissions problem.', 'bytes-import-export-lite' ), esc_html( $file['file'] ) );
			echo '</p>';
			return false;
		}

		$custom_id    = (int) $file['id'];
		$import_data  = $file['file'];
	    $import_data = file_get_contents($import_data); // phpcs:ignore
		$custom_posts = json_decode( $import_data, true );

		$authors = isset( $custom_posts[0]['author_data'] ) ? $custom_posts[0]['author_data'] : array(); // Retrieve author details.

		// Serialize the array to store it in a hidden field.
		$serialized_author_data = wp_json_encode( $authors );

		$n = 1;
		// phpcs:disable Generic.WhiteSpace.ScopeIndent.Incorrect
		?>
		<div id="import-result" style="display: none;">
			<div id="import-message"></div>
			<h3><?php esc_html_e( 'Import Result', 'bytes-import-export-lite' ); ?></h3>
			<pre id="import-data"></pre>  
		</div>
		<form method="post" id="import-posts-form" onkeydown="return event.key != 'Enter';">
			<input type="hidden" name="import_id" value="<?php echo esc_attr( $custom_id ); ?>" />
			<input type="hidden" name="import_author" value="<?php echo esc_attr( htmlentities( $serialized_author_data ) ); ?>" />

			<?php if ( ! empty( $authors ) ) : ?>
				<h3><?php esc_html_e( 'Select Authors', 'bytes-import-export-lite' ); ?></h3>
				<ol id="authors">
					<?php
					foreach ( $authors as $author ) :
						?>
						<li>
							<?php esc_html_e( 'Import author:', 'bytes-import-export-lite' ); ?>
							<strong><?php echo esc_html( $author['author_display_name'] ) . ' (' . esc_html( $author['author_login'] ) . ')'; ?></strong><br />
							<div style="margin-left:18px">
								<?php esc_html_e( 'or assign posts to an existing user:', 'bytes-import-export-lite' ); ?>
								<?php
								echo wp_dropdown_users(
									array(
										'name'            => "user_map[$n]",
										'id'              => 'imported_authors_' . $n,
										'multi'           => true,
										'show_option_all' => __( '- Select -', 'bytes-import-export-lite' ),
										'show'            => 'display_name_with_login',
										'echo'            => 0,
									)
								);
								?>
								<input type="hidden" name="imported_authors[<?php echo esc_attr( $n ); ?>]" value="<?php echo esc_attr( $author['author_login'] ); ?>" />
							</div>
						</li>
					<?php
					++$n;
					endforeach;
					?>
				</ol>
			<?php else : ?>
				<h3><?php esc_html_e( 'Author details are not available.', 'bytes-import-export-lite' ); ?></h3>
			<?php endif; ?>
			<p class="submit"><input type="submit" name="file_submit" class="button button-primary" value="<?php esc_attr_e( 'Submit', 'bytes-import-export-lite' ); ?>" /></p>
		</form>
		<?php
	} elseif ( ! isset( $_GET['step'] ) ) {
		?>
		<div class="entry-edit my-3 shadow-sm rounded">
			<div class="wrap">
				<form enctype="multipart/form-data" id="import-upload-form" method="post" class="wp-upload-form" action="<?php echo esc_url( wp_nonce_url( admin_url( 'admin.php?page=bytes-import-export-lite-import_posts_page&step=1' ), 'import-upload-data' ) ); ?>">
					<p>
						<label for="file"><?php esc_html_e( 'Select file to import:', 'bytes-import-export-lite' ); ?></label>
						<input type="file" id="file" name="import" accept=".json" required />
					</p>
					<p class="submit"><input type="submit" name="upload_submit" class="button button-primary" value="<?php esc_attr_e( 'Import', 'bytes-import-export-lite' ); ?>" /></p>
				</form>
			</div>
		</div>
	<?php
	} else {
		// Default title and response code.
		$custom_title  = esc_html__( 'Something went wrong.', 'bytes-import-export-lite' );
		$response_code = 403;
		$html          = esc_html__( 'The link you followed has expired.', 'bytes-import-export-lite' );
		$custom_page   = isset( $_GET['page'] ) ? sanitize_key( wp_unslash( $_GET['page'] ) ) : '';
		$current_page  = admin_url( 'admin.php?page=' . esc_attr( $custom_page ) );
		$html         .= '</p><p>';
		$html         .= sprintf(
			'<a href="%s">%s</a>',
			esc_url( $current_page ),
			esc_html__( 'Please try again.', 'bytes-import-export-lite' )
		);
		wp_die( wp_kses_post( $html ), esc_html( $custom_title ), esc_html( $response_code ) );
	}
	?>
</div>
