<?php
	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

	// Get a list of post types.
	$custom_types = get_post_types( array( '_builtin' => true ), 'objects' ) + get_post_types(
		array(
			'_builtin' => false,
			'show_ui'  => true,
		),
		'objects'
	) + get_post_types(
		array(
			'_builtin' => false,
			'show_ui'  => false,
		),
		'objects'
	);

	foreach ( $custom_types as $key => $ct ) {
		if ( in_array( $key, array( 'attachment', 'revision', 'nav_menu_item', 'import_users', 'shop_webhook', 'acf-field', 'acf-field-group', 'wp_block', 'customize_changeset', 'custom_css', 'scheduled_action', 'scheduled-action', 'user_request', 'oembed_cache', 'wp_navigation', 'wp_template', 'wp_template_part', 'wp_global_styles', 'shop_order_placehold', 'product_variation', 'shop_order', 'shop_order_refund', 'patterns_ai_data' ), true ) ) {
			unset( $custom_types[ $key ] );
		}
	} ?>
	<div class="wrap custom-user-wrap bytes-import-export-lite-export">
		<hr class="wp-header-end">
		<h1 class="wp-heading-inline"><?php esc_html_e( 'Export Post', 'bytes-import-export-lite' ); ?></h1>
		<div class="entry-edit my-3 shadow-sm rounded">
			<div class="wrap">
				<div id="export-message"></div>
				<div class="row">
					<label class="col-md-auto pe-1"><span class="label-responsive"><?php esc_html_e( 'Post Type:', 'bytes-import-export-lite' ); ?></span></label>
					<select id="post-type-select" class="col-md-6 form-select form-select-lg mb-3">
						<option value=""><?php esc_html_e( 'Select Post Type', 'bytes-import-export-lite' ); ?></option>
						<?php foreach ( $custom_types as $key => $ct ) : ?>
							<option value="<?php echo esc_attr( $key ); ?>" <?php echo ( esc_attr( $key ) === 'post' ) ? 'selected' : ''; ?>><?php echo esc_html( $ct->label ); ?></option>
						<?php endforeach; ?>
					</select>
				</div>
				<div id="author-filter"></div>
				<div id="date-filter" class="mt-3"></div>
				<button id="export-posts-button" class="button button-primary mt-3"><?php esc_html_e( 'Export', 'bytes-import-export-lite' ); ?></button>
			</div>          
		</div>
	</div>
