// Initialize JS for export form.
jQuery( document ).ready(
	function ($) {
		// Export JSON file code on click of export button.
		$( '#export-posts-button' ).on(
			'click',
			function () {
				// Disable the button.
				let exporButton = $( this );
				exporButton.prop( 'disabled', true );
				var postType  = $( '#post-type-select' ).val();
				var startDate = $( '#post-start-date' ).val();
				var endDate   = $( '#post-end-date' ).val();
				var author    = $( '#author-filter select' ).val();
				if (postType) {
					// Show "Downloading..." message.
					$( '#export-message' ).html( `<div class="alert alert-info alert-dismissible fade show" role="alert">Downloading...<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>` );
					$.ajax(
						{
							url: biel_object.ajax_url, // WordPress AJAX URL.
							type: 'POST',
							data: {
								action: 'biel_export_posts',
								post_type: postType,
								start_date: startDate,
								end_date: endDate,
								author: author,
								security: biel_object.nonce // Add nonce to the data.
							},
							success: function (response) {
								// Check if the response is valid JSON.
								try {
									if (response.success == true) {
										// Create a Blob containing the JSON data.
										var blob = new Blob( [response.data], { type: 'application/json' } );
										// Create a download link for the Blob.
										var link  = document.createElement( 'a' );
										link.href = window.URL.createObjectURL( blob );

										const now      = new Date();
										const year     = now.getFullYear();
										const month    = String( now.getMonth() + 1 ).padStart( 2, '0' ); // Add leading zero for single-digit months.
										const day      = String( now.getDate() ).padStart( 2, '0' );
										const hour     = String( now.getHours() ).padStart( 2, '0' );
										const minute   = String( now.getMinutes() ).padStart( 2, '0' );
										const second   = String( now.getSeconds() ).padStart( 2, '0' );
										const filename = `exported_posts_${year} - ${month} - ${day} - ${hour} - ${minute} - ${second}.json`;

										link.download = filename; // Set the filename.
										// Trigger a click event on the download link to start the download.
										link.click();
										// Clean up by revoking the object URL.
										window.URL.revokeObjectURL( link.href );

										// Show "Successful" message.
										$( '#export-message' ).html( `<div class = "alert alert-success alert-dismissible fade show" role="alert">Export successful<button type= "button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>` );
									}
								} catch (error) {
									alert( "Error parsing JSON response: " + error );
									// Remove message.
									$( '#export-message' ).html( '' );
								}
								if (response.success == false) {
									alert( response.data );
									// Remove message.
									$( '#export-message' ).html( '' );
								}
								// Enable the button.
								exporButton.prop( 'disabled', false );
							},
							error: function (xhr, status, error) {
								// Display error message or handle error.
								alert( "Error exporting posts: " + error );
								// Remove message.
								$( '#export-message' ).html( '' );
								// Enable the button.
								exporButton.prop( 'disabled', false );
							}
						}
					);
				} else {
					alert( 'Please select a post type.' );
					// Enable the button.
					exporButton.prop( 'disabled', false );
				}
			}
		);
		// Fetch date and author data on change of post.
		export_custom_post( "post" );
		function export_custom_post(postType){
			if (postType && postType !== "") {
				$.ajax(
					{
						url: biel_object.ajax_url, // WordPress AJAX URL.
						type: 'POST',
						dataType: 'html',
						data: {
							action: 'get_author_filter',
							post_type: postType,
							biel_nonce: biel_object.biel_nonce // Send nonce
						},
						success: function (html) {
							$( '#author-filter' ).html( html );
						}
					}
				);
				$.ajax(
					{
						url: biel_object.ajax_url, // WordPress AJAX URL.
						type: 'POST',
						dataType: 'html',
						data: {
							action: 'get_date_filter',
							post_type: postType,
							biel_nonce: biel_object.biel_nonce // Send nonce
						},
						success: function (html) {
							$( '#date-filter' ).html( html );
						}
					}
				);
			} else {
				$( '#date-filter' ).html( '' );
				$( '#author-filter' ).html( '' );
			}
		}

		$( '#post-type-select' ).on(
			'change',
			function () {
				var postType = $( this ).val();
				export_custom_post( postType );
			}
		);

		// Import post data.
		$( '#import-posts-form' ).on(
			'submit',
			function (e) {
				e.preventDefault();

				// Show import result container.
				$( '#import-result' ).show();

				// Hide the form.
				$( this ).hide();

				let count     = 1; // Define count variable.
				let batchSize = 10; // Define batch size.
				let postCount = 0; // Define count of the post in each batch iterarion.
				let totalPosts;

				function import_custom_post(){
					let formdata = new FormData( $( '#import-posts-form' )[0] ); // Get form data.
					formdata.append( "action", "biel_import_posts" ); // Add action.
					formdata.append( "batch_size", batchSize ); // Add batch size.
					formdata.append( "security", biel_object.security ); // Add security.
					formdata.append( "count", count ); // Add count.

					// Show import result container and loader message.
					$( '#import-message' ).show().html( '<p>Importing posts... <span class="loader"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div></span></p>' );
					$.ajax(
						{
							method: "POST",
							dataType: "json",
							url: biel_object.ajax_url, // WordPress AJAX URL.
							data: formdata,
							processData: false,
							contentType: false,
							success: function (response) {
								if (response.success) {
									$( '#import-message' ).hide();

									// Update the import message container with messages from the response.
									let messages      = response.data.messages;
									let messageLength = messages.length; // Store length outside the loop.
									for (let i = 0; i < messageLength; i++) {
										$( '#import-data' ).append( '<p>' + messages[i] + '</p>' );
									}

									// Update total posts if received in response.
									if (response.data.totalPosts) {
										totalPosts = response.data.totalPosts;
									}

									// Loop through and get total post.
									postCount += batchSize;
									count++;
									if (postCount < totalPosts) {
										import_custom_post();
									}
								} else {
									$( '#import-message' ).hide();
									$( '#import-data' ).text( response.data.message ); // Format response data as JSON.
								}
							},
							error: function (xhr, status, error) {
								// Handle errors.
								$( '#import-message' ).hide();
								$( '#import-data' ).text( 'Error during import: ' + error );
							}
						}
					);
				}
				import_custom_post();
			}
		);
	}
);
