<?php
// deactivate feedback form ajax action.
if ( ! function_exists( 'biel_deactivate_plugin' ) ) {
	// Iniitialize function - biel_deactivate_plugin.
	function biel_deactivate_plugin() {
		if ( ! empty( $_POST['action'] ) && 'biel_deactivate_feedback_form' === $_POST['action'] ) {
			// Verify nonce.
			if ( isset( $_POST['nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['nonce'] ) ), 'biel_deactivate_feedback_nonce' ) && current_user_can( 'manage_options' ) ) {
				$current_user       = wp_get_current_user();
				$current_user_email = sanitize_email( $current_user->user_email ); // get current user email.
				$current_site_url   = get_site_url(); // get current site's url.
				$site_title         = get_bloginfo( 'name' ); // get site's title.
				$to                 = sanitize_email( 'sohil.vahora@bytestechnolab.com' ); // developer email.
				$subject            = "[{$site_title}]: Deactivate Plugin";
				$plugin_header      = 'Bytes Import/Export Lite'; // plugin name.
				$message            = 'Your plugin is deactivated by: <a href="mailto:' . $current_user_email . '">' . $current_user_email . '</a>:';
				$reason             = ( ! empty( $_POST['reason'] ) ) ? sanitize_text_field( wp_unslash( $_POST['reason'] ) ) : '-';
				$comments           = ( ! empty( $_POST['comments'] ) ) ? sanitize_text_field( wp_unslash( $_POST['comments'] ) ) : '-';
				$headers            = array( 'Content-Type: text/html; charset=UTF-8' );
				require_once BIEL_PLUGIN_DIR_PATH . 'lib/plugin-deactivation/email/admin-deactivate-plugin.php'; // email template.
				wp_mail( $to, $subject, $body, $headers );

				echo wp_json_encode(
					array(
						'status'  => true,
						'message' => 'Email has been sent successfully',
					)
				);
			} else {
				// Nonce verification failed.
				wp_die( esc_html__( 'Nonce verification failed.', 'bytes-import-export-lite' ), esc_html__( 'Error', 'bytes-import-export-lite' ), array( 'response' => 403 ) );
			}
		}
		exit;
	}
}
add_action( 'wp_ajax_biel_deactivate_feedback_form', 'biel_deactivate_plugin' );
add_action( 'wp_ajax_nopriv_biel_deactivate_feedback_form', 'biel_deactivate_plugin' );
