<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://www.bytestechnolab.com
 * @since      1.0.0
 *
 * @package    Bytes_Import_Export_Lite
 * @subpackage Bytes_Import_Export_Lite/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Bytes_Import_Export_Lite
 * @subpackage Bytes_Import_Export_Lite/admin
 * @author     Bytes Technolab <info@bytestechnolab.com>
 */
if(!class_exists('BIEL_Bytes_Import_Export_Lite_Admin')){
	class BIEL_Bytes_Import_Export_Lite_Admin {

		/**
		 * The ID of this plugin.
		 *
		 * @since    1.0.0
		 * @access   private
		 * @var      string    $plugin_name    The ID of this plugin.
		 */
		private $plugin_name;

		/**
		 * The version of this plugin.
		 *
		 * @since    1.0.0
		 * @access   private
		 * @var      string    $version    The current version of this plugin.
		 */
		private $version;

		/**
		 * Initialize the class and set its properties.
		 *
		 * @since    1.0.0
		 * @param      string $plugin_name       The name of this plugin.
		 * @param      string $version    The version of this plugin.
		 */
		public function __construct( $plugin_name, $version ) {

			$this->plugin_name = $plugin_name;
			$this->version     = $version;
		}

		/**
		 * Register the stylesheets for the admin area.
		 *
		 * @since    1.0.0
		 */
		public function enqueue_styles() {
			/**
			 * This function is provided for demonstration purposes only.
			 *
			 * An instance of this class should be passed to the run() function
			 * defined in Bytes_Import_Export_Lite_Loader as all of the hooks are defined
			 * in that particular class.
			 *
			 * The Bytes_Import_Export_Lite_Loader will then create the relationship
			 * between the defined hooks and the functions defined in this
			 * class.
			 */

			wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/bytes-import-export-lite-admin.css', array(), $this->version, 'all' );
			wp_enqueue_style( $this->plugin_name . '_bootstrap.min.css', plugin_dir_url( __FILE__ ) . 'css/bootstrap.min.css', array(), $this->version, 'all' ); // load bootstrap css.
		}

		/**
		 * Register the JavaScript for the admin area.
		 *
		 * @since    1.0.0
		 */
		public function enqueue_scripts() {
			/**
			 * This function is provided for demonstration purposes only.
			 *
			 * An instance of this class should be passed to the run() function
			 * defined in Bytes_Import_Export_Lite_Loader as all of the hooks are defined
			 * in that particular class.
			 *
			 * The Bytes_Import_Export_Lite_Loader will then create the relationship
			 * between the defined hooks and the functions defined in this
			 * class.
			 */
			$current_bytes_page = isset( $_GET['page'] ) ? sanitize_text_field( wp_unslash( $_GET['page'] ) ) : false; // phpcs:ignore
			if ( 'bytes-import-export-lite-info_page' === $current_bytes_page || 'bytes-import-export-lite-settings_page' === $current_bytes_page || 'bytes-import-export-lite-export_posts_page' === $current_bytes_page || 'bytes-import-export-lite-import_posts_page' === $current_bytes_page ) {
				wp_enqueue_script( $this->plugin_name . '_bootstrap.min.js', plugin_dir_url( __FILE__ ) . 'js/bootstrap.min.js', array( 'jquery' ), $this->version, true ); // load bootstrap JS.
				wp_enqueue_script( 'bytes-import-export-lite-admin.js', plugin_dir_url( __FILE__ ) . 'js/bytes-import-export-lite-admin.js', array( 'jquery' ), $this->version, false );
				wp_localize_script(
					'bytes-import-export-lite-admin.js',
					'biel_object',
					array(
						'ajax_url' => admin_url( 'admin-ajax.php' ),
						'nonce'    => wp_create_nonce( 'biel_export_posts_nonce' ),
						'security' => wp_create_nonce( 'biel_import_posts_nonce' ),
						'biel_nonce' => wp_create_nonce('biel_nonce_action'),
					)
				);
			}
		}

		/**
		 * Load deactivate form
		 *
		 * @since    1.0.0
		 * @param array $plugins An array of plugin objects.
		 * @return array Updated array of plugin objects with the new plugin added.
		 */
		public function biel_load_deactivate_form( $plugins ) {
			$plugins[] = (object) array(
				'slug'    => 'bytes-import-export-lite',
				'version' => '1.0.0',
			);
			return $plugins;
		}

		/**
		 * Load plugin setting link
		 *
		 * @since    1.0.0
		 * @param array $setting_links An array of setting links.
		 * @return array Updated array of setting links with the new link added.
		 */
		public function biel_settings_link( $setting_links ) {
			$setting_links[] = '<a href="' .
				esc_url( admin_url( 'admin.php?page=bytes-import-export-lite-info_page' ) ) .
				'">' . __( 'Settings', 'bytes-import-export-lite' ) . '</a>';
			return $setting_links;
		}

		/**
		 * Load admin menu page
		 *
		 * @since    1.0.0
		 */
		public function biel_custom_menu_page() {
			add_menu_page(
				'BT Lite',
				'BT Lite',
				'manage_options',
				'bytes-import-export-lite-info_page',
				array( $this, 'biel_info_bytes_posts_import_export' ),
				'dashicons-database-view',
				80
			);
			add_submenu_page( 'bytes-import-export-lite-info_page', 'Export', 'Export', 'manage_options', 'bytes-import-export-lite-export_posts_page', array( $this, 'biel_export_bytes_posts_import_export' ), null );
			add_submenu_page( 'bytes-import-export-lite-info_page', 'Import', 'Import', 'manage_options', 'bytes-import-export-lite-import_posts_page', array( $this, 'biel_import_bytes_posts_import_exports' ), null );
			add_submenu_page( 'bytes-import-export-lite-info_page', 'Settings', 'Settings', 'manage_options', 'bytes-import-export-lite-settings_page', array( $this, 'biel_settings_bytes_posts_import_export' ), null );
			add_submenu_page( 'bytes-import-export-lite-info_page', 'About Plugin', 'About Plugin', 'manage_options', 'bytes-import-export-lite-info_page' );
		}

		/*
		 * Information tab
		 */
		public function biel_info_bytes_posts_import_export() {
			require_once plugin_dir_path( __DIR__ ) . 'admin/partials/bytes-import-export-lite-admin-info.php';
		}

		/*
		 * Settings tab for export posts
		 */
		public function biel_settings_bytes_posts_import_export() {
			require_once plugin_dir_path( __DIR__ ) . 'admin/partials/bytes-import-export-lite-admin-settings.php';
		}

		/*
		 * Export posts tab
		 */
		public function biel_export_bytes_posts_import_export() {
			require_once plugin_dir_path( __DIR__ ) . 'admin/partials/bytes-import-export-lite-admin-export.php';
		}

		/*
		 * Import posts tab
		 */
		public function biel_import_bytes_posts_import_exports() {
			require_once plugin_dir_path( __DIR__ ) . 'admin/partials/bytes-import-export-lite-admin-import.php';
		}

		/*
		 * Display options in settings tab
		 */
		public function biel_export_posts_display_options() {
			// Section name, display name, callback to print description of section, page to which section is attached.
			add_settings_section( 'biel_header_section', 'Setting Fields Options', array( $this, 'biel_display_header_options_content' ), 'biel-plugin-options' );

			/*
			 * Setting name, display name, callback to print form element, page in which field is displayed, section to which it belongs.
			 * last field section is optional.
			*/
			add_settings_field( 'biel_bytes_import_export_posts_fields', 'Export Fields', array( $this, 'biel_display_post_export_fields' ), 'biel-plugin-options', 'biel_header_section' );
			add_settings_field( 'biel_bytes_import_export_posts_status', 'Post Status', array( $this, 'biel_display_post_status_values' ), 'biel-plugin-options', 'biel_header_section' );
			// Section name, form element name, callback for sanitization.
			register_setting( 'biel_header_section', 'biel_bytes_import_export_posts_fields', array(
			    'type' => 'array',
			    'show_in_rest' => false,
			    'sanitize_callback' => array( $this, 'biel_sanitize_export_posts_fields' ),
			) );
			register_setting( 'biel_header_section', 'biel_bytes_import_export_posts_status', array(
			    'type' => 'string',
			    'show_in_rest' => false,
			    'sanitize_callback' => array( $this, 'biel_sanitize_posts_status' ),
			) );
		}

		/*
		 * Sanitization function for export post fields
		 */
		public function biel_sanitize_export_posts_fields( $input ) {
		    if ( is_array($input) ) {
	            foreach ($input as &$value) {
	                $value = sanitize_text_field($value);
	            }
	        } else {
	            $input = sanitize_text_field($input);
	        }
	        return $input;
		}

		/*
		 * Sanitization function for post status
		 */
		public function biel_sanitize_posts_status( $input ) {
		    if ( ! empty( $input ) ) {
		    	$input = sanitize_text_field($input);
		    }
		    return $input;
		}

		/*
		 * Settings tab - Header title
		 */
		public function biel_display_header_options_content() {
			echo esc_html('Select fields below which you want to export');
		}

		/*
		 * Settings tab - Post fields
		 */
		public function biel_display_post_export_fields() {
			require_once plugin_dir_path( __DIR__ ) . 'admin/partials/setting/bytes-import-export-lite-admin-post-fields.php';
		}

		/*
		 * Settings tab - Post status
		 */
		public function biel_display_post_status_values() {
			require_once plugin_dir_path( __DIR__ ) . 'admin/partials/setting/bytes-import-export-lite-admin-post-status.php';
		}

		/*
		 * Admin ajax call
		 */
		public function biel_export_posts_admin_ajax() {
			require_once plugin_dir_path( __DIR__ ) . 'admin/inc/ajax.php';
		}
	}
}
