<?php
/**
 * Plugin Name: by.Video
 * Plugin URI: https://by.video/wordpress
 * Description: Embed by.Video secure video meeting rooms using shortcode.
 * Version: 1.0
 * Author: by.Video
 * Author URI: https://by.video/
 * License: GPLv2 or later
 */

// Security check
if (!defined("ABSPATH"))
	exit;

function spe_by_video_shortcode($atts)
{
	$atts = shortcode_atts(["roomid" => "mars"], $atts, "by_video");

	if (!ctype_alnum($atts["roomid"]))
		return '<p style="color: red">⚠️ The roomid must be alphanumeric.</p>';

	return "<script src=\"" . esc_url("https://by.video/embed?rid={$atts['roomid']}") . "\"></script>";
}

add_shortcode("by_video", "spe_by_video_shortcode");

// example: [by_video roomid="jupiter"]
