<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Main Class
 */
class WCBNPCL_Init {

    private static $instance = null;

    public static function instance() {
        if ( self::$instance === null ) {
            self::$instance = new self();
            self::$instance->init_hooks();
        }
        return self::$instance;
    }

    /**
     * Register Hooks
     */
    public function init_hooks() {
        // Declare compatibility with WooCommerce HPOS
        add_action( 'before_woocommerce_init', [ $this, 'declare_hpos_compatibility' ] );
        // Add classes
        $this->load_classes();
    }
    
    public function declare_hpos_compatibility() {
    if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility(
            'custom_order_tables',
            WCBNPCL_PLUGIN_FILE,
            true
        );
    }
    }
    
    private function load_classes() {
        require_once WCBNPCL_PATH . 'includes/class-settings.php';      // Admin settings
        require_once WCBNPCL_PATH . 'includes/class-frontend.php';      // Buton + modal
        require_once WCBNPCL_PATH . 'includes/class-ajax-handler.php';  // AJAX
    }
}
