document.addEventListener('DOMContentLoaded', function () {
    const tableBody = document.getElementById('wcbnpc-fields-table-body');
    const addButton = document.getElementById('wcbnpc-add-field');
    const fieldOrderInput = document.getElementById('wcbnpc_field_order');

    // === Add custom field row ===
    if (tableBody && addButton) {
        addButton.addEventListener('click', function () {
            const key = 'custom_field_' + Date.now();
            const row = document.createElement('tr');
            row.setAttribute('data-key', key);
            row.setAttribute('data-custom', '1');
            row.style.cursor = 'move';

            row.innerHTML = `
                <td><input type="text" name="wcbnpc_checkout_fields[${key}][key]" value="${key}" /></td>
                <td class="wcbnpc-td-big"><input type="text" name="wcbnpc_checkout_fields[${key}][label]" value="" /></td>
                <td><input type="checkbox" name="wcbnpc_checkout_fields[${key}][required]" value="1" /></td>
                <td><input type="checkbox" name="wcbnpc_checkout_fields[${key}][visible]" value="1" checked /></td>
                <td><input type="checkbox" name="wcbnpc_checkout_fields[${key}][email_display]" value="1" /></td>
                <td><button type="button" class="button wcbnpc-delete-row">Delete</button></td>
            `;
            tableBody.appendChild(row);
            updateFieldOrder();
        });

        // === Delete row ===
        tableBody.addEventListener('click', function (e) {
            if (e.target.classList.contains('wcbnpc-delete-row')) {
                const row = e.target.closest('tr');
                if (row) {
                    row.remove();
                    updateFieldOrder();
                }
            }
        });
    }

    // === Initialize sortable ===
    if (typeof jQuery !== 'undefined' && typeof jQuery.fn.sortable !== 'undefined') {
        jQuery(function ($) {
            $('#wcbnpc-fields-table-body').sortable({
                items: 'tr',
                placeholder: 'wcbnpc-placeholder',
                update: function () {
                    updateFieldOrder();
                },
                start: function (e, ui) {
                    ui.item.css('background', '#fffdd0');
                },
                stop: function (e, ui) {
                    ui.item.css('background', '');
                }
            });

            // Set cursor on table rows
            $('#wcbnpc-fields-table-body tr').css('cursor', 'move');
        });
    }

    // === Update field order hidden input ===
    function updateFieldOrder() {
        const order = [];
        document.querySelectorAll('#wcbnpc-fields-table-body tr').forEach(row => {
            const key = row.getAttribute('data-key');
            if (key) order.push(key);
        });
        if (fieldOrderInput) {
            fieldOrderInput.value = order.join(',');
        }
    }

    // === Tab switching ===
    document.querySelectorAll('.wcbnpc-tab').forEach(tab => {
        tab.addEventListener('click', function (e) {
            e.preventDefault();

            document.querySelectorAll('.wcbnpc-tab').forEach(t => t.classList.remove('active'));
            this.classList.add('active');

            const selectedTab = this.getAttribute('data-tab');
            document.querySelectorAll('.wcbnpc-tab-content').forEach(content => {
                content.style.display = content.getAttribute('data-tab') === selectedTab ? 'block' : 'none';
            });
        });
    });

    // === Init WordPress color picker ===
    if (typeof jQuery !== 'undefined' && typeof jQuery.fn.wpColorPicker !== 'undefined') {
        jQuery(function ($) {
            $('.wcbnpc-color-picker').wpColorPicker();
        });
    }

    // === Toggle badge settings based on checkbox ===
    const toggleBadgeOptions = () => {
        const isChecked = document.getElementById('wcbnpc_show_badge')?.checked;
        ['wcbnpc_badge_type', 'wcbnpc_badge_text', 'wcbnpc_badge_color'].forEach(id => {
            const row = document.getElementById(id)?.closest('tr');
            if (row) {
                row.style.display = isChecked ? 'table-row' : 'none';
            }
        });
    };

    const saleBadgeCheckbox = document.getElementById('wcbnpc_show_badge');
    if (saleBadgeCheckbox) {
        saleBadgeCheckbox.addEventListener('change', toggleBadgeOptions);
        toggleBadgeOptions();
    }
});
jQuery(document).ready(function($) {
    // Handle dismissible remote notices
    $(document).on('click', '.wcbnpc-remote-notice .notice-dismiss', function () {
        const noticeId = $(this).closest('.wcbnpc-remote-notice').data('notice-id');
        const nonce = wcbnpc_admin_data.nonce; // passed from PHP via wp_localize_script

        $.post(ajaxurl, {
            action: 'wcbnpc_dismiss_notice',
            notice_id: noticeId,
            _ajax_nonce: nonce
        });
    });
});
