/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./assets/js/admin-csv-import/initializeCsvImportValidation.js":
/*!*********************************************************************!*\
  !*** ./assets/js/admin-csv-import/initializeCsvImportValidation.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ initializeCsvImportValidation)
/* harmony export */ });
/**
 * Initialize CSV import validation.
 */
function initializeCsvImportValidation() {
  // Add error listener to file inputs.
  var inputs = ['input[name=csv-file]', 'input[name=images-file]'];
  var getParentElements = function getParentElements(input) {
    var mainWrapper = input.closest('.wpbdp-setting-row');
    var labelWrapper = mainWrapper.querySelector('.wpbdp-setting-label');
    return {
      mainWrapper: mainWrapper,
      labelWrapper: labelWrapper,
      label: labelWrapper.querySelector('label')
    };
  };
  var addFileSizeError = function addFileSizeError(input) {
    var parentElements = getParentElements(input);
    parentElements.label.style.color = 'red';
    var error = document.createElement('p');
    error.classList.add('wpbdp-csv-import-error');
    error.textContent = window.wpbdp_admin_import.error_label;
    parentElements.labelWrapper.appendChild(error);
    document.querySelectorAll('.submit input[type=submit]').forEach(function (el) {
      return el.disabled = true;
    });
  };
  var resetFileSizeErrors = function resetFileSizeErrors(input) {
    var parentElements = getParentElements(input);
    parentElements.label.style.color = '';
    parentElements.mainWrapper.querySelectorAll('.wpbdp-csv-import-error').forEach(function (el) {
      return el.remove();
    });
    var errors = document.querySelectorAll('.wpbdp-csv-import-error');
    if (errors.length === 0) {
      document.querySelectorAll('.submit input[type=submit]').forEach(function (el) {
        return el.disabled = false;
      });
    }
  };
  inputs.forEach(function (input) {
    var fileInput = document.querySelector(input);
    if (!fileInput) {
      return;
    }
    fileInput.addEventListener('change', function () {
      resetFileSizeErrors(fileInput);
      var file = fileInput.files[0];
      if (file && file.size > window.wpbdp_admin_import.maxFileSize) {
        addFileSizeError(fileInput);
      }
    });
  });
}

/***/ }),

/***/ "./node_modules/@wordpress/dom-ready/build-module/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@wordpress/dom-ready/build-module/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ domReady)
/* harmony export */ });
/**
 * @typedef {() => void} Callback
 *
 * TODO: Remove this typedef and inline `() => void` type.
 *
 * This typedef is used so that a descriptive type is provided in our
 * automatically generated documentation.
 *
 * An in-line type `() => void` would be preferable, but the generated
 * documentation is `null` in that case.
 *
 * @see https://github.com/WordPress/gutenberg/issues/18045
 */

/**
 * Specify a function to execute when the DOM is fully loaded.
 *
 * @param {Callback} callback A function to execute after the DOM is ready.
 *
 * @example
 * ```js
 * import domReady from '@wordpress/dom-ready';
 *
 * domReady( function() {
 * 	//do something after DOM loads.
 * } );
 * ```
 *
 * @return {void}
 */
function domReady(callback) {
  if (typeof document === 'undefined') {
    return;
  }
  if (document.readyState === 'complete' ||
  // DOMContentLoaded + Images/Styles/etc loaded, so we call directly.
  document.readyState === 'interactive' // DOMContentLoaded fires at this point, so we call directly.
  ) {
    return void callback();
  }

  // DOMContentLoaded has not fired yet, delay callback until then.
  document.addEventListener('DOMContentLoaded', callback);
}
//# sourceMappingURL=index.js.map

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!***************************************!*\
  !*** ./assets/js/admin-csv-import.js ***!
  \***************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/dom-ready */ "./node_modules/@wordpress/dom-ready/build-module/index.js");
/* harmony import */ var _admin_csv_import_initializeCsvImportValidation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./admin-csv-import/initializeCsvImportValidation */ "./assets/js/admin-csv-import/initializeCsvImportValidation.js");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */

(0,_wordpress_dom_ready__WEBPACK_IMPORTED_MODULE_1__["default"])(function () {
  (0,_admin_csv_import_initializeCsvImportValidation__WEBPACK_IMPORTED_MODULE_0__["default"])();
});
jQuery(function ($) {
  var csvimport = {};
  csvimport.CSV_Import = function () {
    this.import_id = $('#wpbdp-csv-import-state').attr('data-import-id');
    this.in_progress = false;
    this.canceled = false;
    this.processed_rows = 0;
    this.total_rows = 0;
    this.imported_rows = 0;
    this.rejected_rows = 0;
    this.warnings = [];
    this.$state = $('#wpbdp-csv-import-state');
    this.$success = $('#wpbdp-csv-import-summary');
    this.$progress_bar = new WPBDP_Admin.ProgressBar($('.import-progress'));
    this._setup_events();
  };
  $.extend(csvimport.CSV_Import.prototype, {
    _setup_events: function _setup_events() {
      var t = this;
      $('a.cancel-import').on('click', function (e) {
        e.preventDefault();
        t.cancel();
      });
      $('a.resume-import').on('click', function (e) {
        e.preventDefault();
        t.start_or_resume();
      });
    },
    _advance: function _advance() {
      var t = this;
      if (!t.in_progress) return;
      if (t.in_progress && t.canceled) {
        t.in_progress = false;
      }
      $.ajax({
        url: ajaxurl,
        type: 'POST',
        dataType: 'json',
        data: {
          action: 'wpbdp-csv-import',
          import_id: t.import_id
        },
        success: function success(res) {
          if (!res || !res.success) return t._fatal_error(res.error);
          t.processed_rows = res.data.progress;
          t.total_rows = res.data.total;
          t.imported_rows = res.data.imported;
          t.rejected_rows = res.data.rejected;
          t.$progress_bar.set(t.processed_rows, t.total_rows);
          if (res.data.done) {
            t.in_progress = false;
            t.warnings = res.data.warnings;
            t._show_success_screen();
          } else {
            t._advance();
          }
        },
        error: function error() {
          return t._fatal_error();
        }
      });
    },
    _show_success_screen: function _show_success_screen() {
      var t = this;
      t.$state.fadeOut(function () {
        t.$state.remove();
        t.$success.find('.placeholder-imported-rows').html(t.imported_rows);
        t.$success.find('.placeholder-rejected-rows').html(t.rejected_rows);
        if (0 == t.warnings.length) {
          t.$success.find('.no-warnings').show();
          t.$success.fadeIn('fast');
          return;
        }
        var $warnings_table = t.$success.find('.wpbdp-csv-import-warnings tbody');
        var $template_row = $warnings_table.find('.row-template');
        $.each(t.warnings, function (i, v) {
          var $r = $template_row.clone();
          $r.find('.col-line-no').html(v.line);
          $r.find('.col-line-content').html(v.content);
          $r.find('.col-warning').html(v.error);
          $warnings_table.append($r.show());
        });
        t.$success.find('.with-warnings').show();
        t.$success.find('.wpbdp-csv-import-warnings').show();
        t.$success.fadeIn('fast');
      });
    },
    _fatal_error: function _fatal_error(msg) {
      var t = this;
      var $fatal_error = $('#wpbdp-csv-import-fatal-error');
      var $with_reason = $fatal_error.find('.with-reason');
      var $no_reason = $fatal_error.find('.no-reason');
      if (msg) {
        $with_reason.html($with_reason.html().replace('%s', msg)).show();
      } else {
        $no_reason.show();
      }
      $fatal_error.show();
      $('html, body').animate({
        scrollTop: 0
      }, 'medium');
      t.cancel();
    },
    start_or_resume: function start_or_resume() {
      if (this.in_progress || this.canceled) return;
      this.in_progress = true;
      $('a.resume-import').css('opacity', '0.4');
      $('.status-msg .not-started').hide();
      $('.status-msg .in-progress').show();
      this._advance();
    },
    cancel: function cancel() {
      var t = this;
      t.canceled = true;
      $('.canceled-import').show();
      t.$state.remove();

      // Try to clean up.
      $.ajax({
        url: ajaxurl,
        type: 'POST',
        dataType: 'json',
        data: {
          action: 'wpbdp-csv-import',
          import_id: t.import_id,
          cleanup: 1
        }
      });
    }
  });

  // Import example page.
  $('a.wpbdp-example-csv').on('click', function (e) {
    e.preventDefault();
    $.ajax({
      url: ajaxurl,
      type: 'POST',
      data: {
        action: 'wpbdp-example-csv',
        nonce: wpbdp_global.nonce
      },
      success: function success(res) {
        var link = document.createElement('a');
        var fileData = ["\uFEFF" + res];
        var fileObject = new Blob(fileData, {
          type: 'text/csv;charset=utf-8;'
        });
        var url = URL.createObjectURL(fileObject);
        link.href = url;
        link.download = 'bd-example.csv';

        // Actually download CSV.
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
      }
    });
  });

  // Import progress page.
  if ($('#wpbdp-csv-import-state').length > 0) {
    var import_in_page = new csvimport.CSV_Import();
    return;
  }

  // Import config. page.
  $('.wpbdp-page-csv-import .file-local-selection a.toggle-selection').on('click', function (e) {
    e.preventDefault();
    var $files = $(this).siblings('ul');
    $files.toggle();
    if (!$files.is(':visible')) $files.find('input[type="radio"]').prop('checked', false);
  });
  $('.wpbdp-page-csv-import').on('change', '.file-local-selection input[type="radio"]', function (e) {
    var sel = $(this).filter(':checked').val();
    if ('' == sel) {
      $(this).prop('checked', false);
      $(this).parents('.file-local-selection').hide();
    }
  });

  // Default User field in Import config. page.
  (function () {
    var $form = $('form#wpbdp-csv-import-form'),
      $use_default_user_checkbox = $form.find('input.use-default-listing-user'),
      $default_user_field;
    $form.on('change', 'input.assign-listings-to-user', function (e) {
      if ($(this).is(':checked')) {
        $form.find('.default-user-selection').show();
      } else {
        $form.find('.default-user-selection').hide();
      }
      $use_default_user_checkbox.trigger('change');
    });
    $('input.assign-listings-to-user').trigger('change');
    $(document).on('change', $use_default_user_checkbox, function () {
      if ($(this).is(':checked')) {
        $form.find('select.default-user, input.default-user').closest('tr').show();
      } else {
        $form.find('select.default-user, input.default-user').closest('tr').hide();
      }
    });
    $use_default_user_checkbox.trigger('change');

    /**
     *
     * @param event
     * @param ui
     */
    function update_textfield_value(event, ui) {
      event.preventDefault();
      if (typeof ui.item === 'undefined') {
        return;
      }
      $default_user_field.val(ui.item.label);
      $default_user_field.siblings('#' + $default_user_field.attr('data-hidden-field')).val(ui.item.value);
    }
    $default_user_field = $form.find('.wpbdp-user-autocomplete').autocomplete({
      source: ajaxurl + '?action=wpbdp-autocomplete-user',
      delay: 500,
      minLength: 2,
      select: update_textfield_value,
      focus: update_textfield_value
    });
  })();
});
})();

/******/ })()
;
//# sourceMappingURL=admin-csv-import.min.js.map