const UpdraftPlusLogo = ({ size = 24, color = 'currentColor' }) => {
	const iconColors = {
		black: 'var(--rsp-black)',
		green: 'var(--rsp-green)',
		yellow: 'var(--rsp-yellow)',
		red: 'var(--rsp-red)',
		blue: 'var(--rsp-blue)',
		gray: 'var(--rsp-grey-600)',
		white: 'var(--rsp-white)'
	};
	const colorVal = iconColors[color] || color;

	return (
		<svg
			version="1.1"
			id="logo-svg"
			xmlns="http://www.w3.org/2000/svg"
			xmlnsXlink="http://www.w3.org/1999/xlink"
			viewBox="0 0 916 186"
			height={size}
		>
			<g id="udp-logo-text" fill={colorVal}>
				<g>
					<path
						d="M214.17,38.15h18.01v63.53c0,13.27,8.66,20.81,21.92,20.81s22.06-7.54,22.06-20.95V38.15h18.01v63.53
										c0,22.2-16.06,37.28-39.94,37.28c-24.02,0-40.07-15.08-40.07-37.28V38.15z M306.33,66.08h16.2v5.17c0,2.65-0.28,4.89-0.28,4.89
										h0.28c0,0,6.14-11.73,22.9-11.73c19.27,0,31.56,15.22,31.56,37.28c0,22.62-13.82,37.28-32.53,37.28c-14.1,0-20.39-9.77-20.39-9.77
										h-0.28c0,0,0.28,2.51,0.28,6.14v29.88h-17.73V66.08z M341.24,124.03c9.77,0,17.87-7.96,17.87-22.06
										c0-13.54-7.26-22.34-17.73-22.34c-9.22,0-17.87,6.7-17.87,22.48C323.5,113.14,329.51,124.03,341.24,124.03z M416.22,64.41
										c15.64,0,20.53,9.08,20.53,9.08h0.28c0,0-0.14-1.81-0.14-4.05V38.15h17.73v99.14h-16.76v-5.86c0-2.65,0.28-4.61,0.28-4.61h-0.28
										c0,0-6,12.15-22.34,12.15c-19.27,0-31.56-15.22-31.56-37.28C383.97,79.07,397.37,64.41,416.22,64.41z M419.57,124.03
										c9.22,0,17.87-6.7,17.87-22.48c0-11.03-5.86-21.92-17.73-21.92c-9.77,0-17.87,7.96-17.87,22.06
										C401.84,115.23,409.1,124.03,419.57,124.03z M468.58,66.08h17.04v12.29c0,2.65-0.28,5.03-0.28,5.03h0.28
										c3.21-10.19,11.73-18.29,22.62-18.29c1.68,0,3.21,0.28,3.21,0.28v17.45c0,0-1.82-0.28-4.19-0.28c-7.54,0-16.06,4.33-19.41,14.94
										c-1.12,3.49-1.54,7.4-1.54,11.59v28.21h-17.73V66.08z M556.83,92.61h2.37v-0.98c0-9.36-5.87-12.57-13.68-12.57
										c-10.19,0-19.55,6.84-19.55,6.84l-6.7-12.71c0,0,11.03-8.8,27.93-8.8c18.71,0,29.6,10.33,29.6,28.35v44.54h-16.34v-5.86
										c0-2.79,0.28-5.03,0.28-5.03h-0.28c0.14,0-5.45,12.57-21.64,12.57c-12.71,0-24.16-7.96-24.16-22.2
										C514.67,94.15,545.24,92.61,556.83,92.61z M543.29,125.15c9.36,0,16.06-10.05,16.06-18.71v-1.67h-3.07
										c-9.08,0-23.74,1.26-23.74,11.17C532.54,120.68,536.03,125.15,543.29,125.15z M592.86,81.3h-8.8V67.2h8.8v-3.21
										c0-23.32,19.13-26.39,29.04-26.39c3.63,0,6,0.42,6,0.42V53.1c0,0-1.54-0.28-3.63-0.28c-5.03,0-13.68,1.26-13.68,11.59v2.79h15.22
										v14.1H610.6v55.99h-17.73V81.3z M635.17,81.3h-9.22V67.2h9.63V46.67h17.31V67.2h16.2v14.1h-16.2v27.65
										c0,11.73,9.22,13.41,14.1,13.41c1.96,0,3.21-0.28,3.21-0.28v15.5c0,0-2.09,0.42-5.45,0.42c-9.91,0-29.6-2.93-29.6-26.81V81.3z
										M684.46,39.55h32.12c17.04,0,29.74,10.75,29.74,28.49c0,17.73-12.71,28.76-29.74,28.76h-26.11v40.49h-6V39.55z M716.3,91.21
										c14.24,0,23.74-8.52,23.74-23.18c0-14.66-9.5-22.9-23.74-22.9h-25.83v46.08H716.3z M760.84,39.55h5.86v81.83
										c0,9.77,5.03,10.89,8.24,10.89c1.12,0,2.09-0.14,2.09-0.14v5.45c0,0-1.26,0.28-2.51,0.28c-4.05,0-13.68-1.54-13.68-14.66V39.55z
										M789.89,67.48h5.86v42.17c0,12.15,1.54,23.6,17.17,23.6c17.45,0,28.62-15.36,28.62-31.7V67.48h5.86v69.82h-5.86v-12.29
										c0-3.21,0.56-5.72,0.56-5.72h-0.28c-2.37,6.56-12.01,19.69-28.9,19.69c-17.17,0-23.04-9.5-23.04-27.23V67.48z M866.96,124.45
										c0,0,7.82,8.8,21.64,8.8c8.52,0,16.06-4.47,16.06-13.12c0-17.73-38.4-12.71-38.4-35.47c0-12.43,10.47-18.85,22.34-18.85
										c14.24,0,20.67,7.54,20.67,7.54l-3.49,4.75c0,0-5.73-6.56-17.59-6.56c-7.96,0-15.78,3.63-15.78,12.71
										c0,18.15,38.4,12.71,38.4,35.89c0,11.17-9.5,18.85-22.34,18.85c-16.9,0-25.27-10.05-25.27-10.05L866.96,124.45z"
					></path>
				</g>
			</g>
			<path
				fill={colorVal}
				id="udp-logo-icon"
				d="M54.59,13.72L54.59,13.72c-0.07,0.04-0.14,0.07-0.22,0.1C54.37,13.82,54.56,13.73,54.59,13.72z M93.31,4.74
								c-10.72,0-20.99,1.93-30.49,5.44l-0.01-0.02c-2.87,1.06-5.52,2.2-8.23,3.55c2.82-1.32,5,1.58,5.15,6.59v72.56
								c0,18.54,15.03,33.57,33.57,33.57c18.54,0,33.57-15.03,33.57-33.57V57.53h-10.35l23.26-27.99l0.44-0.52l0.25-0.31l23.95,28.82
								h-10.36v32.11c0.05,1.07,0.09,2.15,0.09,3.24c0,33.61-27.25,60.85-60.85,60.85c-33.61,0-60.85-27.24-60.85-60.85
								c0-0.98,0.03-1.95,0.08-2.92V40.67c0-7.15-3.51-7.76-4.67-6.75c0,0-0.04,0.03-0.04,0.03C13.76,49.56,5.18,70.2,5.18,92.87
								c0,48.67,39.46,88.13,88.13,88.13c48.67,0,88.13-39.46,88.13-88.13C181.44,44.2,141.98,4.74,93.31,4.74z"
			></path>
		</svg>
	);
};
export default UpdraftPlusLogo;
