<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://eresults.nl
 * @since      1.0.0
 *
 * @package    Bulletin
 * @subpackage Bulletin/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Bulletin
 * @subpackage Bulletin/admin
 * @author     Martijn Gastkemper <martijngastkemper@eresults.nl>
 */
class Bulletin_Admin {

    /**
     * The options name to be used in this plugin
     *
     * @since  	1.0.0
     * @access 	private
     * @var  	string 		$option_name 	Option name of this plugin
     */
    private $option_name = 'bulletin';

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Bulletin_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Bulletin_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

//		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/bulletin-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Bulletin_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Bulletin_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

//		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/bulletin-admin.js', array( 'jquery' ), $this->version, false );

	}

    /**
     * Add an options page under the Settings submenu
     *
     * @since  1.0.0
     */
    public function add_options_page() {

        $this->plugin_screen_hook_suffix = add_options_page(
            __( 'Bulletin settings', 'bulletin' ),
            __( 'Bulletin', 'bulletin' ),
            'manage_options',
            $this->plugin_name,
            array( $this, 'display_options_page' )
        );

    }

    /**
     * Render the options page for plugin
     *
     * @since  1.0.0
     */
    public function display_options_page() {
        include_once 'partials/bulletin-admin-display.php';
    }

    public function register_setting() {
        add_settings_section(
            $this->option_name . '_general',
            __( 'API token', 'bulletin' ),
            array( $this , $this->option_name . '_general_cb' ),
            $this->plugin_name
        );

        add_settings_field(
            $this->option_name . '_api_token',
            __( 'API token', 'bulletin' ),
            array( $this, $this->option_name . '_api_token_cb' ),
            $this->plugin_name,
            $this->option_name . '_general',
            array( 'label_for' => $this->option_name . '_api_token' )
        );

        register_setting( $this->plugin_name, $this->option_name . '_api_token');
    }

    public function bulletin_general_cb() {
        echo '<p>' . __( 'Obtain an API token from bulletin.email -> Settings -> External connections.', 'bulletin' ) . '</p>';
    }

    /**
    * Render the radio input field for position option
    *
    * @since  1.0.0
    */
    public function bulletin_api_token_cb() {
        $apiToken = get_option( $this->option_name . '_api_token' );

        $apiTokenStatus = false;

        if($apiToken) {
            $api = new \Bulletin\Api\Client($apiToken);

            try {
                $api->getLists();

                $apiTokenStatus = __('Token is valid', 'bulletin');
            } catch( \Bulletin\Api\Exception $e ) {
                $responseCode = $e->getCode();

                switch($responseCode) {
                    case 401:
                    case 403:
                        $apiTokenStatus = __('Invalid token provided.', 'bulletin');
                        break;

                    default:
                        $apiTokenStatus = sprintf( esc_html__('Bulletin has a problem. Contact support and report you got an error with code %s', 'bulletin'), $responseCode);
                        break;
                }
            }
        }
        ?>
        <fieldset>
            <label>
                <input type="text" name="<?php echo $this->option_name . '_api_token' ?>" id="<?php echo $this->option_name . '_api_token' ?>" value="<?php echo $apiToken; ?>" />
                <?php echo $apiTokenStatus; ?>
            </label>
        </fieldset>
        <?php
    }

    /**
     * Add a link to the settings page on the plugin overview.
     *
     * @since   1.0.1
     * @param   array   $links
     * @return  array
     */
    public function add_action_links($links) {
        $newLinks = array(
            '<a href="' . admin_url( 'options-general.php?page=' . $this->plugin_name ) . '">' . __('Settings', 'bulletin') . '</a>',
        );
        return array_merge( $links, $newLinks );
    }
}
