<?php
/**
 * Plugin Name:       Bulk Products Pricing
 * Plugin URI:        https://wordpress.org/plugins/bulk-products-pricing
 * Description:       Set different prices based on product quantities. Perfect for wholesale, bulk discounts, and tiered pricing strategies in WooCommerce.
 * Version:           1.0.1
 * Author:            AICOSO
 * Author URI:        https://aicoso.com/
 * License:           GPL-3.0
 * License URI:       https://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain:       bulk-products-pricing
 * Domain Path:       /languages
 * Requires at least: 6.2
 * Tested up to:      6.8
 * Requires PHP:      7.4
 * WC requires at least: 6.0
 * WC tested up to:   10.3.5
 *
 * @package Bulk_Products_Pricing
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$plugin_activation_check = true;
if ( function_exists( 'is_multisite' ) && is_multisite() ) {
	include_once ABSPATH . 'wp-admin/includes/plugin.php';
	if ( ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
		$plugin_activation_check = false;
	}
} elseif ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {
	/**
	* Check whether plugin got activated or not
	*
	* @since 1.0.0
	*/
	$plugin_activation_check = false;
}

/*
 * Runs only when WooCommerce is activated
 *
 */
if ( $plugin_activation_check ) {

	define( 'AICOSO_BULK_PROD_PRICE_DIRPATH', plugin_dir_path( __FILE__ ) );
	define( 'AICOSO_BULK_PROD_PRICE_URL', plugin_dir_url( __FILE__ ) );
	define( 'AICOSO_BULK_PROD_PRICE_HOME_URL', home_url() );

	/*
	* Including Admin and Public files
	*/
	include_once AICOSO_BULK_PROD_PRICE_DIRPATH . '/admin/class-aicoso-bulk-prod-price-admin.php';
	include_once AICOSO_BULK_PROD_PRICE_DIRPATH . '/public/class-aicoso-bulk-prod-price-public.php';

	/**
	 * Declare compatibility with WooCommerce HPOS (High-Performance Order Storage)
	 *
	 * @since 1.0.0
	 */
	add_action(
		'before_woocommerce_init',
		function () {
			if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
				\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
			}
		}
	);

	/**
	 * Create Settings for the Plugin
	 *
	 * @name aicoso_bulk_prod_price_settings_link
	 * @since 1.0.0
	 * @param array $settings_links  array of the link.
	 */
	function aicoso_bulk_prod_price_settings_link( $settings_links ) {

		$settings_links[] = '<a href="' . admin_url( 'admin.php?page=aicoso-bulk-prod-price-setting&tab=basic' ) . '">' . esc_html__( 'Settings', 'bulk-products-pricing' ) . '</a>';
		return $settings_links;
	}

	// Add settings link on plugin page.
	add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'aicoso_bulk_prod_price_settings_link' );

} else {
	/**
	 * Display error Notice in the admin section.
	 *
	 * @name aicoso_bulk_prod_price_plugin_error_notice
	 */
	function aicoso_bulk_prod_price_plugin_error_notice() {
		?>
			<div class="error notice is-dismissible">
			<p><?php esc_html_e( 'Woocommerce is not activated, Please activate Woocommerce first to install WooCommerce Per Quantity Pricing.', 'bulk-products-pricing' ); ?></p>
			</div>
		<?php
		// Add inline style to hide activation message
		wp_add_inline_style( 'common', '#message{display:none;}' );
	}
	add_action( 'admin_init', 'aicoso_bulk_prod_price_plugin_deactivate' );

	/**
	 * Trigeers this function when plugin get deactivate.
	 *
	 * @name aicoso_bulk_prod_price_plugin_deactivate
	 */
	function aicoso_bulk_prod_price_plugin_deactivate() {
		deactivate_plugins( plugin_basename( __FILE__ ) );
		add_action( 'admin_notices', 'aicoso_bulk_prod_price_plugin_error_notice' );
	}
}
