(function( $ ) {
	'use strict';

	$(document).ready(function() {
		// Check if aicoso_pqp is defined (plugin is active)
		if (typeof aicoso_pqp === 'undefined') {
			return;
		}

		$( '.cart' ).each( function() {
			$( this ).wc_pqpsingle_form();
		});

		if (aicoso_pqp.type != 'variable') {
			var pqp_enable = aicoso_pqp.pqp_enable;
			var product_id = aicoso_pqp.product_id;
			var qty = $('.input-text.qty.text').val();
			if (!isNaN(qty) && qty >= 1) {
				if ( pqp_enable == 'yes') {
					fetch_price(qty, product_id);
				}
			}
		} else {
			// For variable products, check if a variation is already selected on page load
			var variation_id = $('.variation_id').val();
			if (variation_id && variation_id > 0) {
				var childs = aicoso_pqp.var_arr;
				var is_pqp = false;
				$.each(childs, function(key, value) {
					if ( variation_id == key && value == 'yes') {
						is_pqp = true;
					}
				});
				if (is_pqp) {
					var qty = $('.input-text.qty.text').val();
					if (!isNaN(qty) && qty >= 1) {
						fetch_price(qty, variation_id);
					}
				}
			}

			// Listen to WooCommerce's found_variation event for better compatibility
			$('.variations_form').on('found_variation', function(event, variation) {
				if (variation.variation_id) {
					// Small delay to let WooCommerce finish its processing
					setTimeout(function() {
						$('.single_add_to_cart_button').prop('disabled', false).removeClass('disabled wc-variation-selection-needed');
					}, 100);
				}
			});
		}
	});
	var PqpsingleForm = function( $form ) {
		this.$form                = $form;
		$form.on( 'change', '.variation_id', { pqpsingleForm: this }, this.onChangeVaration );
		$form.on( 'input', '.input-text.qty.text', { pqpsingleForm: this }, this.onChangeQty );
	};
	$.fn.wc_pqpsingle_form = function() {
		new PqpsingleForm( this );
		return this;
	};
	var fetch_price = function( qty, product_id ) {
		block( $( 'div.summary.entry-summary' ) );
		var data = {
			action:'aicoso_bulk_prod_price_single_qty',
			product_id:product_id,
			security:aicoso_pqp.ajax_nonce,
			qty:qty
		};
		$.ajax({
			url: aicoso_pqp.ajaxurl,
			security:aicoso_pqp.ajax_nonce,
			type: "POST",
			data: data,
			dataType :'json',
			success: function(response)
			{
				// if (response.result == true) {
					$('.summary.entry-summary').find('p.price').html(response.data);
				// }
				if (aicoso_pqp.type == 'variable') {
					if ( response.html) {
						$('.aicoso_bulk_prod_price_per_qty_table').html(response.html);
					}
					// Trigger WooCommerce variation form update to enable add to cart button
					$('.variations_form').trigger('check_variations');
					$('.single_add_to_cart_button').prop('disabled', false).removeClass('disabled wc-variation-selection-needed');
				}
			},
			complete: function() {
				unblock( $( 'div.summary.entry-summary' ) );
			}
		});
	}
	PqpsingleForm.prototype.onChangeQty = function( event ) {
		var qty = $(this).val();
		var product_id = 0;
		var pqp_enable = '';
		if (aicoso_pqp.type == 'variable') {
			product_id = $('.variation_id').val();
			var childs = aicoso_pqp.var_arr;
			var is_pqp = false;
			$.each(childs, function(key, value) {
				if ( product_id == key && value == 'yes') {
					is_pqp = true;
				}
			});

			if (is_pqp) {
				if (!isNaN(qty)) {
					fetch_price(qty, product_id);
				}
			}
		} else {
			pqp_enable = aicoso_pqp.pqp_enable;
			product_id = aicoso_pqp.product_id;

			if (!isNaN(qty) && qty >= 1) {
				if ( pqp_enable == 'yes') {
					fetch_price(qty, product_id);
				}
			}
		}
	};
	
	
	
	PqpsingleForm.prototype.onChangeVaration = function( event ) {

		var product_id = parseInt($(this).val());
		var childs = aicoso_pqp.var_arr;
		var is_pqp = false;
		$.each(childs, function(key, value) {
			if ( product_id == key && value == 'yes') {
				is_pqp = true;
			}
		});

		if (is_pqp) {
			var qty = $('.input-text.qty.text').val();
			if (!isNaN(qty) && product_id > 0) {
				fetch_price(qty, product_id);
			}
		} else {
			// If variation doesn't have quantity pricing, ensure button is enabled normally
			if (product_id > 0) {
				$('.single_add_to_cart_button').prop('disabled', false).removeClass('disabled wc-variation-selection-needed');
			}
		}
	};
	var is_blocked = function( $node ) {
		return $node.is( '.processing' ) || $node.parents( '.processing' ).length;
	};

	var block = function( $node ) {
		if ( ! is_blocked( $node ) ) {
			$node.addClass( 'processing' ).block( {
				message: null,
				overlayCSS: {
					background: '#fff',
					opacity: 0.6
				}
			} );
		}
	};

	var unblock = function( $node ) {
		$node.removeClass( 'processing' ).unblock();
	};

})( jQuery );
