jQuery(function($) {
	'use strict';
	
	// Only run on cart page
	if (!$('body').hasClass('woocommerce-cart') && !$('.woocommerce-cart-form').length) {
		return;
	}
	
	var updateTimer = null;
	var isUpdating = false;
	
	// Function to force a full cart update (page refresh)
	function forceCartUpdate() {
		if (isUpdating) return;
		
		isUpdating = true;
		
		// Get the cart form
		var $form = $('.woocommerce-cart-form, form[name="checkout"]');
		
		if ($form.length) {
			// Disable AJAX cart update to force page refresh
			$form.off('submit');
			
			// Add/update the update_cart field
			var $updateField = $form.find('input[name="update_cart"]');
			if (!$updateField.length) {
				$form.append('<input type="hidden" name="update_cart" value="Update cart">');
			} else {
				$updateField.val('Update cart');
			}
			
			// Enable the update button if it exists
			var $updateBtn = $('button[name="update_cart"], input[name="update_cart"][type="submit"]');
			if ($updateBtn.length) {
				$updateBtn.prop('disabled', false).attr('aria-disabled', 'false');
			}
			
			// Submit the form (this will cause a page refresh)
			$form.get(0).submit();
		}
	}
	
	// Listen for quantity changes
	$(document).on('change', '.quantity input.qty, input.qty[type="number"], .qty', function(e) {
		var $input = $(this);
		var newQty = parseInt($input.val()) || 0;
		
		// Clear any existing timer
		clearTimeout(updateTimer);
		
		// Show loading state
		$input.closest('tr, .cart_item').css('opacity', '0.6');
		
		// Check if quantity is at a boundary or outside defined ranges
		// Common tier boundaries - adjust these based on your actual tiers
		var boundaryQuantities = [1, 2, 4, 5, 7, 8, 10];
		var isAtBoundary = boundaryQuantities.indexOf(newQty) !== -1;
		
		// Force immediate update for boundary quantities
		var delay = isAtBoundary ? 300 : 800;
		
		// Set timer to update cart after user stops changing
		updateTimer = setTimeout(function() {
			forceCartUpdate();
		}, delay);
	});
	
	// Also handle plus/minus buttons
	$(document).on('click', '.quantity .plus, .quantity .minus, .qty-button', function() {
		clearTimeout(updateTimer);
		
		var $row = $(this).closest('tr, .cart_item');
		$row.css('opacity', '0.6');
		
		// Wait for the quantity value to be updated
		updateTimer = setTimeout(function() {
			forceCartUpdate();
		}, 800);
	});
	
	// Handle Enter key
	$(document).on('keypress', '.quantity input.qty', function(e) {
		if (e.which === 13) { // Enter key
			e.preventDefault();
			clearTimeout(updateTimer);
			forceCartUpdate();
		}
	});
	
	// Remove any existing WooCommerce AJAX cart handlers that might interfere
	$(document).ready(function() {
		// Remove WooCommerce's AJAX cart update
		$('.woocommerce-cart-form').off('submit');
		
		// Re-enable the update cart button on page load
		$('button[name="update_cart"], input[name="update_cart"]').prop('disabled', false);
	});
});