(function( $ ) {
	'use strict';

	$(document).ready(function() {
		$('#aicoso_bulk_prod_price_choose_cat').select2();
		$('#aicoso_bulk_prod_price_choose_prod').select2();
		$('.aicoso_bulk_prod_price_color').each(function(){
			$(this).wpColorPicker();
		});

		// When products are selected directly, clear category selection
		$('#aicoso_bulk_prod_price_choose_prod').on('change', function() {
			if ($(this).val() && $(this).val().length > 0) {
				// Clear category selection when products are manually selected
				$('#aicoso_bulk_prod_price_choose_cat').val(null).trigger('change.select2');
			}
		});
	});
	$(document).on('change','#aicoso_bulk_prod_price_choose_cat',function(){
		var catID = $(this).val();
		// Store previously selected products
		var selectedProducts = $('#aicoso_bulk_prod_price_choose_prod').val();

		if (catID && catID.length > 0) {
			var data = {
				action:'aicoso_bulk_prod_price_choose_categories',
				catID:catID,
				security:aicoso_pqp.ajax_nonce
			};

			$('#aicoso_bulk_prod_price_loader').show();
			// Clear product selection when categories change
			$('#aicoso_bulk_prod_price_choose_prod').val(null).trigger('change');

			$.ajax({
				url: aicoso_pqp.ajaxurl,
				type: "POST",
				data: data,
				security:aicoso_pqp.ajax_nonce,
				dataType :'json',
				success: function(response)
				{
					$('#aicoso_bulk_prod_price_loader').hide();
					if ( response ) {
						$('#aicoso_bulk_prod_price_choose_prod').html(response);
						$('#aicoso_bulk_prod_price_choose_prod').select2();
						// Note: Don't restore selection as categories have changed
					}
				}
			});
		} else {
			// If no categories selected, load all products via AJAX instead of page reload
			var data = {
				action:'aicoso_bulk_prod_price_choose_categories',
				catID: [], // Empty array to load all products
				security:aicoso_pqp.ajax_nonce
			};

			$('#aicoso_bulk_prod_price_loader').show();
			$.ajax({
				url: aicoso_pqp.ajaxurl,
				type: "POST",
				data: data,
				security:aicoso_pqp.ajax_nonce,
				dataType :'json',
				success: function(response)
				{
					$('#aicoso_bulk_prod_price_loader').hide();
					// Load all products when categories are cleared
					if ( response ) {
						$('#aicoso_bulk_prod_price_choose_prod').html(response);
						$('#aicoso_bulk_prod_price_choose_prod').select2();
					}
				}
			});
		}
	});
	$(document).on('click','.pqp_action_remove', function() {
		$(this).closest('tr').remove();
	});

	$(document).on('click', '.pqp_action_global_add',function() {
		
		var empty = false;
		
		$('.pqp_minimum_global_qty').each(function(){
			if (!$(this).val()) {
				$(this).css("border-color", "red");
				empty = true;
			} else {
				$(this).css("border-color", "");
			}
		});
		$('.pqp_maximum_global_qty').each(function(){
			if (!$(this).val()) {
				$(this).css("border-color", "red");
				empty = true;
			} else {
				$(this).css("border-color", "");
			}
		});
		$('.pqp_price_global_qty').each(function(){
			if (!$(this).val()) {
				$(this).css("border-color", "red");
				empty = true;
			} else {
				$(this).css("border-color", "");
			}
		});
		if (!empty) {

			var index = $('.pqp_tbody_global_rows').find('tr:last-child td .pqp_action_remove').data('index');
			var html = '<tr><td><input type="number" class="pqp_minimum_global_qty" name="pqp_minimum_global_qty[]"></td><td><input type="number" class="pqp_maximum_global_qty" name="pqp_maximum_global_qty[]"></td><td><select name="pqp_pricing_global_type[]"><option value="pqp_sell_price">Selling Price</option><option value="pqp_fixed_disc">Fixed Discount</option><option value="pqp_perc_disc">Discount Percentage</option></select></td><td><input type="text" class="pqp_price_global_qty wc_input_price" name="pqp_price_global_qty[]"></td><td><input type="button" class="pqp_action_remove button" data-index="'+(index+1)+'" value="Remove"></td></tr>';
			$('.pqp_tbody_global_rows').append(html);
		}
	});
	$(document).on('click','#aicoso_bulk_prod_price_bulk_add',function(e) {
		e.preventDefault();
		var empty = false;
		var catID = $('#aicoso_bulk_prod_price_choose_cat').val();
		var prodID = $('#aicoso_bulk_prod_price_choose_prod').val();
		
		// Show confirmation if applying to all products
		if ( !catID && !prodID ) {
			if (!confirm('No categories or products selected. This will apply pricing to ALL products in your store. Continue?')) {
				return false;
			}
		}
		$('.pqp_minimum_global_qty').each(function(){
			if (!$(this).val()) {
				$(this).css("border-color", "red");
				empty = true;
			} else {
				$(this).css("border-color", "");
			}
		});
		$('.pqp_maximum_global_qty').each(function(){
			if (!$(this).val()) {
				$(this).css("border-color", "red");
				empty = true;
			} else {
				$(this).css("border-color", "");
			}
		});
		$('.pqp_price_global_qty').each(function(){
			if (!$(this).val()) {
				$(this).css("border-color", "red");
				empty = true;
			} else {
				$(this).css("border-color", "");
			}
		});
		let $min_max_condtion = false;
		$('.pqp_tbody_global_rows tr').each(function(){
			const  maxValue= parseInt($(this).find('.pqp_maximum_global_qty').val());
			const minValue = parseInt($(this).find('.pqp_minimum_global_qty').val());
			if (minValue >= maxValue ) {
				$(this).find('.pqp_maximum_global_qty').css("border-color", "red");
				$(this).find('.pqp_minimum_global_qty').css("border-color", "red");
				$min_max_condtion = true;
			} else {
				$(this).css("border-color", "");
			}
		});
		if($min_max_condtion) {
			$('.notice.notice-error.is-dismissible').each(function(){
				$(this).remove();
			});
			$('.notice.notice-success.is-dismissible').each(function(){
				$(this).remove();
			});
			
			$('html, body').animate({
				scrollTop: $(".woocommerce_page_aicoso-bulk-prod-price-setting").offset().top
			}, 800);
			var empty_message = '<div class="notice notice-error is-dismissible"><p><strong>Maximum value should be greater than Minimum value.</strong></p></div>';
			$(empty_message).insertAfter($('h1.aicoso_bulk_prod_price_setting_title'));
			return;
		}
		if (!empty && !$min_max_condtion) {
			$(this).closest("form#aicoso_setting_form" ).submit();
		} else {
			$('.notice.notice-error.is-dismissible').each(function(){
				$(this).remove();
			});
			$('.notice.notice-success.is-dismissible').each(function(){
				$(this).remove();
			});
			
			$('html, body').animate({
				scrollTop: $(".woocommerce_page_aicoso-bulk-prod-price-setting").offset().top
			}, 800);
			var empty_message = '<div class="notice notice-error is-dismissible"><p><strong>Some Fields are empty!</strong></p></div>';
			$(empty_message).insertAfter($('h1.aicoso_bulk_prod_price_setting_title'));
			return;
		}
	});
})( jQuery );
