<?php
/**
 * Optimized admin settings page template.
 *
 * @package Aicoso_Bulk_Prod_Price
 */

/**
 * Exit if accessed directly
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Tab management
$bulk            = false;
$basic           = false;
$front_table     = false;
$instruct        = false;
$basic_tab       = '';
$front_table_tab = '';
$basic_tab       = '';
$instruct_tab    = '';
$bulk_tab        = '';

if ( isset( $_GET['tab'] ) && ! empty( $_GET['tab'] ) ) {
	$tab = sanitize_text_field( wp_unslash( $_GET['tab'] ) );
	switch ( $tab ) {
		case 'basic':
			$basic_tab = 'nav-tab-active';
			$basic     = true;
			break;
		case 'bulk':
			$bulk_tab = 'nav-tab-active';
			$bulk     = true;
			break;
		case 'front-table':
			$front_table_tab = 'nav-tab-active';
			$front_table     = true;
			break;
		case 'instructions':
			$instruct_tab = 'nav-tab-active';
			$instruct     = true;
			break;
		default:
			$basic_tab = 'nav-tab-active';
			$basic     = true;
	}
} else {
	$basic_tab = 'nav-tab-active';
	$basic     = true;
}

// Handle General Settings Save
if ( isset( $_POST['_wpqty_field'] ) && wp_verify_nonce( wp_unslash( sanitize_text_field( wp_unslash( $_POST['_wpqty_field'] ) ) ), '_wpqty_action' ) && isset( $_POST['aicoso_bulk_prod_price_general_save'] ) ) {
	if ( ! isset( $_POST['aicoso_bulk_prod_price_plugin_enable'] ) ) {
		$_POST['aicoso_bulk_prod_price_plugin_enable'] = 'off';
	}
	if ( ! isset( $_POST['aicoso_bulk_prod_price_tax_enable'] ) ) {
		$_POST['aicoso_bulk_prod_price_tax_enable'] = 'off';
	}
	if ( ! isset( $_POST['aicoso_bulk_prod_price_ftable_enable'] ) ) {
		$_POST['aicoso_bulk_prod_price_ftable_enable'] = 'off';
	}
	update_option( 'aicoso_bulk_prod_price_plugin_enable', sanitize_text_field( wp_unslash( $_POST['aicoso_bulk_prod_price_plugin_enable'] ) ) );
	update_option( 'aicoso_bulk_prod_price_tax_enable', sanitize_text_field( wp_unslash( $_POST['aicoso_bulk_prod_price_tax_enable'] ) ) );
	update_option( 'aicoso_bulk_prod_price_ftable_enable', sanitize_text_field( wp_unslash( $_POST['aicoso_bulk_prod_price_ftable_enable'] ) ) );
	?>
		<div class="notice notice-success is-dismissible">
			<p><strong><?php esc_html_e( 'Settings Saved Successfully.', 'bulk-products-pricing' ); ?></strong></p>
		</div>
	<?php
}

$plugin_enable = get_option( 'aicoso_bulk_prod_price_plugin_enable', false );
$tax_calc      = get_option( 'aicoso_bulk_prod_price_tax_enable', 'on' );
$ftable_enable = get_option( 'aicoso_bulk_prod_price_ftable_enable', false );

// Handle Bulk Pricing Save (OPTIMIZED)
if ( isset( $_POST['_wpqty_field'] ) && wp_verify_nonce( wp_unslash( sanitize_text_field( wp_unslash( $_POST['_wpqty_field'] ) ) ), '_wpqty_action' ) && isset( $_POST['aicoso_bulk_prod_price_bulk_hidden'] ) && ! isset( $_POST['aicoso_bulk_prod_price_bulk_remove'] ) ) {

	// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized when used below
	if ( isset( $_POST['pqp_minimum_global_qty'] ) && ! empty( wp_unslash( $_POST['pqp_minimum_global_qty'] ) ) && isset( $_POST['pqp_maximum_global_qty'] ) && ! empty( wp_unslash( $_POST['pqp_maximum_global_qty'] ) ) && isset( $_POST['pqp_price_global_qty'] ) && ! empty( wp_unslash( $_POST['pqp_price_global_qty'] ) ) && isset( $_POST['pqp_pricing_global_type'] ) && ! empty( wp_unslash( $_POST['pqp_pricing_global_type'] ) ) ) {

		$min_arr   = map_deep( wp_unslash( $_POST['pqp_minimum_global_qty'] ), 'sanitize_text_field' );
		$max_arr   = map_deep( wp_unslash( $_POST['pqp_maximum_global_qty'] ), 'sanitize_text_field' );
		$price_arr = map_deep( wp_unslash( $_POST['pqp_price_global_qty'] ), 'sanitize_text_field' );
		$disc_type = map_deep( wp_unslash( $_POST['pqp_pricing_global_type'] ), 'sanitize_text_field' );

		if ( ( count( $min_arr ) === count( $max_arr ) ) && ( count( $max_arr ) === count( $price_arr ) ) ) {
			$product_ids = array();
			$cat_id      = array();

			// Priority 1: Check for specific products
			// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized on next line
			if ( isset( $_POST['aicoso_bulk_prod_price_choose_prod'] ) && ! empty( wp_unslash( $_POST['aicoso_bulk_prod_price_choose_prod'] ) ) ) {
				$product_ids = map_deep( wp_unslash( $_POST['aicoso_bulk_prod_price_choose_prod'] ), 'sanitize_text_field' );
				if ( ! is_array( $product_ids ) ) {
					$product_ids = array( $product_ids );
				}
				delete_option( '_aicoso_bulk_prod_price_cats_ids' );
			// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized on next line
			} elseif ( isset( $_POST['aicoso_bulk_prod_price_choose_cat'] ) && ! empty( wp_unslash( $_POST['aicoso_bulk_prod_price_choose_cat'] ) ) ) {
				// Priority 2: Check for categories - OPTIMIZED
				$cat_id = map_deep( wp_unslash( $_POST['aicoso_bulk_prod_price_choose_cat'] ), 'sanitize_text_field' );
				update_option( '_aicoso_bulk_prod_price_cats_ids', $cat_id );

				// Use optimized query - get only IDs
				$args = array(
					'post_type'      => array( 'product' ),
					'posts_per_page' => -1,
					'fields'         => 'ids',
					'post_status'    => 'publish',
					// phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_tax_query -- Required for bulk category pricing, admin-only operation
					'tax_query'      => array(
						array(
							'taxonomy' => 'product_cat',
							'field'    => 'id',
							'terms'    => $cat_id,
						),
					),
				);

				$product_ids = get_posts( $args );

			} else {
				// Priority 3: Apply to ALL products - OPTIMIZED
				delete_option( '_aicoso_bulk_prod_price_cats_ids' );
				$args = array(
					'post_type'      => array( 'product' ),
					'posts_per_page' => -1,
					'fields'         => 'ids',
					'post_status'    => 'publish',
				);
				$product_ids = get_posts( $args );
			}

			$qty_price = array(
				'min'   => $min_arr,
				'max'   => $max_arr,
				'price' => $price_arr,
				'type'  => $disc_type,
			);

			// OPTIMIZED: Only clean up previously selected products, not ALL products
			$previous_products = get_option( '_aicoso_bulk_prod_price_selected_products_id', array() );
			if ( ! empty( $previous_products ) && is_array( $previous_products ) ) {
				foreach ( $previous_products as $product_id ) {
					delete_post_meta( $product_id, '_aicoso_bulk_prod_price_quantity_pricing' );
					delete_post_meta( $product_id, '_aicoso_bulk_prod_price_per_quantity' );
				}
			}

			// Save options
			update_option( '_aicoso_bulk_prod_price_qty_min_max', $qty_price );
			update_option( '_aicoso_bulk_prod_price_selected_products_id', $product_ids );

			// Apply pricing to selected products - BATCH PROCESS
			if ( ! empty( $product_ids ) ) {
				$batch_size = 50; // Process 50 products at a time
				$batches = array_chunk( $product_ids, $batch_size );

				foreach ( $batches as $batch ) {
					foreach ( $batch as $product_id ) {
						update_post_meta( $product_id, '_aicoso_bulk_prod_price_quantity_pricing', $qty_price );
						update_post_meta( $product_id, '_aicoso_bulk_prod_price_per_quantity', 'yes' );

						// Handle variations
						$product = wc_get_product( $product_id );
						if ( $product && 'variable' === $product->get_type() ) {
							$variation_ids = $product->get_children();
							if ( ! empty( $variation_ids ) ) {
								foreach ( $variation_ids as $variation_id ) {
									update_post_meta( $variation_id, '_aicoso_bulk_prod_price_quantity_pricing', $qty_price );
									update_post_meta( $variation_id, '_aicoso_bulk_prod_price_per_quantity', 'yes' );
								}
							}
						}
					}
				}

				$product_count = count( $product_ids );
				$message = '';
				// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized on next line
				if ( isset( $_POST['aicoso_bulk_prod_price_choose_prod'] ) && ! empty( wp_unslash( $_POST['aicoso_bulk_prod_price_choose_prod'] ) ) ) {
					/* translators: %d: number of selected products */
					$message = sprintf( esc_html__( 'Bulk pricing has been applied to %d selected product(s).', 'bulk-products-pricing' ), $product_count );
				// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized on next line
				} elseif ( isset( $_POST['aicoso_bulk_prod_price_choose_cat'] ) && ! empty( wp_unslash( $_POST['aicoso_bulk_prod_price_choose_cat'] ) ) ) {
					$cat_count = count( $cat_id );
					/* translators: %1$d: number of products, %2$d: number of categories */
					$message = sprintf( esc_html__( 'Bulk pricing has been applied to %1$d product(s) in %2$d selected category(ies).', 'bulk-products-pricing' ), $product_count, $cat_count );
				} else {
					/* translators: %d: total number of products */
					$message = sprintf( esc_html__( 'Bulk pricing has been applied to ALL %d products in your store.', 'bulk-products-pricing' ), $product_count );
				}
				?>
					<div class="notice notice-success is-dismissible">
						<p><strong><?php echo esc_html( $message ); ?></strong></p>
					</div>
				<?php
			}
		}
	}
}

// Handle Remove Bulk Pricing (OPTIMIZED & FIXED)
if ( isset( $_POST['_wpqty_field'] ) && wp_verify_nonce( wp_unslash( sanitize_text_field( wp_unslash( $_POST['_wpqty_field'] ) ) ), '_wpqty_action' ) && isset( $_POST['aicoso_bulk_prod_price_bulk_remove'] ) ) {
	$selected_products = get_option( '_aicoso_bulk_prod_price_selected_products_id', array() );

	if ( ! empty( $selected_products ) ) {
		// OPTIMIZED: Batch remove
		$batch_size = 50;
		$batches = array_chunk( $selected_products, $batch_size );
		$removed_count = 0;

		foreach ( $batches as $batch ) {
			foreach ( $batch as $product_id ) {
				delete_post_meta( $product_id, '_aicoso_bulk_prod_price_quantity_pricing' );
				delete_post_meta( $product_id, '_aicoso_bulk_prod_price_per_quantity' );
				$removed_count++;

				// Handle variations
				$product = wc_get_product( $product_id );
				if ( $product && 'variable' === $product->get_type() ) {
					$variation_ids = $product->get_children();
					if ( ! empty( $variation_ids ) ) {
						foreach ( $variation_ids as $variation_id ) {
							delete_post_meta( $variation_id, '_aicoso_bulk_prod_price_quantity_pricing' );
							delete_post_meta( $variation_id, '_aicoso_bulk_prod_price_per_quantity' );
						}
					}
				}
			}
		}
		?>
			<div class="notice notice-success is-dismissible">
				<p><strong>
					<?php
					/* translators: %d: number of products */
					echo esc_html( sprintf( __( 'Bulk pricing has been removed from %d product(s).', 'bulk-products-pricing' ), $removed_count ) );
					?>
				</strong></p>
			</div>
		<?php
	}

	// FIXED: Properly clean up ALL saved options
	delete_option( '_aicoso_bulk_prod_price_cats_ids' );
	delete_option( '_aicoso_bulk_prod_price_products_ids' );
	delete_option( '_aicoso_bulk_prod_price_qty_min_max' );
	delete_option( '_aicoso_bulk_prod_price_selected_products_id' );
}

// Handle Front End Table Settings
if ( isset( $_POST['_wpqty_field'] ) && wp_verify_nonce( wp_unslash( sanitize_text_field( wp_unslash( $_POST['_wpqty_field'] ) ) ), '_wpqty_action' ) && isset( $_POST['aicoso_bulk_prod_price_front_submit'] ) ) {

	// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized in ternary
	$table_border_color = ! empty( wp_unslash( $_POST['aicoso_bulk_prod_price_table_thead_border'] ) ) ? sanitize_text_field( wp_unslash( $_POST['aicoso_bulk_prod_price_table_thead_border'] ) ) : '';
	update_option( 'aicoso_bulk_prod_price_table_thead_border', $table_border_color );

	// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized in ternary
	$aicoso_bulk_prod_price_table_thead_bg = ! empty( wp_unslash( $_POST['aicoso_bulk_prod_price_table_thead_bg'] ) ) ? sanitize_text_field( wp_unslash( $_POST['aicoso_bulk_prod_price_table_thead_bg'] ) ) : '';
	update_option( 'aicoso_bulk_prod_price_table_thead_bg', $aicoso_bulk_prod_price_table_thead_bg );

	// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized in ternary
	$aicoso_bulk_prod_price_table_thead_text = ! empty( wp_unslash( $_POST['aicoso_bulk_prod_price_table_thead_text'] ) ) ? sanitize_text_field( wp_unslash( $_POST['aicoso_bulk_prod_price_table_thead_text'] ) ) : '';
	update_option( 'aicoso_bulk_prod_price_table_thead_text', $aicoso_bulk_prod_price_table_thead_text );

	// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized in ternary
	$aicoso_bulk_prod_price_table_tbody_border = ! empty( wp_unslash( $_POST['aicoso_bulk_prod_price_table_tbody_border'] ) ) ? sanitize_text_field( wp_unslash( $_POST['aicoso_bulk_prod_price_table_tbody_border'] ) ) : '';
	update_option( 'aicoso_bulk_prod_price_table_tbody_border', $aicoso_bulk_prod_price_table_tbody_border );

	// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized in ternary
	$aicoso_bulk_prod_price_table_tbody_bg = ! empty( wp_unslash( $_POST['aicoso_bulk_prod_price_table_tbody_bg'] ) ) ? sanitize_text_field( wp_unslash( $_POST['aicoso_bulk_prod_price_table_tbody_bg'] ) ) : '';
	update_option( 'aicoso_bulk_prod_price_table_tbody_bg', $aicoso_bulk_prod_price_table_tbody_bg );

	// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized in ternary
	$aicoso_bulk_prod_price_table_tbody_text = ! empty( wp_unslash( $_POST['aicoso_bulk_prod_price_table_tbody_text'] ) ) ? sanitize_text_field( wp_unslash( $_POST['aicoso_bulk_prod_price_table_tbody_text'] ) ) : '';
	update_option( 'aicoso_bulk_prod_price_table_tbody_text', $aicoso_bulk_prod_price_table_tbody_text );
	?>
		<div class="notice notice-success is-dismissible">
			<p><strong><?php esc_html_e( 'Table colors saved successfully.', 'bulk-products-pricing' ); ?></strong></p>
		</div>
	<?php
}

// Get saved options
$iwe_thead_border         = get_option( 'aicoso_bulk_prod_price_table_thead_border', false );
$iwe_thead_bg             = get_option( 'aicoso_bulk_prod_price_table_thead_bg', false );
$iwe_thead_text           = get_option( 'aicoso_bulk_prod_price_table_thead_text', false );
$iwe_tbody_border         = get_option( 'aicoso_bulk_prod_price_table_tbody_border', false );
$iwe_tbody_bg             = get_option( 'aicoso_bulk_prod_price_table_tbody_bg', false );
$iwe_tbody_text           = get_option( 'aicoso_bulk_prod_price_table_tbody_text', false );
$iwe_cats_ids             = get_option( '_aicoso_bulk_prod_price_cats_ids', false );
$iwe_selected_products_id = get_option( '_aicoso_bulk_prod_price_selected_products_id', false );
$iwe_qty_min_max          = get_option( '_aicoso_bulk_prod_price_qty_min_max', false );

// Build products list - OPTIMIZED: Only get IDs and names, no need for full product objects
$iwe_products_ids = array();
if ( ! empty( $iwe_cats_ids ) ) {
	$args = array(
		'post_type'      => array( 'product' ),
		'posts_per_page' => 100, // Limit to 100 for dropdown performance
		'fields'         => 'ids',
		'post_status'    => 'publish',
		// phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_tax_query -- Required for product dropdown filtering, limited to 100
		'tax_query'      => array(
			array(
				'taxonomy' => 'product_cat',
				'field'    => 'id',
				'terms'    => $iwe_cats_ids,
			),
		),
	);
} else {
	$args = array(
		'post_type'      => array( 'product' ),
		'posts_per_page' => 100, // Limit to 100 for dropdown performance
		'fields'         => 'ids',
		'post_status'    => 'publish',
	);
}

$product_ids_list = get_posts( $args );
if ( ! empty( $product_ids_list ) ) {
	foreach ( $product_ids_list as $product_id ) {
		$product = wc_get_product( $product_id );
		if ( $product ) {
			if ( 'variable' === $product->get_type() ) {
				$variation_ids = $product->get_children();
				foreach ( $variation_ids as $variation_id ) {
					$variation = wc_get_product( $variation_id );
					if ( $variation ) {
						$iwe_products_ids[ $variation_id ] = wp_strip_all_tags( $variation->get_name() );
					}
				}
			} else {
				$iwe_products_ids[ $product_id ] = wp_strip_all_tags( $product->get_formatted_name() );
			}
		}
	}
}

$_aicoso_mis_max_array = array();
if ( ! empty( $iwe_qty_min_max ) && isset( $iwe_qty_min_max['min'] ) && ! empty( $iwe_qty_min_max['min'] ) ) {
	$length = count( $iwe_qty_min_max['min'] );
	for ( $i = 0; $i < $length; $i++ ) {
		$item                    = array(
			'min'   => $iwe_qty_min_max['min'][ $i ],
			'max'   => $iwe_qty_min_max['max'][ $i ],
			'price' => $iwe_qty_min_max['price'][ $i ],
			'type'  => $iwe_qty_min_max['type'][ $i ],
		);
		$_aicoso_mis_max_array[] = $item;
	}
}

?>
<div class="wrap woocommerce" id="aicoso_bulk_prod_price_setting_div">
	<div style="display: none;" class="loading-image" id="aicoso_bulk_prod_price_loader">
		<img src="<?php echo esc_url( AICOSO_BULK_PROD_PRICE_URL ); ?>assets/backend/images/loading.gif">
	</div>
	<h1 class="aicoso_bulk_prod_price_setting_title"><?php esc_html_e( 'Bulk Product Pricing', 'bulk-products-pricing' ); ?></h1>
	<nav class="nav-tab-wrapper woo-nav-tab-wrapper aicoso_bulk_prod_price_nav_tab_wrapper">
		<a class="nav-tab <?php echo esc_html( $basic_tab ); ?>" href="?page=aicoso-bulk-prod-price-setting&tab=basic"><?php esc_html_e( 'General Settings', 'bulk-products-pricing' ); ?></a>
		<a class="nav-tab <?php echo esc_html( $bulk_tab ); ?>" href="?page=aicoso-bulk-prod-price-setting&tab=bulk"><?php esc_html_e( 'Global/Bulk Table', 'bulk-products-pricing' ); ?></a>
		<a class="nav-tab <?php echo esc_html( $front_table_tab ); ?>" href="?page=aicoso-bulk-prod-price-setting&tab=front-table"><?php esc_html_e( 'Front End Table', 'bulk-products-pricing' ); ?></a>
	</nav>

	<?php
	// Status indicator
	$plugin_status = get_option( 'aicoso_bulk_prod_price_plugin_enable', 'off' );
	if ( 'on' === $plugin_status ) {
		echo '<div class="notice notice-success inline" style="margin-top: 10px;"><p><strong>✅ Plugin is ENABLED</strong> - Quantity pricing is active.</p></div>';
	} else {
		echo '<div class="notice notice-warning inline" style="margin-top: 10px;"><p><strong>⚠️ Plugin is DISABLED</strong> - Please enable the plugin in General Settings tab to activate quantity pricing.</p></div>';
	}
	?>

	<form enctype="multipart/form-data" action="" id="aicoso_setting_form" method="post">

		<?php
		if ( $basic ) {
			?>
					<table class="form-table aicoso_bulk_prod_price_basic_setting wp-list-table widefat striped">
						<tbody>
							<tr valign="top">
								<th scope="row" class="titledesc">
									<label for="aicoso_bulk_prod_price_plugin_enable"><?php esc_html_e( 'Enable', 'bulk-products-pricing' ); ?></label>
								</th>
								<td class="forminp forminp-text">

									<label for="aicoso_bulk_prod_price_plugin_enable">
										<input type="checkbox" <?php echo esc_html( ( 'on' === $plugin_enable ) ? "checked='checked'" : '' ); ?> name="aicoso_bulk_prod_price_plugin_enable" id="aicoso_bulk_prod_price_plugin_enable" class="input-text" value="on">
										<p class="description"><?php esc_html_e( 'Check this box to enable the Plugin.', 'bulk-products-pricing' ); ?></p>
									</label>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row" class="titledesc">
									<label for="aicoso_bulk_prod_price_tax_enable"><?php esc_html_e( 'Enable Tax Calculation', 'bulk-products-pricing' ); ?></label>
								</th>
								<td class="forminp forminp-text">

									<label for="aicoso_bulk_prod_price_tax_enable">
										<input type="checkbox" <?php echo esc_html( ( 'on' === $tax_calc ) ? "checked='checked'" : '' ); ?> name="aicoso_bulk_prod_price_tax_enable" id="aicoso_bulk_prod_price_tax_enable" class="input-text" value="on">
										<p class="description"><?php esc_html_e( 'Check this box to enable tax calculation on Per Quantity Pricing Table.', 'bulk-products-pricing' ); ?></p>
									</label>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row" class="titledesc">
									<label for="aicoso_bulk_prod_price_ftable_enable"><?php esc_html_e( 'Display Table on product page', 'bulk-products-pricing' ); ?></label>
								</th>
								<td class="forminp forminp-text">

									<label for="aicoso_bulk_prod_price_ftable_enable">
										<input type="checkbox" <?php echo esc_html( ( 'on' === $ftable_enable ) ? "checked='checked'" : '' ); ?> name="aicoso_bulk_prod_price_ftable_enable" id="aicoso_bulk_prod_price_ftable_enable" class="input-text" value="on">
										<p class="description"><?php esc_html_e( 'Check this box to display Per Quantity Pricing Table on product single page.( Displays table on Variable Products also.)', 'bulk-products-pricing' ); ?></p>
									</label>
								</td>
							</tr>
						</tbody>
					</table>
					<p class="aicoso_bulk_prod_price_submit">
						<input type="submit" value="<?php esc_html_e( 'Save changes', 'bulk-products-pricing' ); ?>" class="button-primary woocommerce-save-button" name="aicoso_bulk_prod_price_general_save" id="aicoso_bulk_prod_price_general_save" >
					</p>

				<?php
		}
		if ( $bulk ) {
			?>
					<table class="form-table aicoso_bulk_prod_price_bulk_setting wp-list-table widefat striped">
						<tbody>
							<tr valign="top">
								<th scope="row" class="titledesc">
									<label for="aicoso_bulk_prod_price_choose_cat"><?php esc_html_e( 'Select Categories', 'bulk-products-pricing' ); ?></label>
								</th>
								<td class="forminp forminp-text">

									<select id="aicoso_bulk_prod_price_choose_cat" multiple="multiple" name="aicoso_bulk_prod_price_choose_cat[]">
									<?php
									$args       = array( 'taxonomy' => 'product_cat' );
									$categories = get_terms( $args );
									if ( isset( $categories ) && ! empty( $categories ) ) {
										foreach ( $categories as $category ) {
											$catid   = $category->term_id;
											$catname = $category->name;
											$selected = ! empty( $iwe_cats_ids ) && in_array( (string) $catid, $iwe_cats_ids, true ) ? ' selected="selected" ' : '';
											?>
												<option value="<?php echo esc_attr( $catid ); ?>"<?php echo esc_attr( $selected ); ?>><?php echo esc_html( $catname ); ?></option>
												<?php
										}
									}
									?>
									</select>
									<p class="description"><?php esc_html_e( 'Leave empty to apply to ALL products. Select categories to apply pricing to products in those categories only.', 'bulk-products-pricing' ); ?></p>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row" class="titledesc">
									<label for="aicoso_bulk_prod_price_choose_prod"><?php esc_html_e( 'OR Select Specific Products', 'bulk-products-pricing' ); ?></label>
								</th>
								<td class="forminp forminp-text">

									<label for="aicoso_bulk_prod_price_choose_prod">
										<select id="aicoso_bulk_prod_price_choose_prod" multiple="multiple" name="aicoso_bulk_prod_price_choose_prod[]">
										<?php
										if ( ! empty( $iwe_products_ids ) ) {
											foreach ( $iwe_products_ids as $_id => $name ) {
												$selected = ! empty( $iwe_selected_products_id ) && in_array( (string) $_id, $iwe_selected_products_id, true ) ? ' selected="selected" ' : '';
												?>
													<option value="<?php echo esc_attr( $_id ); ?>"<?php echo esc_attr( $selected ); ?>><?php echo esc_html( $name ); ?></option>
													<?php
											}
										}
										?>
										</select>
										<p class="description"><?php esc_html_e( 'Select specific products to apply pricing only to these products. This overrides category selection. Limited to first 100 products for performance.', 'bulk-products-pricing' ); ?></p>
									</label>
								</td>
							</tr>
							<tr valign="top">
								<th scope="row" class="titledesc">
									<label for="aicoso_bulk_prod_price_qty_table"><?php esc_html_e( 'Per Quantity Table', 'bulk-products-pricing' ); ?></label>
								</th>
								<td colspan="" rowspan="" headers=""></td>
							</tr>
							<tr valign="top">
								<td class="forminp forminp-text" colspan="2">
									<table class="form-table wp-list-table widefat striped">
										<thead>
											<th><?php esc_html_e( 'Minimum Product Quantity', 'bulk-products-pricing' ); ?></th>
											<th><?php esc_html_e( 'Maximum Product Quantity', 'bulk-products-pricing' ); ?></th>
											<th><?php esc_html_e( 'Pricing Type', 'bulk-products-pricing' ); ?></th>
											<th><?php esc_html_e( 'Product Price', 'bulk-products-pricing' ); ?></th>
											<th><?php esc_html_e( 'Action', 'bulk-products-pricing' ); ?></th>
										</thead>
										<tbody class="pqp_tbody_global_rows">
											<?php if ( ! empty( $_aicoso_mis_max_array ) ) : ?>
												<?php foreach ( $_aicoso_mis_max_array as $key => $value ) : ?>
													<tr>
														<td>
															<input type="number" class="pqp_minimum_global_qty" name="pqp_minimum_global_qty[]" value="<?php echo esc_html( $value['min'] ); ?>">
														</td>
														<td>
															<input type="number" class="pqp_maximum_global_qty" name="pqp_maximum_global_qty[]" value="<?php echo esc_html( $value['max'] ); ?>">
														</td>
														<td>
															<select name="pqp_pricing_global_type[]">
																<option value="pqp_sell_price"<?php selected( $value['type'], 'pqp_sell_price' ); ?>><?php esc_html_e( 'Selling Price', 'bulk-products-pricing' ); ?></option>
																<option value="pqp_fixed_disc"<?php selected( $value['type'], 'pqp_fixed_disc' ); ?>><?php esc_html_e( 'Fixed Discount', 'bulk-products-pricing' ); ?></option>
																<option value="pqp_perc_disc"<?php selected( $value['type'], 'pqp_perc_disc' ); ?>><?php esc_html_e( 'Discount Percentage', 'bulk-products-pricing' ); ?></option>
															</select>
														</td>
														<td>
															<input type="text" class="pqp_price_global_qty wc_input_price" name="pqp_price_global_qty[]" value="<?php echo esc_html( $value['price'] ); ?>">
														</td>
														<td>
															<input type="button" class="pqp_action_remove button" data-index="0" value="<?php esc_html_e( 'Remove', 'bulk-products-pricing' ); ?>">
														</td>
													</tr>
												<?php endforeach; ?>
											<?php else : ?>
												<tr>
													<td>
														<input type="number" class="pqp_minimum_global_qty" name="pqp_minimum_global_qty[]">
													</td>
													<td>
														<input type="number" class="pqp_maximum_global_qty" name="pqp_maximum_global_qty[]">
													</td>
													<td>
														<select name="pqp_pricing_global_type[]">
															<option value="pqp_sell_price"><?php esc_html_e( 'Selling Price', 'bulk-products-pricing' ); ?></option>
															<option value="pqp_fixed_disc"><?php esc_html_e( 'Fixed Discount', 'bulk-products-pricing' ); ?></option>
															<option value="pqp_perc_disc"><?php esc_html_e( 'Discount Percentage', 'bulk-products-pricing' ); ?></option>
														</select>
													</td>
													<td>
														<input type="text" class="pqp_price_global_qty wc_input_price" name="pqp_price_global_qty[]">
													</td>
													<td>
														<input type="button" class="pqp_action_remove button" data-index="0" value="<?php esc_html_e( 'Remove', 'bulk-products-pricing' ); ?>">
													</td>
												</tr>
											<?php endif; ?>
										</tbody>
									</table>
									<input type="button" class="pqp_action_global_add button" value="<?php esc_html_e( 'Add More', 'bulk-products-pricing' ); ?>">
								</td>
							</tr>
						</tbody>
					</table>
					<input type="hidden" name="aicoso_bulk_prod_price_bulk_hidden">
					<p class="aicoso_bulk_prod_price_submit">
						<input type="submit" name="aicoso_bulk_prod_price_bulk_add" value="<?php esc_html_e( 'Save and Apply Pricing', 'bulk-products-pricing' ); ?>" id="aicoso_bulk_prod_price_bulk_add" class="button-primary">
						<input type="submit" name="aicoso_bulk_prod_price_bulk_remove" value="<?php esc_html_e( 'Remove All Bulk Pricing', 'bulk-products-pricing' ); ?>" id="aicoso_bulk_prod_price_bulk_remove" class="button button-secondary" onclick="return confirm('<?php esc_html_e( 'Are you sure you want to remove all bulk pricing from all products?', 'bulk-products-pricing' ); ?>');">
					</p>
				<?php
		}
		if ( $front_table ) {
			?>
					<table class="form-table aicoso_bulk_prod_price_front_end_setting wp-list-table widefat striped">
						<tbody>
							<tr valign="top">
								<th scope="row" class="titledesc">
									<label for="aicoso_bulk_prod_price_table_thead_border"><?php esc_html_e( 'Table head border color', 'bulk-products-pricing' ); ?></label>
								</th>
								<td class="forminp forminp-text">
									<input type="text" class="aicoso_bulk_prod_price_color" name="aicoso_bulk_prod_price_table_thead_border" value="<?php echo esc_html( $iwe_thead_border ); ?>">
								</td>
							</tr>
							<tr valign="top">
								<th scope="row" class="titledesc">
									<label for="aicoso_bulk_prod_price_table_thead_bg"><?php esc_html_e( 'Table head background color', 'bulk-products-pricing' ); ?></label>
								</th>
								<td class="forminp forminp-text">
									<input type="text" class="aicoso_bulk_prod_price_color" name="aicoso_bulk_prod_price_table_thead_bg" value="<?php echo esc_html( $iwe_thead_bg ); ?>">
								</td>
							</tr>
							<tr valign="top">
								<th scope="row" class="titledesc">
									<label for="aicoso_bulk_prod_price_table_thead_text"><?php esc_html_e( 'Table head text color', 'bulk-products-pricing' ); ?></label>
								</th>
								<td class="forminp forminp-text">
									<input type="text" class="aicoso_bulk_prod_price_color" name="aicoso_bulk_prod_price_table_thead_text" value="<?php echo esc_html( $iwe_thead_text ); ?>">
								</td>
							</tr>
							<tr valign="top">
								<th scope="row" class="titledesc">
									<label for="aicoso_bulk_prod_price_table_tbody_border"><?php esc_html_e( 'Table body border color', 'bulk-products-pricing' ); ?></label>
								</th>
								<td class="forminp forminp-text">
									<input type="text" class="aicoso_bulk_prod_price_color" name="aicoso_bulk_prod_price_table_tbody_border" value="<?php echo esc_html( $iwe_tbody_border ); ?>">
								</td>
							</tr>
							<tr valign="top">
								<th scope="row" class="titledesc">
									<label for="aicoso_bulk_prod_price_table_tbody_bg"><?php esc_html_e( 'Table body background color', 'bulk-products-pricing' ); ?></label>
								</th>
								<td class="forminp forminp-text">
									<input type="text" class="aicoso_bulk_prod_price_color" name="aicoso_bulk_prod_price_table_tbody_bg" value="<?php echo esc_html( $iwe_tbody_bg ); ?>">
								</td>
							</tr>
							<tr valign="top">
								<th scope="row" class="titledesc">
									<label for="aicoso_bulk_prod_price_table_tbody_text"><?php esc_html_e( 'Table body text color', 'bulk-products-pricing' ); ?></label>
								</th>
								<td class="forminp forminp-text">
									<input type="text" class="aicoso_bulk_prod_price_color" name="aicoso_bulk_prod_price_table_tbody_text" value="<?php echo esc_html( $iwe_tbody_text ); ?>">
								</td>
							</tr>
						</tbody>
					</table>
					<div style="margin: 20px 0; padding: 15px; background: #f9f9f9; border-left: 4px solid #667eea;">
						<h4 style="margin-top: 0;"><?php esc_html_e( 'Table Styling Info', 'bulk-products-pricing' ); ?></h4>
						<p><?php esc_html_e( 'Leave color fields empty to use the beautiful default gradient styling. The default theme features a modern purple gradient header with clean white body.', 'bulk-products-pricing' ); ?></p>
						<p><?php esc_html_e( 'Custom colors will override the default styling. To reset to defaults, simply clear all color fields and save.', 'bulk-products-pricing' ); ?></p>
					</div>
					<p class="aicoso_bulk_prod_price_submit">
						<input type="submit" name="aicoso_bulk_prod_price_front_submit" value="<?php esc_html_e( 'Save Settings', 'bulk-products-pricing' ); ?>" id="aicoso_bulk_prod_price_front_submit" class="button-primary">
						<button type="button" id="aicoso_bulk_prod_price_reset_colors" class="button" style="margin-left: 10px;"><?php esc_html_e( 'Reset to Default Colors', 'bulk-products-pricing' ); ?></button>
					</p>
				<?php
		}
		if ( $instruct ) {
			?>
					<h2><?php esc_html_e( 'Instructions to use this plugin', 'bulk-products-pricing' ); ?></h2>
				<?php
		}
		?>
		<?php wp_nonce_field( '_wpqty_action', '_wpqty_field' ); ?>
	</form>
</div>
