<?php
/**
 * Admin functionality for the plugin.
 *
 * @package Aicoso_Bulk_Prod_Price
 */

/**
 * If this file is called directly, abort.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Aicoso_Bulk_Prod_Price_Admin' ) ) {

	/**
	 * This is class for managing admin panel functinality.
	 *
	 * @name    Aicoso_Bulk_Prod_Price_Admin
	 * @version  1.0.0
	 */
	class Aicoso_Bulk_Prod_Price_Admin {

		public function __construct() {
			$plugin_enable = get_option( 'aicoso_bulk_prod_price_plugin_enable', 'off' );
			if ( 'on' === $plugin_enable ) {
				add_action( 'woocommerce_product_options_general_product_data', array( $this, 'aicoso_bulk_prod_price_simple_table' ), 10, 1 );
				add_action( 'save_post', array( $this, 'aicoso_bulk_prod_price_save_simple_post' ), 10, 1 );
				add_action( 'woocommerce_variation_options_pricing', array( $this, 'aicoso_bulk_prod_price_woo_variation_pricing' ), 10, 3 );
				add_action( 'woocommerce_save_product_variation', array( $this, 'aicoso_bulk_prod_price_woo_save_product_variation' ), 10, 2 );
			}
			add_action( 'admin_enqueue_scripts', array( $this, 'aicoso_bulk_prod_price_admin_enqueue_scripts' ), 10, 1 );
			add_action( 'admin_menu', array( $this, 'aicoso_bulk_prod_price_admin_menu' ) );
			add_action( 'wp_ajax_aicoso_bulk_prod_price_choose_categories', array( $this, 'aicoso_bulk_prod_price_choose_categories' ) );
			add_action( 'wp_ajax_nopriv_aicoso_bulk_prod_price_choose_categories', array( $this, 'aicoso_bulk_prod_price_choose_categories' ) );
		}
		public function aicoso_bulk_prod_price_choose_categories() {
			check_ajax_referer( '_wpdocs-special-string', 'security' );

			$cat_id = array();
			// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized on next line
			if ( isset( $_POST['catID'] ) && ! empty( wp_unslash( $_POST['catID'] ) ) ) {
				$cat_id = map_deep( wp_unslash( $_POST['catID'] ), 'sanitize_text_field' );
			}

			// Build query args - if categories selected, filter by them; otherwise get all
			if ( ! empty( $cat_id ) ) {
				$args = array(
					'post_type'      => array( 'product' ),
					'posts_per_page' => 100, // Limit for performance
					'post_status'    => 'publish',
					'fields'         => 'ids',
					// phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_tax_query -- Necessary for category filtering, limited to 100 posts
					'tax_query'      => array(
						array(
							'taxonomy' => 'product_cat',
							'field'    => 'id',
							'terms'    => $cat_id,
						),
					),
				);
				update_option( '_aicoso_bulk_prod_price_bulk_prod_price_cats_ids', $cat_id );
			} else {
				// No categories - get all products
				$args = array(
					'post_type'      => array( 'product' ),
					'posts_per_page' => 100, // Limit for performance
					'post_status'    => 'publish',
					'fields'         => 'ids',
				);
				delete_option( '_aicoso_bulk_prod_price_bulk_prod_price_cats_ids' );
			}

			$product_ids_list = get_posts( $args );
			$html             = '';
			$product_ids      = array();

			if ( ! empty( $product_ids_list ) ) {
				foreach ( $product_ids_list as $product_id ) {
					$product = wc_get_product( $product_id );
					if ( $product ) {
						$product_type = $product->get_type();

						if ( 'variable' === $product_type ) {
							$childrenids = $product->get_children();
							foreach ( $childrenids as $variation_id ) {
								$variation = wc_get_product( $variation_id );
								if ( $variation ) {
									$product_ids[ $variation_id ] = $variation->get_name();
									$html .= '<option value="' . esc_attr( $variation_id ) . '">' . esc_html( $variation->get_name() ) . '</option>';
								}
							}
						} else {
							$product_ids[ $product_id ] = $product->get_formatted_name();
							$html .= '<option value="' . esc_attr( $product_id ) . '">' . esc_html( $product->get_formatted_name() ) . '</option>';
						}
					}
				}
			}

			update_option( '_aicoso_bulk_prod_price_bulk_prod_price_products_ids', $product_ids );
			wp_send_json( $html );
		}
		public function aicoso_bulk_prod_price_admin_menu() {
			add_submenu_page(
				'woocommerce',
				esc_html__( 'Bulk Products Pricing', 'bulk-products-pricing' ),
				esc_html__( 'Bulk Products Pricing', 'bulk-products-pricing' ),
				'manage_woocommerce',
				'aicoso-bulk-prod-price-setting',
				array( $this, 'aicoso_bulk_prod_price_per_qty_admin_setting' )
			);
		}
		public function aicoso_bulk_prod_price_per_qty_admin_setting() {
			include_once AICOSO_BULK_PROD_PRICE_DIRPATH . '/admin/partials/woo-per-qty-setting.php';
		}
		public function aicoso_bulk_prod_price_woo_save_product_variation( $variation_id, $loop ) {
			if ( isset( $_POST['_wpqty_field'] ) && wp_verify_nonce( wp_unslash( sanitize_text_field( wp_unslash( $_POST['_wpqty_field'] ) ) ), '_wpqty_action' ) ) {
				$product_id = $variation_id;
				// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized when used
				if ( ! isset( $_POST[ '_aicoso_bulk_prod_price_per_quantity_' . $loop ] ) ) {
					$_POST[ '_aicoso_bulk_prod_price_per_quantity_' . $loop ] = 'no';
				}
				// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized on next line
				if ( isset( $_POST[ '_aicoso_bulk_prod_price_per_quantity_' . $loop ] ) ) {
					update_post_meta( $product_id, '_aicoso_bulk_prod_price_per_quantity', sanitize_text_field( wp_unslash( $_POST[ '_aicoso_bulk_prod_price_per_quantity_' . $loop ] ) ) );
				}

				// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized when used below
				if ( isset( $_POST['pqp_minimum_qty'][ $loop ][0] ) && ! empty( wp_unslash( $_POST['pqp_minimum_qty'][ $loop ][0] ) ) && isset( $_POST['pqp_maximum_qty'][ $loop ][0] ) && ! empty( wp_unslash( $_POST['pqp_maximum_qty'][ $loop ][0] ) ) && isset( $_POST['pqp_price_qty'][ $loop ][0] ) && ! empty( wp_unslash( $_POST['pqp_price_qty'][ $loop ][0] ) ) && isset( $_POST['pqp_pricing_type'][ $loop ][0] ) && ! empty( wp_unslash( $_POST['pqp_pricing_type'][ $loop ][0] ) ) ) {

					$min_arr = map_deep( wp_unslash( $_POST['pqp_minimum_qty'][ $loop ] ), 'sanitize_text_field' );

					$max_arr = map_deep( wp_unslash( $_POST['pqp_maximum_qty'][ $loop ] ), 'sanitize_text_field' );

					$price_arr = map_deep( wp_unslash( $_POST['pqp_price_qty'][ $loop ] ), 'sanitize_text_field' );

					$disc_type = map_deep( wp_unslash( $_POST['pqp_pricing_type'][ $loop ] ), 'sanitize_text_field' );

					if ( ( count( $min_arr ) === count( $max_arr ) ) && ( count( $max_arr ) === count( $price_arr ) ) ) {
						$qty_price = array(
							'min'   => $min_arr,
							'max'   => $max_arr,
							'price' => $price_arr,
							'type'  => $disc_type,
						);
						update_post_meta( $product_id, '_aicoso_bulk_prod_price_quantity_pricing', $qty_price );
					}
				} else {
					delete_post_meta( $product_id, '_aicoso_bulk_prod_price_quantity_pricing' );
				}
			}
		}
		public function aicoso_bulk_prod_price_woo_variation_pricing( $loop, $variation_data, $variation ) {
			$product_id       = $variation->ID;
			$pqp_product_data = get_post_meta( $product_id, '_aicoso_bulk_prod_price_quantity_pricing', true );
			$loop_table       = get_post_meta( $product_id, '_aicoso_bulk_prod_price_per_quantity', true );
			$display          = '';
			if ( isset( $loop_table ) && ! empty( $loop_table ) && 'yes' === $loop_table ) {
				$display = 'block';
			} else {
				$display = 'none';
			}
			?>
				<div class="options_group show_if_simple show_if_external">
					<?php
						woocommerce_wp_checkbox(
							array(
								'id'          => "_aicoso_bulk_prod_price_per_quantity_{$loop}",
								'value'       => $loop_table,
								'class'       => 'aicoso_bulk_prod_price_variation_enable',
								'label'       => esc_html__( 'Enable per quantity pricing', 'bulk-products-pricing' ),
								'desc_tip'    => true,
								'description' => esc_html__( 'Check this box if you want to enable per quantity pricing table.', 'bulk-products-pricing' ),
							)
						);
					?>
					<div id="aicoso_bulk_prod_price_table_variable_<?php echo esc_html( $loop ); ?>" style="display: <?php echo esc_html( $display ); ?>;" class="aicoso_bulk_prod_price_table_variable">
						<table>
							<thead>
								<th><?php esc_html_e( 'Minimum Product Quantity', 'bulk-products-pricing' ); ?></th>
								<th><?php esc_html_e( 'Maximim Product Quantity', 'bulk-products-pricing' ); ?></th>
								<th><?php esc_html_e( 'Pricing Type', 'bulk-products-pricing' ); ?></th>
								<th><?php esc_html_e( 'Product Price', 'bulk-products-pricing' ); ?></th>
								<th><?php esc_html_e( 'Action', 'bulk-products-pricing' ); ?></th>
							</thead>
							<tbody class="pqp_tbody_rows_<?php echo esc_html( $loop ); ?>">
								<?php
								if ( isset( $pqp_product_data ) && ! empty( $pqp_product_data ) ) {
									foreach ( $pqp_product_data['min'] as $key => $value ) {
										?>
												<tr>
													<td>
														<input type="number" name="pqp_minimum_qty[<?php echo esc_html( $loop ); ?>][]" class="pqp_minimum_qty_<?php echo esc_html( $loop ); ?>" value="<?php echo esc_html( $value ); ?>">
													</td>
													<td>
														<input type="number" name="pqp_maximum_qty[<?php echo esc_html( $loop ); ?>][]" class="pqp_maximum_qty_<?php echo esc_html( $loop ); ?>" value="<?php echo esc_html( $pqp_product_data['max'][ $key ] ); ?>">
													</td>
													<td>
														<select name="pqp_pricing_type[<?php echo esc_html( $loop ); ?>][]">
															<option value="pqp_sell_price" <?php selected( $pqp_product_data['type'][ $key ], 'pqp_sell_price' ); ?>><?php esc_html_e( 'Selling Price', 'bulk-products-pricing' ); ?></option>
															<option value="pqp_fixed_disc" <?php selected( $pqp_product_data['type'][ $key ], 'pqp_fixed_disc' ); ?>><?php esc_html_e( 'Fixed Discount', 'bulk-products-pricing' ); ?></option>
															<option value="pqp_perc_disc" <?php selected( $pqp_product_data['type'][ $key ], 'pqp_perc_disc' ); ?>><?php esc_html_e( 'Discount Percentage', 'bulk-products-pricing' ); ?></option>
														</select>
													</td>
													<td>
														<input type="text" name="pqp_price_qty[<?php echo esc_html( $loop ); ?>][]" class="pqp_price_qty_<?php echo esc_html( $loop ); ?> wc_input_price" value="<?php echo esc_html( $pqp_product_data['price'][ $key ] ); ?>">
													</td>
													<td>
														<input type="button" class="pqp_action_remove button" data-index="<?php echo esc_html( $key ); ?>" value="<?php esc_html_e( 'Remove', 'bulk-products-pricing' ); ?>">
													</td>
												</tr>
											<?php
									}
								} else {
									?>
											<tr>
												<td>
													<input type="number" class="pqp_minimum_qty_<?php echo esc_html( $loop ); ?>" name="pqp_minimum_qty[<?php echo esc_html( $loop ); ?>][]">
												</td>
												<td>
													<input type="number" class="pqp_maximum_qty_<?php echo esc_html( $loop ); ?>" name="pqp_maximum_qty[<?php echo esc_html( $loop ); ?>][]">
												</td>
												<td>
													<select name="pqp_pricing_type[<?php echo esc_html( $loop ); ?>][]">
														<option value="pqp_sell_price"><?php esc_html_e( 'Selling Price', 'bulk-products-pricing' ); ?></option>
														<option value="pqp_fixed_disc"><?php esc_html_e( 'Fixed Discount', 'bulk-products-pricing' ); ?></option>
														<option value="pqp_perc_disc"><?php esc_html_e( 'Discount Percentage', 'bulk-products-pricing' ); ?></option>
													</select>
												</td>
												<td>
													<input type="text" class="pqp_price_qty_<?php echo esc_html( $loop ); ?> wc_input_price" name="pqp_price_qty[<?php echo esc_html( $loop ); ?>][]">
												</td>
												<td>
													<input type="button" class="pqp_action_remove button" data-index="0" value="<?php esc_html_e( 'Remove', 'bulk-products-pricing' ); ?>">
												</td>
											</tr>
										<?php
								}
								?>
							</tbody>
						</table>
						<?php wp_nonce_field( '_wpqty_action', '_wpqty_field' ); ?>
						<input type="button" class="pqp_action_add button" value="<?php esc_html_e( 'Add More', 'bulk-products-pricing' ); ?>" data-loop="<?php echo esc_html( $loop ); ?>">
					</div>
				</div>
			<?php
		}
		public function aicoso_bulk_prod_price_admin_enqueue_scripts() {
			$screen = get_current_screen();

			if ( isset( $screen->id ) ) {
				$pagescreen = $screen->id;
				if ( 'product' === $pagescreen ) {
					wp_enqueue_script( 'aicoso_bulk_prod_price_table_script', AICOSO_BULK_PROD_PRICE_URL . 'assets/backend/js/woo-per-qty-product-admin.js', array( 'jquery' ), '1.0.0', true );
					wp_enqueue_style( 'aicoso_bulk_prod_price_table_style', AICOSO_BULK_PROD_PRICE_URL . 'assets/backend/css/woo-per-qty-product-admin.css', array(), '1.0.0', false );

				} elseif ( 'woocommerce_page_aicoso-bulk-prod-price-setting' === $pagescreen ) {
					wp_enqueue_style( 'woocommerce_admin_styles', WC()->plugin_url() . '/assets/css/admin.css', array(), WC_VERSION );
					wp_enqueue_style( 'woocommerce_admin_menu_styles' );

					$locale  = localeconv();
					$decimal = isset( $locale['decimal_point'] ) ? $locale['decimal_point'] : '.';
					$params  = array(
						/* translators: %s: decimal */
						'i18n_decimal_error'               => sprintf( __( 'Please enter in decimal (%s) format without thousand separators.', 'bulk-products-pricing' ), $decimal ),
						/* translators: %s: price decimal separator */
						'i18n_mon_decimal_error'           => sprintf( __( 'Please enter in monetary decimal (%s) format without thousand separators and currency symbols.', 'bulk-products-pricing' ), wc_get_price_decimal_separator() ),
						'i18n_country_iso_error'           => esc_html__( 'Please enter in country code with two capital letters.', 'bulk-products-pricing' ),
						'i18_sale_less_than_regular_error' => esc_html__( 'Please enter in a value less than the regular price.', 'bulk-products-pricing' ),
						'decimal_point'                    => $decimal,
						'mon_decimal_point'                => wc_get_price_decimal_separator(),
						'strings'                          => array(
							'import_products' => esc_html__( 'Import', 'bulk-products-pricing' ),
							'export_products' => esc_html__( 'Export', 'bulk-products-pricing' ),
						),
						'urls'                             => array(
							'import_products' => esc_url_raw( admin_url( 'edit.php?post_type=product&page=product_importer' ) ),
							'export_products' => esc_url_raw( admin_url( 'edit.php?post_type=product&page=product_exporter' ) ),
						),
					);

					wp_enqueue_script( 'woocommerce_admin', WC()->plugin_url() . '/assets/js/admin/woocommerce_admin.js', array( 'jquery', 'jquery-blockui', 'jquery-ui-sortable', 'jquery-ui-widget', 'jquery-ui-core', 'jquery-tiptip' ), WC_VERSION, true );
					wp_localize_script( 'woocommerce_admin', 'woocommerce_admin', $params );

					wp_enqueue_style( 'wp-color-picker' );
					wp_enqueue_script( 'wp-color-picker' );
					wp_enqueue_style( 'aicoso_bulk_prod_price_table_style', AICOSO_BULK_PROD_PRICE_URL . 'assets/backend/css/woo-per-qty-setting-admin.css', array(), '1.0.0' );

					$aicoso_pqp['ajaxurl']    = admin_url( 'admin-ajax.php' );
					$aicoso_pqp['ajax_nonce'] = wp_create_nonce( '_wpdocs-special-string' );

					wp_enqueue_script( 'aicoso_bulk_prod_price_table_global_script', AICOSO_BULK_PROD_PRICE_URL . 'assets/backend/js/woo-per-qty-global-admin.js', array( 'jquery', 'wp-color-picker' ), '1.0.2', true );
					wp_localize_script( 'aicoso_bulk_prod_price_table_global_script', 'aicoso_pqp', $aicoso_pqp );
					wp_enqueue_script( 'aicoso_bulk_prod_price_select2', AICOSO_BULK_PROD_PRICE_URL . 'assets/backend/js/select2.js', array( 'jquery' ), '4.0.13', true );
					wp_enqueue_style( 'aicoso_bulk_prod_price_select2_css', AICOSO_BULK_PROD_PRICE_URL . 'assets/backend/css/select2.css', array(), '4.0.13' );

					// Enqueue color reset script
					wp_enqueue_script( 'aicoso_bulk_prod_price_color_reset', AICOSO_BULK_PROD_PRICE_URL . 'assets/backend/js/woo-per-qty-color-reset.js', array( 'jquery', 'wp-color-picker' ), '1.0.0', true );
					$color_reset_data = array(
						'confirm_message' => esc_html__( 'This will clear all custom colors and use the default styling. Continue?', 'bulk-products-pricing' ),
						'success_message' => esc_html__( 'Colors reset! Click Save Settings to apply the default styling.', 'bulk-products-pricing' ),
					);
					wp_localize_script( 'aicoso_bulk_prod_price_color_reset', 'aicoso_bulk_prod_price_color_reset', $color_reset_data );
				}
			}
		}
		public function aicoso_bulk_prod_price_save_simple_post() {
			global $post;
			if ( isset( $post ) && isset( $_POST['_wpqty_field'] ) && wp_verify_nonce( wp_unslash( sanitize_text_field( wp_unslash( $_POST['_wpqty_field'] ) ) ), '_wpqty_action' ) ) {
				$product_id = $post->ID;

				// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized when used
				if ( ! isset( $_POST['_aicoso_bulk_prod_price_per_quantity'] ) ) {
					$_POST['_aicoso_bulk_prod_price_per_quantity'] = 'no';
				}

				// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized on next line
				if ( isset( $_POST['_aicoso_bulk_prod_price_per_quantity'] ) ) {
					update_post_meta( $product_id, '_aicoso_bulk_prod_price_per_quantity', sanitize_text_field( wp_unslash( $_POST['_aicoso_bulk_prod_price_per_quantity'] ) ) );
				}

				// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized when used below
				if ( isset( $_POST['pqp_minimum_qty'] ) && ! empty( wp_unslash( $_POST['pqp_minimum_qty'] ) ) && isset( $_POST['pqp_maximum_qty'] ) && ! empty( wp_unslash( $_POST['pqp_maximum_qty'] ) ) && isset( $_POST['pqp_price_qty'] ) && ! empty( wp_unslash( $_POST['pqp_price_qty'] ) ) && isset( $_POST['pqp_pricing_type'] ) && ! empty( wp_unslash( $_POST['pqp_pricing_type'] ) ) ) {

					$min_arr = map_deep( wp_unslash( $_POST['pqp_minimum_qty'] ), 'sanitize_text_field' );

					$max_arr = map_deep( wp_unslash( $_POST['pqp_maximum_qty'] ), 'sanitize_text_field' );

					$price_arr = map_deep( wp_unslash( $_POST['pqp_price_qty'] ), 'sanitize_text_field' );

					$disc_type = map_deep( wp_unslash( $_POST['pqp_pricing_type'] ), 'sanitize_text_field' );
					if ( ( count( $min_arr ) === count( $max_arr ) ) && ( count( $max_arr ) === count( $price_arr ) ) ) {
						$qty_price = array(
							'min'   => $min_arr,
							'max'   => $max_arr,
							'price' => $price_arr,
							'type'  => $disc_type,
						);
						update_post_meta( $product_id, '_aicoso_bulk_prod_price_quantity_pricing', $qty_price );
					}
				} else {
					delete_post_meta( $product_id, '_aicoso_bulk_prod_price_quantity_pricing' );
				}
			}
		}
		public function aicoso_bulk_prod_price_simple_table() {
			global $post;
			$product_id       = $post->ID;
			$pqp_product_data = get_post_meta( $product_id, '_aicoso_bulk_prod_price_quantity_pricing', true );

			?>
				<div class="options_group show_if_simple show_if_external">
					<?php
						woocommerce_wp_checkbox(
							array(
								'id'          => '_aicoso_bulk_prod_price_per_quantity',
								'label'       => esc_html__( 'Enable per quantity pricing', 'bulk-products-pricing' ),
								'desc_tip'    => true,
								'description' => esc_html__( 'Check this box if you want to enable per quantity pricing table.', 'bulk-products-pricing' ),
							)
						);
					?>
					<div class="aicoso_bulk_prod_price_table_single" style="display: none;">
						<table>
							<thead>
								<th><?php esc_html_e( 'Minimum Product Quantity', 'bulk-products-pricing' ); ?></th>
								<th><?php esc_html_e( 'Maximim Product Quantity', 'bulk-products-pricing' ); ?></th>
								<th><?php esc_html_e( 'Pricing Type', 'bulk-products-pricing' ); ?></th>
								<th><?php esc_html_e( 'Product Price', 'bulk-products-pricing' ); ?></th>
								<th><?php esc_html_e( 'Action', 'bulk-products-pricing' ); ?></th>
							</thead>
							<tbody class="pqp_tbody_rows">
								<?php
								if ( isset( $pqp_product_data ) && ! empty( $pqp_product_data ) ) {
									foreach ( $pqp_product_data['min'] as $key => $value ) {
										?>
												<tr>
													<td>
														<input type="number" name="pqp_minimum_qty[]" class="pqp_minimum_qty" value="<?php echo esc_html( $value ); ?>">
													</td>
													<td>
														<input type="number" name="pqp_maximum_qty[]" class="pqp_maximum_qty" value="<?php echo esc_html( $pqp_product_data['max'][ $key ] ); ?>">
													</td>
													<td>
														<select name="pqp_pricing_type[]">
															<option value="pqp_sell_price" <?php selected( $pqp_product_data['type'][ $key ], 'pqp_sell_price' ); ?>><?php esc_html_e( 'Selling Price', 'bulk-products-pricing' ); ?></option>
															<option value="pqp_fixed_disc" <?php selected( $pqp_product_data['type'][ $key ], 'pqp_fixed_disc' ); ?>><?php esc_html_e( 'Fixed Discount', 'bulk-products-pricing' ); ?></option>
															<option value="pqp_perc_disc" <?php selected( $pqp_product_data['type'][ $key ], 'pqp_perc_disc' ); ?>><?php esc_html_e( 'Discount Percentage', 'bulk-products-pricing' ); ?></option>
														</select>
													</td>
													<td>
														<input type="text" name="pqp_price_qty[]" class="pqp_price_qty wc_input_price" value="<?php echo esc_html( $pqp_product_data['price'][ $key ] ); ?>">
													</td>
													<td>
														<input type="button" class="pqp_action_remove button" data-index="<?php echo esc_html( $key ); ?>" value="<?php esc_html_e( 'Remove', 'bulk-products-pricing' ); ?>">
													</td>
												</tr>
											<?php
									}
								} else {
									?>
											<tr>
												<td>
													<input type="number" class="pqp_minimum_qty" name="pqp_minimum_qty[]">
												</td>
												<td>
													<input type="number" class="pqp_maximum_qty" name="pqp_maximum_qty[]">
												</td>
												<td>
													<select name="pqp_pricing_type[]">
														<option value="pqp_sell_price"><?php esc_html_e( 'Selling Price', 'bulk-products-pricing' ); ?></option>
														<option value="pqp_fixed_disc"><?php esc_html_e( 'Fixed Discount', 'bulk-products-pricing' ); ?></option>
														<option value="pqp_perc_disc"><?php esc_html_e( 'Discount Percentage', 'bulk-products-pricing' ); ?></option>
													</select>
												</td>
												<td>
													<input type="text" class="pqp_price_qty wc_input_price" name="pqp_price_qty[]">
												</td>
												<td>
													<input type="button" class="pqp_action_remove button" data-index="0" value="<?php esc_html_e( 'Remove', 'bulk-products-pricing' ); ?>">
												</td>
											</tr>
										<?php
								}
								?>
							</tbody>
						</table>
						<?php wp_nonce_field( '_wpqty_action', '_wpqty_field' ); ?>
						<input type="button" class="pqp_action_add button" value="<?php esc_html_e( 'Add More', 'bulk-products-pricing' ); ?>">
					</div>
				</div>
			<?php
		}
	}
	new Aicoso_Bulk_Prod_Price_Admin();
}
