<?php
/**
 * Uninstall file for Bulk Deployer.
 *
 * @package BulkDeployer
 */

// If uninstall not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Get database prefix.
global $wpdb;

// Drop the custom tables (both old and new prefix for safety).
$bulkde_new_table_name = $wpdb->prefix . 'bulkde_sites';
$bulkde_old_table_name = $wpdb->prefix . 'bpd_sites';
$bulkde_escaped_new_table_name = esc_sql( $bulkde_new_table_name );
$bulkde_escaped_old_table_name = esc_sql( $bulkde_old_table_name );
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.DirectDatabaseQuery.SchemaChange,WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Direct query required for plugin uninstall, no caching needed for DROP TABLE, schema change required for plugin uninstall, table names escaped with esc_sql()
$wpdb->query( "DROP TABLE IF EXISTS `{$bulkde_escaped_new_table_name}`" );
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.DirectDatabaseQuery.SchemaChange,WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Direct query required for plugin uninstall, no caching needed for DROP TABLE, schema change required for plugin uninstall, table names escaped with esc_sql()
$wpdb->query( "DROP TABLE IF EXISTS `{$bulkde_escaped_old_table_name}`" );

// Delete plugin options (both old and new prefix for safety).
delete_option( 'bulkde_settings' );
delete_option( 'bulkde_db_version' );
delete_option( 'bpd_settings' );
delete_option( 'bpd_db_version' );

// Clear any cached data that has been removed.
wp_cache_flush();
