<?php
/**
 * Admin page template.
 *
 * @package BulkDeployer
 */
// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Determine if form should be expanded (expanded if no sites exist)
$bulkde_form_expanded = empty( $sites );
?>

<div class="wrap">
	<h1><?php esc_html_e( 'Bulk Plugin Deployer', 'bulk-deployer' ); ?></h1>
	
	<div class="bulkde-container">
		<!-- Tab Navigation -->
		<div class="bulkde-tabs">
			<nav class="nav-tab-wrapper">
				<a href="#tab-deploy" class="nav-tab nav-tab-active" data-tab="deploy">
					<?php esc_html_e( 'Deploy Plugins', 'bulk-deployer' ); ?>
				</a>
				<a href="#tab-sites" class="nav-tab" data-tab="sites">
					<?php esc_html_e( 'Site Management', 'bulk-deployer' ); ?>
				</a>
				<a href="#tab-import-export" class="nav-tab" data-tab="import-export">
					<?php esc_html_e( 'Import/Export', 'bulk-deployer' ); ?>
				</a>
			</nav>
			
			<!-- Tab 1: Deploy Plugins -->
			<div id="tab-deploy" class="bulkde-tab-panel bulkde-tab-active">
				<div class="bulkde-section">
					<h2><?php esc_html_e( 'Deploy Plugins', 'bulk-deployer' ); ?></h2>
					
					<div class="bulkde-deploy-layout">
						<!-- Left Column: Plugins -->
						<div class="bulkde-deploy-plugins">
							<div class="bulkde-form-group">
								<label><?php esc_html_e( 'Select Plugins to Deploy', 'bulk-deployer' ); ?></label>
								<div class="bulkde-checkbox-group">
									<?php if ( ! empty( $plugins ) ) : ?>
										<?php foreach ( $plugins as $bulkde_plugin_slug => $bulkde_plugin_data ) : ?>
											<label class="bulkde-checkbox-item">
												<input type="checkbox" name="plugins[]" value="<?php echo esc_attr( $bulkde_plugin_slug ); ?>">
												<span class="bulkde-checkbox-label">
													<strong><?php echo esc_html( $bulkde_plugin_data['name'] ); ?></strong>
													<small><?php echo esc_html( $bulkde_plugin_data['description'] ); ?></small>
													<span class="bulkde-version">v<?php echo esc_html( $bulkde_plugin_data['version'] ); ?></span>
												</span>
											</label>
										<?php endforeach; ?>
									<?php else : ?>
										<p><?php esc_html_e( 'No plugins found in wp-content/plugins directory.', 'bulk-deployer' ); ?></p>
									<?php endif; ?>
								</div>
							</div>
						</div>
						
						<!-- Center Column: Arrow Button -->
						<div class="bulkde-deploy-button-container">
							<button type="button" id="bulkde-deploy-plugins" class="bulkde-arrow-button" disabled>
								<span class="bulkde-arrow-icon">→</span>
								<span class="bulkde-arrow-tooltip"><?php esc_html_e( 'Deploy Selected Plugins', 'bulk-deployer' ); ?></span>
							</button>
						</div>
						
						<!-- Right Column: Target Sites -->
						<div class="bulkde-deploy-sites">
							<div class="bulkde-form-group">
								<label><?php esc_html_e( 'Select Target Sites', 'bulk-deployer' ); ?></label>
								<div class="bulkde-checkbox-group">
									<?php if ( ! empty( $sites ) ) : ?>
										<?php foreach ( $sites as $bulkde_site ) : ?>
											<label class="bulkde-checkbox-item">
												<input type="checkbox" name="sites[]" value="<?php echo esc_attr( $bulkde_site['id'] ); ?>">
												<span class="bulkde-checkbox-label">
													<strong><?php echo esc_html( $bulkde_site['name'] ); ?></strong>
													<small><?php echo esc_html( $bulkde_site['url'] ); ?></small>
												</span>
											</label>
										<?php endforeach; ?>
									<?php else : ?>
										<p><?php esc_html_e( 'No sites added yet. Please add sites in Site Management tab first.', 'bulk-deployer' ); ?></p>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<!-- Deployment Results -->
				<div class="bulkde-section" id="bulkde-results" style="display: none;">
					<h2><?php esc_html_e( 'Deployment Results', 'bulk-deployer' ); ?></h2>
					<div id="bulkde-results-content"></div>
				</div>
			</div>
			
			<!-- Tab 2: Site Management -->
			<div id="tab-sites" class="bulkde-tab-panel">
				<div class="bulkde-section">
					<h2><?php esc_html_e( 'Manage Target Sites', 'bulk-deployer' ); ?></h2>
					
					<!-- Collapsible Add/Edit Site Form -->
					<div class="bulkde-form-collapsible">
						<button type="button" class="bulkde-form-toggle" aria-expanded="<?php echo $bulkde_form_expanded ? 'true' : 'false'; ?>">
							<span class="bulkde-toggle-icon"><?php echo $bulkde_form_expanded ? '−' : '+'; ?></span>
							<span class="bulkde-toggle-text"><?php esc_html_e( 'Add New Site', 'bulk-deployer' ); ?></span>
						</button>
						
						<div class="bulkde-form-container" style="display: <?php echo $bulkde_form_expanded ? 'block' : 'none'; ?>;">
							<form id="bulkde-site-form" class="bulkde-form">
								<div class="bulkde-form-row">
									<div class="bulkde-form-group">
										<label for="site_name"><?php esc_html_e( 'Site Name', 'bulk-deployer' ); ?> *</label>
										<input type="text" id="site_name" name="name" required>
									</div>
									<div class="bulkde-form-group">
										<label for="site_url"><?php esc_html_e( 'Site URL', 'bulk-deployer' ); ?> *</label>
										<input type="url" id="site_url" name="url" required>
									</div>
								</div>
								
								<div class="bulkde-form-row">
									<div class="bulkde-form-group">
										<label for="ftp_host"><?php esc_html_e( 'FTP/SFTP Host', 'bulk-deployer' ); ?> *</label>
										<input type="text" id="ftp_host" name="ftp_host" required>
									</div>
									<div class="bulkde-form-group">
										<label for="ftp_port"><?php esc_html_e( 'FTP/SFTP Port', 'bulk-deployer' ); ?></label>
										<input type="number" id="ftp_port" name="ftp_port" value="21" min="1" max="65535">
										<small class="description"><?php esc_html_e( 'Use port 21 for FTP, port 22 for SFTP', 'bulk-deployer' ); ?></small>
									</div>
								</div>
								
								<div class="bulkde-form-row">
									<div class="bulkde-form-group">
										<label for="ftp_username"><?php esc_html_e( 'FTP/SFTP Username', 'bulk-deployer' ); ?> *</label>
										<input type="text" id="ftp_username" name="ftp_username" required>
									</div>
									<div class="bulkde-form-group">
										<label for="ftp_password"><?php esc_html_e( 'FTP/SFTP Password', 'bulk-deployer' ); ?> *</label>
										<input type="password" id="ftp_password" name="ftp_password" required>
										<small class="description"><?php esc_html_e( 'Leave blank when editing to keep existing password', 'bulk-deployer' ); ?></small>
									</div>
								</div>
								
								<div class="bulkde-form-row">
									<div class="bulkde-form-group">
										<label for="ftp_path"><?php esc_html_e( 'FTP Path to Plugins', 'bulk-deployer' ); ?></label>
										<div class="bulkde-input-with-link">
											<input type="text" id="ftp_path" name="ftp_path" value="/wp-content/plugins/">
											<a href="#" id="bulkde-generate-path" class="button button-small" title="<?php esc_attr_e( 'Generate standard path: /home/[username]/[site]/wp-content/plugins/', 'bulk-deployer' ); ?>">
												<?php esc_html_e( 'Use Standard', 'bulk-deployer' ); ?>
											</a>
										</div>
										<small class="description"><?php esc_html_e( 'Standard path format: /home/[username]/[site]/wp-content/plugins/', 'bulk-deployer' ); ?></small>
									</div>
								</div>
								
								<div class="bulkde-form-actions">
									<button type="button" id="bulkde-test-connection" class="button button-secondary">
										<?php esc_html_e( 'Test Connection', 'bulk-deployer' ); ?>
									</button>
									<button type="submit" class="button button-primary">
										<?php esc_html_e( 'Save Site', 'bulk-deployer' ); ?>
									</button>
									<button type="button" id="bulkde-clear-form" class="button">
										<?php esc_html_e( 'Clear Form', 'bulk-deployer' ); ?>
									</button>
								</div>
							</form>
						</div>
					</div>
					
					<!-- Sites List -->
					<div class="bulkde-sites-list">
						<h3><?php esc_html_e( 'Saved Sites', 'bulk-deployer' ); ?></h3>
						<div id="bulkde-sites-container">
							<?php if ( ! empty( $sites ) ) : ?>
								<table class="wp-list-table widefat fixed striped">
									<thead>
										<tr>
											<th><?php esc_html_e( 'Site Name', 'bulk-deployer' ); ?></th>
											<th><?php esc_html_e( 'URL', 'bulk-deployer' ); ?></th>
											<th><?php esc_html_e( 'FTP Host', 'bulk-deployer' ); ?></th>
											<th><?php esc_html_e( 'Actions', 'bulk-deployer' ); ?></th>
										</tr>
									</thead>
									<tbody>
										<?php foreach ( $sites as $bulkde_site ) : ?>
											<tr data-site-id="<?php echo esc_attr( $bulkde_site['id'] ); ?>">
												<td><?php echo esc_html( $bulkde_site['name'] ); ?></td>
												<td><a href="<?php echo esc_url( $bulkde_site['url'] ); ?>" target="_blank"><?php echo esc_html( $bulkde_site['url'] ); ?></a></td>
												<td><?php echo esc_html( $bulkde_site['ftp_host'] ); ?></td>
												<td>
													<button class="button button-small bulkde-edit-site" data-site='<?php echo wp_json_encode( $bulkde_site ); ?>'>
														<?php esc_html_e( 'Edit', 'bulk-deployer' ); ?>
													</button>
													<button class="button button-small button-link-delete bulkde-delete-site" data-site-id="<?php echo esc_attr( $bulkde_site['id'] ); ?>">
														<?php esc_html_e( 'Delete', 'bulk-deployer' ); ?>
													</button>
												</td>
											</tr>
										<?php endforeach; ?>
									</tbody>
								</table>
							<?php else : ?>
								<p><?php esc_html_e( 'No sites added yet. Add your first site above.', 'bulk-deployer' ); ?></p>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
			
			<!-- Tab 3: Import/Export -->
			<div id="tab-import-export" class="bulkde-tab-panel">
				<div class="bulkde-section">
					<h2><?php esc_html_e( 'Import / Export Sites', 'bulk-deployer' ); ?></h2>
					
					<div class="bulkde-import-export-controls">
						<!-- Export Section -->
						<div class="bulkde-export-section">
							<h4><?php esc_html_e( 'Export Sites', 'bulk-deployer' ); ?></h4>
							<form id="bulkde-export-form">
								<div class="bulkde-form-group">
									<label>
										<input type="checkbox" id="bulkde-export-passwords" name="include_passwords" value="1">
										<?php esc_html_e( 'Include passwords', 'bulk-deployer' ); ?>
										<small class="description" style="display: block; color: #d63638; font-weight: bold;">
											⚠️ <?php esc_html_e( 'Warning: Including passwords in exports is a security risk!', 'bulk-deployer' ); ?>
										</small>
									</label>
								</div>
								
								<div class="bulkde-form-group">
									<label><?php esc_html_e( 'Select sites to export:', 'bulk-deployer' ); ?></label>
									<div class="bulkde-export-site-selection">
										<label>
											<input type="checkbox" id="bulkde-export-all-sites" checked>
											<?php esc_html_e( 'Export all sites', 'bulk-deployer' ); ?>
										</label>
										<div id="bulkde-export-site-list" style="display: none; margin-left: 20px; max-height: 200px; overflow-y: auto;">
											<?php if ( ! empty( $sites ) ) : ?>
												<?php foreach ( $sites as $bulkde_site ) : ?>
													<label style="display: block;">
														<input type="checkbox" name="export_sites[]" value="<?php echo esc_attr( $bulkde_site['id'] ); ?>">
														<?php echo esc_html( $bulkde_site['name'] ); ?>
													</label>
												<?php endforeach; ?>
											<?php endif; ?>
										</div>
									</div>
								</div>
								
								<button type="button" id="bulkde-export-sites" class="button button-secondary">
									<?php esc_html_e( 'Export Sites', 'bulk-deployer' ); ?>
								</button>
							</form>
						</div>
						
						<!-- Import Section -->
						<div class="bulkde-import-section">
							<h4><?php esc_html_e( 'Import Sites', 'bulk-deployer' ); ?></h4>
							<form id="bulkde-import-form" enctype="multipart/form-data">
								<div class="bulkde-form-group">
									<label for="bulkde-import-file"><?php esc_html_e( 'Select import file:', 'bulk-deployer' ); ?></label>
									<input type="file" id="bulkde-import-file" name="import_file" accept=".json" required>
									<small class="description"><?php esc_html_e( 'Select a JSON file exported from this plugin', 'bulk-deployer' ); ?></small>
								</div>
								
								<div class="bulkde-form-group">
									<label for="bulkde-duplicate-action"><?php esc_html_e( 'Handle duplicates:', 'bulk-deployer' ); ?></label>
									<select id="bulkde-duplicate-action" name="duplicate_action">
										<option value="skip"><?php esc_html_e( 'Skip existing sites', 'bulk-deployer' ); ?></option>
										<option value="update"><?php esc_html_e( 'Update existing sites', 'bulk-deployer' ); ?></option>
										<option value="rename"><?php esc_html_e( 'Rename duplicates', 'bulk-deployer' ); ?></option>
									</select>
									<small class="description"><?php esc_html_e( 'Choose how to handle sites with names that already exist', 'bulk-deployer' ); ?></small>
								</div>
								
								<button type="button" id="bulkde-import-sites" class="button button-secondary">
									<?php esc_html_e( 'Import Sites', 'bulk-deployer' ); ?>
								</button>
							</form>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Loading Overlay -->
<div id="bulkde-loading-overlay" style="display: none;">
	<div class="bulkde-loading-content">
		<div class="bulkde-spinner"></div>
		<p id="bulkde-loading-message"><?php esc_html_e( 'Processing...', 'bulk-deployer' ); ?></p>
	</div>
</div>
