<?php
/**
 * Bulk Deployer main file.
 *
 * Plugin Name:       Bulk Deployer
 * Plugin URI:        https://hayan.mamouns.xyz/bulk-deployer-plugin/
 * Description:       Deploy WordPress plugins to multiple sites via FTP/SFTP from one dashboard.
 * Version:           1.0.0
 * Author:            Hayan Mamoun
 * Author URI:        https://exedotcom.ca
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       bulk-deployer
 * Domain Path:       /languages
 * Requires at least: 5.0
 * Tested up to:      6.9
 * Requires PHP:      7.4
 * @package BulkDeployer
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants.
define( 'BULKDE_PLUGIN_VERSION', '1.0.0' );
define( 'BULKDE_PLUGIN_FILE', __FILE__ );
define( 'BULKDE_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'BULKDE_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'BULKDE_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

// Include required files.
require_once BULKDE_PLUGIN_DIR . 'includes/class-bulk-deployer.php';
require_once BULKDE_PLUGIN_DIR . 'includes/class-bulkde-admin.php';
require_once BULKDE_PLUGIN_DIR . 'includes/class-bulkde-deployer.php';
require_once BULKDE_PLUGIN_DIR . 'includes/class-bulkde-site-manager.php';
require_once BULKDE_PLUGIN_DIR . 'includes/class-bulkde-sftp-deployer.php';

// Initialize the plugin.
function bulkde_init() {
	// Check system requirements - need either FTP or SSH2 extension.
	if ( ! function_exists( 'ftp_connect' ) && ! function_exists( 'ssh2_connect' ) ) {
		add_action( 'admin_notices', 'bulkde_extension_notice' );
		return;
	}

	$plugin = new BulkDe_Deployer();
	$plugin->init();
}
add_action( 'plugins_loaded', 'bulkde_init' );

// Show notice if required extensions are missing.
function bulkde_extension_notice() {
	?>
	<div class="notice notice-error">
		<p>
			<strong><?php esc_html_e( 'Bulk Deployer:', 'bulk-deployer' ); ?></strong>
			<?php esc_html_e( 'Either the PHP FTP extension or SSH2 extension is required but neither is installed.', 'bulk-deployer' ); ?>
			<?php esc_html_e( 'Please contact your hosting provider to install either:', 'bulk-deployer' ); ?>
			<ul style="margin-left: 20px;">
				<li><?php esc_html_e( 'php-ftp extension (for FTP connections)', 'bulk-deployer' ); ?></li>
				<li><?php esc_html_e( 'php-ssh2 extension (for SFTP connections)', 'bulk-deployer' ); ?></li>
			</ul>
		</p>
	</div>
	<?php
}

// Activation hook.
register_activation_hook( __FILE__, 'bulkde_activate' );
/**
 * Run plugin activation tasks.
 *
 * @return void
 */
function bulkde_activate() {
	// Create necessary database tables.
	require_once BULKDE_PLUGIN_DIR . 'includes/class-bulkde-installer.php';
	$installer = new BulkDe_Installer();
	$installer->install();
}

// Deactivation hook.
register_deactivation_hook( __FILE__, 'bulkde_deactivate' );
/**
 * Run plugin deactivation tasks.
 *
 * @return void
 */
function bulkde_deactivate() {
	// Cleanup if needed.
}

// Uninstall hook.
register_uninstall_hook( __FILE__, 'bulkde_uninstall' );
/**
 * Run plugin uninstall tasks.
 *
 * @return void
 */
function bulkde_uninstall() {
	// Remove database tables and options.
	require_once BULKDE_PLUGIN_DIR . 'includes/class-bulkde-installer.php';
	$installer = new BulkDe_Installer();
	$installer->uninstall();
}
