<?php
/**
 * Main functionality for category removal
 */
class Blcc_Category_Cleaner {
    /**
     * Remove category from all posts
     *
     * @param int $category_id The category ID to remove
     * @return array Results of the operation
     */
    public static function remove_category_from_posts($category_id) {
        if (!current_user_can('manage_categories')) {
            return array(
                'success' => false,
                'message' => __('You do not have permission to perform this action.', 'bulk-category-cleaner')
            );
        }

        $category = get_term($category_id, 'category');
        if (!$category || is_wp_error($category)) {
            return array(
                'success' => false,
                'message' => __('Invalid category ID.', 'bulk-category-cleaner')
            );
        }

        $posts = get_posts(array(
            'numberposts' => -1,
            'category' => $category_id,
            'fields' => 'ids'
        ));

        $updated_count = 0;
        foreach ($posts as $post_id) {
            $result = wp_remove_object_terms($post_id, $category_id, 'category');
            if (!is_wp_error($result)) {
                $updated_count++;
            }
        }

        return array(
            'success' => true,
            'message' => sprintf(
                // Translators: %d is the number of posts from which the category was removed.
                __('Successfully removed category from %d posts.', 'bulk-category-cleaner'),
                $updated_count
            ),
            'count' => $updated_count
        );
        
    }
}
