<?php
/**
 * Plugin Name: Bulk Category Cleaner
 * Description: Remove a specific category from all posts with one click.
 * Version: 1.0.0
 * Author: Zakaria Binsaifullah
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: bulk-category-cleaner
 * Domain Path: /languages
 * 
 */

// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    die;
}

define('BLCC_VERSION', '1.0.0');
define('BLCC_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('BLCC_PLUGIN_URL', plugin_dir_url(__FILE__));

// Include required files
require_once BLCC_PLUGIN_DIR . 'includes/class-category-cleaner.php';
require_once BLCC_PLUGIN_DIR . 'admin/admin-page.php';

function blcc_activate() {
    add_option('blcc_do_activation_redirect', true);
}
register_activation_hook(__FILE__, 'blcc_activate');

// Initialize the plugin
function blcc_init() {
    add_action('admin_menu', 'blcc_add_admin_menu');
    add_action('admin_enqueue_scripts', 'blcc_enqueue_admin_assets');
    add_action('wp_ajax_blcc_remove_category', 'blcc_ajax_remove_category');
}
add_action('init', 'blcc_init');

// Add admin menu item
function blcc_add_admin_menu() {
    add_management_page(
        __('Bulk Category Cleaner', 'bulk-category-cleaner'),
        __('Bulk Category Cleaner', 'bulk-category-cleaner'),
        'manage_categories',
        'bulk-category-cleaner',
        'blcc_render_admin_page'
    );
}

// Enqueue admin assets
function blcc_enqueue_admin_assets($hook) {
    if ($hook !== 'tools_page_bulk-category-cleaner') {
        return;
    }

    wp_enqueue_style(
        'blcc-admin-styles',
        BLCC_PLUGIN_URL . 'assets/admin.css',
        array(),
        BLCC_VERSION
    );

    wp_enqueue_script(
        'blcc-admin-script',
        BLCC_PLUGIN_URL . 'assets/admin.js',
        array('jquery'),
        BLCC_VERSION,
        true
    );

    wp_localize_script('blcc-admin-script', 'blccAjax', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('blcc_nonce'),
        'confirmMessage' => __('Are you sure you want to remove this category from all posts?', 'bulk-category-cleaner')
    ));
}

// Redirect to admin page after activation
function blcc_redirect_after_activation() {
    if (get_option('blcc_do_activation_redirect', false)) {
        delete_option('blcc_do_activation_redirect');
        wp_safe_redirect(admin_url('tools.php?page=bulk-category-cleaner'));
        exit;
    }
}
add_action('admin_init', 'blcc_redirect_after_activation');



