jQuery(document).ready(function($) {
    // Handle category removal
    $('.blcc-remove-category').on('click', function(e) {
        e.preventDefault();
        
        const button = $(this);
        const categoryId = button.data('category-id');
        const row = button.closest('tr');
        const spinner = row.find('.spinner');
        
        if (!confirm(blccAjax.confirmMessage)) {
            return;
        }
        
        // Disable button and show spinner
        button.prop('disabled', true);
        spinner.addClass('is-active');
        
        // Clear any existing messages
        $('.blcc-message').removeClass('success error').addClass('hidden').empty();
        
        $.ajax({
            url: blccAjax.ajaxurl,
            type: 'POST',
            data: {
                action: 'blcc_remove_category',
                category_id: categoryId,
                nonce: blccAjax.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Show success message
                    $('.blcc-message')
                        .removeClass('hidden error')
                        .addClass('success')
                        .html(response.data.message);
                    
                    // Update post count
                    row.find('td:nth-child(2)').text('0');
                    button.prop('disabled', true);
                } else {
                    // Show error message
                    $('.blcc-message')
                        .removeClass('hidden success')
                        .addClass('error')
                        .html(response.data);
                    button.prop('disabled', false);
                }
            },
            error: function() {
                // Show generic error message
                $('.blcc-message')
                    .removeClass('hidden success')
                    .addClass('error')
                    .html('An error occurred while processing your request.');
                button.prop('disabled', false);
            },
            complete: function() {
                spinner.removeClass('is-active');
            }
        });
    });
});
