<?php
/**
 * Admin page rendering
 */
function blcc_render_admin_page() {
    if (!current_user_can('manage_categories')) {
        wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'bulk-category-cleaner'));
    }

    $categories = get_categories(array(
        'hide_empty' => false,
        'orderby' => 'name',
        'order' => 'ASC'
    ));
    ?>
    <div class="wrap blcc-admin-wrap">
        <h1><?php echo esc_html__('Bulk Category Cleaner', 'bulk-category-cleaner'); ?></h1>
        
        <div class="blcc-description">
            <?php echo esc_html__('Select a category to remove it from all posts. This action cannot be undone.', 'bulk-category-cleaner'); ?>
        </div>

        <div class="blcc-message hidden"></div>

        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th><?php echo esc_html__('Category Name', 'bulk-category-cleaner'); ?></th>
                    <th><?php echo esc_html__('Post Count', 'bulk-category-cleaner'); ?></th>
                    <th><?php echo esc_html__('Action', 'bulk-category-cleaner'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($categories as $category): ?>
                    <?php if ($category->term_id !== 1): // Skip 'Uncategorized' ?>
                        <tr>
                            <td><?php echo esc_html($category->name); ?></td>
                            <td><?php echo esc_html($category->count); ?></td>
                            <td>
                                <button class="button blcc-remove-category" 
                                        data-category-id="<?php echo esc_attr($category->term_id); ?>"
                                        <?php echo $category->count === 0 ? 'disabled' : ''; ?>>
                                    <?php echo esc_html__('Remove Category', 'bulk-category-cleaner'); ?>
                                </button>
                                <span class="spinner"></span>
                            </td>
                        </tr>
                    <?php endif; ?>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php
}

// AJAX handler for category removal
function blcc_ajax_remove_category() {
    check_ajax_referer('blcc_nonce', 'nonce');

    if (!current_user_can('manage_categories')) {
        wp_send_json_error(__('Permission denied.', 'bulk-category-cleaner'));
    }

    $category_id = isset($_POST['category_id']) ? intval($_POST['category_id']) : 0;
    if (!$category_id) {
        wp_send_json_error(__('Invalid category ID.', 'bulk-category-cleaner'));
    }

    $result = Blcc_Category_Cleaner::remove_category_from_posts($category_id);
    
    if ($result['success']) {
        wp_send_json_success($result);
    } else {
        wp_send_json_error($result['message']);
    }
}
