<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class SUBCE_Installer {

    /**
     * Run on plugin activation – create database table.
     */
    public static function activate() {

        global $wpdb;

        $table_name      = $wpdb->prefix . 'subce_submissions';
        $charset_collate = $wpdb->get_charset_collate();

        // SQL must not include IF NOT EXISTS when using dbDelta()
        $sql = "CREATE TABLE $table_name (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            form_id BIGINT(20) UNSIGNED NOT NULL,
            submit_time DATETIME NOT NULL,
            remote_ip VARCHAR(45) DEFAULT NULL,
            user_agent TEXT DEFAULT NULL,
            fields LONGTEXT DEFAULT NULL,
            PRIMARY KEY (id),
            KEY form_id (form_id),
            KEY submit_time (submit_time)
        ) $charset_collate;";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta( $sql );

        // Store DB version (future-proofing)
        update_option( 'subce_db_version', SUBCE_DB_VERSION );
    }
}
