<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class SUBCE_Exporter {

    /**
     * Export CSV for a specific form ID.
     */
    public static function export_csv( $form_id ) {

        global $wpdb;

        $table = $wpdb->prefix . 'subce_submissions';

        // Get submissions for the form
        $submissions = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT * FROM $table WHERE form_id = %d ORDER BY submit_time DESC",
                absint( $form_id )
            )
        );

        if ( empty( $submissions ) ) {
            wp_die( esc_html__( 'No data to export.', 'bulbul-capture-exporter-for-contact-form-7' ) );
        }

        // Load per-form settings
        $settings = get_option( "subce_settings_{$form_id}", [] );
        $visible  = $settings['visible'] ?? [];
        $labels   = $settings['labels'] ?? [];

        // Determine columns
        $sample_fields = json_decode( $submissions[0]->fields, true );
        if ( empty( $visible ) ) {
            $visible = array_keys( $sample_fields );
        }

        $filename = "form-{$form_id}-submissions-" . gmdate( 'Y-m-d' ) . '.csv';

        // CSV headers
        header( 'Content-Type: text/csv; charset=utf-8' );
        header( 'Content-Disposition: attachment; filename="' . esc_attr( $filename ) . '"' );
        header( 'Pragma: no-cache' );
        header( 'Expires: 0' );

       
        echo "\xEF\xBB\xBF";

        $output = fopen( 'php://output', 'w' );

        /**
         * Build CSV header row
         * ⚠ No esc_html__ inside CSV — it must be raw text.
         */
        $headers = [ 'Date', 'IP Address' ];
        foreach ( $visible as $field ) {
            $headers[] = $labels[ $field ] ?? $field;
        }

        fputcsv( $output, $headers );

        /**
         * Output CSV rows
         */
        foreach ( $submissions as $sub ) {

            $fields = json_decode( $sub->fields, true );

            $row   = [];
            $row[] = gmdate( 'Y-m-d H:i:s', strtotime( $sub->submit_time ) ); // ✅ GMT safe
            $row[] = isset( $sub->remote_ip ) ? sanitize_text_field( $sub->remote_ip ) : '';

            foreach ( $visible as $field ) {
                $row[] = isset( $fields[ $field ] ) ? $fields[ $field ] : '';
            }

            fputcsv( $output, $row );
        }

      
        exit;
    }
}
