<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class SUBCE_Capture {

    public static function init() {
        add_action( 'wpcf7_before_send_mail', [ __CLASS__, 'capture_submission' ], 10, 1 );
    }

    public static function capture_submission( $contact_form ) {

        if ( ! class_exists( 'WPCF7_Submission' ) ) {
            return;
        }

        $submission = WPCF7_Submission::get_instance();
        if ( ! $submission ) {
            return;
        }

        $posted_data = $submission->get_posted_data();
        $fields      = [];

        foreach ( $posted_data as $key => $value ) {

            // Skip CF7 internal fields
            if ( strpos( $key, '_wpcf7' ) === 0 || strpos( $key, '_wpnonce' ) === 0 ) {
                continue;
            }

            // Convert arrays (checkboxes, multiple selects)
            if ( is_array( $value ) ) {
                $value = maybe_serialize( $value );
            }

            // Sanitize user-submitted fields
            if ( is_string( $value ) ) {
                // Longer text fields need textarea sanitizing
                $value = ( strlen( $value ) > 200 )
                    ? sanitize_textarea_field( $value )
                    : sanitize_text_field( $value );
            }

            $fields[ $key ] = $value;
        }

        global $wpdb;

        $wpdb->insert(
            $wpdb->prefix . 'subce_submissions',
            [
                'form_id'     => absint( $contact_form->id() ),
                'submit_time' => current_time( 'mysql' ),
                'remote_ip'   => isset( $_SERVER['REMOTE_ADDR'] ) ? sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) ) : '',
                'user_agent'  => isset( $_SERVER['HTTP_USER_AGENT'] ) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_USER_AGENT'] ) ) : '',
                'fields'      => wp_json_encode( $fields ),
            ],
            [ '%d', '%s', '%s', '%s', '%s' ]
        );
    }
}
