<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class SUBCE_Admin {

    public static function init() {
        add_action( 'admin_menu', [ __CLASS__, 'add_admin_menu' ] );
        add_action( 'admin_enqueue_scripts', [ __CLASS__, 'enqueue_assets' ] );
        add_action( 'wp_ajax_subce_load_settings', [ __CLASS__, 'ajax_load_settings' ] );
        add_action( 'wp_ajax_subce_save_settings', [ __CLASS__, 'ajax_save_settings' ] );
        add_action( 'wp_ajax_subce_load_entries', [ __CLASS__, 'ajax_load_entries' ] );
        add_action( 'wp_ajax_subce_delete_entry', [ __CLASS__, 'ajax_delete_entry' ] );
        add_action( 'wp_ajax_subce_export_csv', [ __CLASS__, 'ajax_export_csv' ] );
        add_action( 'wp_ajax_subce_bulk_delete', [ __CLASS__, 'ajax_bulk_delete' ] );
        add_action( 'admin_footer', [ __CLASS__, 'modal_html' ] );
    }

    public static function add_admin_menu() {
        add_menu_page(
            esc_html__( 'Form Submissions', 'bulbul-capture-exporter-for-contact-form-7' ),
            esc_html__( 'Form Submissions', 'bulbul-capture-exporter-for-contact-form-7' ),
            'manage_options',
            'subce-forms',
            [ __CLASS__, 'render_forms_list_page' ],
            'dashicons-email-alt2',
            26
        );
    }

    public static function enqueue_assets( $hook ) {
        if ( 'toplevel_page_subce-forms' !== $hook ) {
            return;
        }

        wp_enqueue_style( 'subce-admin', SUBCE_PLUGIN_URL . 'assets/css/admin.css', [], '1.0.2' );
        wp_enqueue_script( 'subce-admin', SUBCE_PLUGIN_URL . 'assets/js/admin.js', [ 'jquery' ], '1.0.2', true );

        wp_localize_script( 'subce-admin', 'subce_ajax', [
            'ajax_url'       => admin_url( 'admin-ajax.php' ),
            'nonce'          => wp_create_nonce( 'subce_nonce' ),
            'delete_confirm' => esc_html__( 'Are you sure you want to delete this entry?', 'bulbul-capture-exporter-for-contact-form-7' ),
            'txt'            => [
                'search'   => esc_attr__( 'Search submissions...', 'bulbul-capture-exporter-for-contact-form-7' ),
                // translators: %d is number of rows.
                'per_page' => esc_attr__( 'Show %d entries', 'bulbul-capture-exporter-for-contact-form-7' ),
                'export'   => esc_attr__( 'Export CSV', 'bulbul-capture-exporter-for-contact-form-7' ),
                'no_data'  => esc_attr__( 'No submissions found.', 'bulbul-capture-exporter-for-contact-form-7' ),
                'loading'  => esc_attr__( 'Loading...', 'bulbul-capture-exporter-for-contact-form-7' ),
            ],
        ] );
    }

    public static function render_forms_list_page() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( esc_html__( 'Unauthorized', 'bulbul-capture-exporter-for-contact-form-7' ) );
        }

        global $wpdb;

        $forms = $wpdb->get_results("
            SELECT form_id, COUNT(*) as count
            FROM {$wpdb->prefix}subce_submissions
            GROUP BY form_id
            ORDER BY MAX(submit_time) DESC
        ");
        ?>
        <div class="wrap">
            <h1><?php esc_html_e( 'Form Submissions', 'bulbul-capture-exporter-for-contact-form-7' ); ?></h1>

            <div id="subce-forms-grid" class="subce-grid">
                <?php if ( empty( $forms ) ) : ?>
                    <p><?php esc_html_e( 'No submissions found.', 'bulbul-capture-exporter-for-contact-form-7' ); ?></p>
                <?php else : ?>
                    <?php foreach ( $forms as $form ) :
                        $title = esc_html__( 'Unknown Form', 'bulbul-capture-exporter-for-contact-form-7' );
                        if ( class_exists( 'WPCF7_ContactForm' ) ) {
                            $cf = WPCF7_ContactForm::get_instance( absint( $form->form_id ) );
                            if ( $cf ) {
                                $title = $cf->title();
                            }
                        }
                    ?>
                        <div class="subce-form-card" data-form-id="<?php echo esc_attr( $form->form_id ); ?>">
                            <div class="subce-card-header">
                                <h3><?php echo esc_html( $title ); ?></h3>
                            </div>
                            <div class="subce-card-body">
                                <p><strong><?php esc_html_e( 'Form ID:', 'bulbul-capture-exporter-for-contact-form-7' ); ?></strong> <?php echo esc_html( $form->form_id ); ?></p>
                                <p><strong><?php esc_html_e( 'Total Submissions:', 'bulbul-capture-exporter-for-contact-form-7' ); ?></strong> <?php echo esc_html( number_format_i18n( $form->count ) ); ?></p>
                            </div>
                            <div class="subce-card-footer">
                                <button class="button button-primary subce-open-entries" data-form-id="<?php echo esc_attr( $form->form_id ); ?>">
                                    <?php esc_html_e( 'View Entries', 'bulbul-capture-exporter-for-contact-form-7' ); ?>
                                </button>
                                <button class="button subce-open-settings" data-form-id="<?php echo esc_attr( $form->form_id ); ?>">
                                    <?php esc_html_e( 'Settings', 'bulbul-capture-exporter-for-contact-form-7' ); ?>
                                </button>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        <?php
        self::modal_html();
    }

    public static function modal_html() { ?>
        <div id="subce-settings-modal" class="subce-modal" style="display:none;">
            <div class="subce-modal-content">
                <span class="subce-close">&times;</span>
                <h2><?php esc_html_e( 'Field Display Settings', 'bulbul-capture-exporter-for-contact-form-7' ); ?>
                    <small id="subce-settings-form-title"></small>
                </h2>
                <form id="subce-settings-form">
                    <div id="subce-settings-fields"></div>
                    <button type="button" class="button button-primary" id="subce-save-settings">
                        <?php esc_html_e( 'Save Settings', 'bulbul-capture-exporter-for-contact-form-7' ); ?>
                    </button>
                </form>
            </div>
        </div>

        <div id="subce-entries-modal" class="subce-modal" style="display:none;">
            <div class="subce-modal-content wide">
                <span class="subce-close">&times;</span>
                <h2><?php esc_html_e( 'Form Submissions', 'bulbul-capture-exporter-for-contact-form-7' ); ?>
                    <small id="subce-entries-form-title"></small>
                </h2>

                <div class="subce-toolbar">
                    <input type="text" id="subce-search" placeholder="<?php echo esc_attr__( 'Search submissions...', 'bulbul-capture-exporter-for-contact-form-7' ); ?>">
                    <select id="subce-per-page">
                        <option value="10">10</option>
                        <option value="25" selected>25</option>
                        <option value="50">50</option>
                        <option value="100">100</option>
                    </select>
                    <button type="button" class="button" id="subce-export-csv"><?php esc_html_e( 'Export CSV', 'bulbul-capture-exporter-for-contact-form-7' ); ?></button>
                    <button type="button" class="button button-danger" id="subce-delete-selected"><?php esc_html_e( 'Delete Selected', 'bulbul-capture-exporter-for-contact-form-7' ); ?></button>
                </div>
                
                <div id="subce-entries-table"></div>
                <div id="subce-pagination" class="tablenav bottom"></div>
            </div>
        </div>

        <div id="subce-fullfields-modal" class="subce-modal" style="display:none;">
            <div class="subce-modal-content">
                <span class="subce-close">&times;</span>
                <h2><?php esc_html_e( 'All Submitted Fields', 'bulbul-capture-exporter-for-contact-form-7' ); ?></h2>
                <pre id="subce-fullfields-content"></pre>
            </div>
        </div>


    <?php }

    public static function ajax_load_settings() {
        check_ajax_referer( 'subce_nonce', 'nonce' );

        $form_id  = absint( wp_unslash( $_POST['form_id'] ?? 0 ) );
        $settings = get_option( "subce_settings_{$form_id}", [ 'visible' => [], 'labels' => [] ] );

        global $wpdb;
        $sample = $wpdb->get_var( $wpdb->prepare(
            "SELECT fields FROM {$wpdb->prefix}subce_submissions WHERE form_id = %d LIMIT 1",
            $form_id
        ) );

        $fields = $sample ? json_decode( $sample, true ) : [];

        ob_start();
        foreach ( $fields as $key => $val ) {
            $label   = $settings['labels'][ $key ] ?? $key;
            $checked = in_array( $key, (array) $settings['visible'], true );
            ?>
            <div class="subce-field-row">
                <label>
                    <input type="checkbox" name="visible[]" value="<?php echo esc_attr( $key ); ?>" <?php checked( $checked ); ?>>
                    <?php echo esc_html( $key ); ?>
                </label>
                <input type="text" name="labels[<?php echo esc_attr( $key ); ?>]" value="<?php echo esc_attr( $label ); ?>">
            </div>
            <?php
        }

        wp_send_json_success( ob_get_clean() );
    }

    public static function ajax_save_settings() {
        check_ajax_referer( 'subce_nonce', 'nonce' );

        $form_id = absint( wp_unslash( $_POST['form_id'] ) );
        $visible = wp_unslash( $_POST['visible'] ?? [] );
        $labels  = wp_unslash( $_POST['labels'] ?? [] );

        update_option( "subce_settings_{$form_id}", [
            'visible' => array_map( 'sanitize_text_field', (array) $visible ),
            'labels'  => array_map( 'sanitize_text_field', (array) $labels ),
        ] );

        wp_send_json_success();
    }

    public static function ajax_load_entries() {
    check_ajax_referer( 'subce_nonce', 'nonce' );

    global $wpdb;

    $form_id  = absint( wp_unslash( $_POST['form_id'] ) );
    $page     = max( 1, absint( $_POST['page'] ?? 1 ) );
    $per_page = max( 1, min( 100, absint( $_POST['per_page'] ?? 25 ) ) );
    $search   = sanitize_text_field( wp_unslash( $_POST['search'] ?? '' ) );
    $offset   = ( $page - 1 ) * $per_page;

    $settings = get_option( "subce_settings_{$form_id}", [ 'visible' => [], 'labels' => [] ] );
    $visible  = (array) $settings['visible'];
    $labels   = (array) $settings['labels'];

    $where = "WHERE form_id = %d";
    $args  = [ $form_id ];

    if ( $search ) {
        $where .= " AND fields LIKE %s";
        $args[] = '%' . $wpdb->esc_like( $search ) . '%';
    }

    /* -------------------------------------------------
     * TOTAL COUNT (THIS WAS MISSING)
     * ------------------------------------------------- */
    $total = (int) $wpdb->get_var(
        $wpdb->prepare(
            "SELECT COUNT(*) FROM {$wpdb->prefix}subce_submissions $where",
            $args
        )
    );

    /* -------------------------------------------------
     * FETCH PAGINATED ROWS
     * ------------------------------------------------- */
    $items = $wpdb->get_results(
        $wpdb->prepare(
            "SELECT * FROM {$wpdb->prefix}subce_submissions
             $where
             ORDER BY submit_time DESC
             LIMIT %d OFFSET %d",
            array_merge( $args, [ $per_page, $offset ] )
        )
    );

    ob_start();

    if ( $items ) {
        $sample = json_decode( $items[0]->fields, true );
        $cols   = ! empty( $visible )
            ? array_intersect_key( $sample, array_flip( $visible ) )
            : $sample;
        ?>
        <table class="widefat striped">
            <thead>
                <tr>
                    <th><input type="checkbox" id="subce-select-all"></th>
                    <th>#</th>
                    <?php foreach ( array_keys( $cols ) as $k ) : ?>
                        <th><?php echo esc_html( $labels[ $k ] ?? $k ); ?></th>
                    <?php endforeach; ?>
                    <th><?php esc_html_e( 'Date', 'bulbul-capture-exporter-for-contact-form-7' ); ?></th>
                    <th><?php esc_html_e( 'Actions', 'bulbul-capture-exporter-for-contact-form-7' ); ?></th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ( $items as $i => $item ) :
                $data = json_decode( $item->fields, true ); ?>
                <tr>
                    <td>
                        <input type="checkbox"
                               class="subce-entry-checkbox"
                               value="<?php echo esc_attr( $item->id ); ?>">
                    </td>
                    <td><?php echo esc_html( $offset + $i + 1 ); ?></td>
                    <?php foreach ( array_keys( $cols ) as $k ) : ?>
                        <td><?php echo esc_html( $data[ $k ] ?? '' ); ?></td>
                    <?php endforeach; ?>
                    <td><?php echo esc_html( $item->submit_time ); ?></td>
                    <td>
                        <button class="button subce-view-all"
                            data-fields="<?php echo esc_attr( wp_json_encode( $data ) ); ?>">
                            <?php esc_html_e( 'View All', 'bulbul-capture-exporter-for-contact-form-7' ); ?>
                        </button>
                        <button class="button subce-delete-entry"
                            data-id="<?php echo esc_attr( $item->id ); ?>">
                            <?php esc_html_e( 'Delete', 'bulbul-capture-exporter-for-contact-form-7' ); ?>
                        </button>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        <?php
    } else {
        echo '<p>' . esc_html__( 'No submissions found.', 'bulbul-capture-exporter-for-contact-form-7' ) . '</p>';
    }

    /* -------------------------------------------------
     * BUILD PAGINATION HTML
     * ------------------------------------------------- */
    $pagination = '';
    $total_pages = (int) ceil( $total / $per_page );

    if ( $total_pages > 1 ) {
        $pagination .= '<div class="tablenav-pages">';
       $pagination .= '<span class="displaying-num">' .
    sprintf(
        /* translators: %d: total number of submissions */
        esc_html__( '%d items', 'bulbul-capture-exporter-for-contact-form-7' ),
        $total
    ) .
'</span>';


        $pagination .= '<span class="pagination-links">';

        for ( $i = 1; $i <= $total_pages; $i++ ) {
            if ( $i === $page ) {
                $pagination .= '<span class="tablenav-page-num current">' . $i . '</span>';
            } else {
                $pagination .= '<a href="#" class="tablenav-page-num" data-page="' .
                    esc_attr( $i ) . '">' . $i . '</a>';
            }
        }

        $pagination .= '</span></div>';
    }

    wp_send_json_success( [
        'html'       => ob_get_clean(),
        'pagination' => $pagination,
        'total'      => $total,
        'page'       => $page,
    ] );
}


    public static function ajax_delete_entry() {
        check_ajax_referer( 'subce_nonce', 'nonce' );

        global $wpdb;
        $id = absint( wp_unslash( $_POST['id'] ) );

        $wpdb->delete(
            $wpdb->prefix . 'subce_submissions',
            [ 'id' => $id ],
            [ '%d' ]
        );

        wp_send_json_success();
    }

    public static function ajax_export_csv() {
    check_ajax_referer( 'subce_nonce', 'nonce' );

    global $wpdb;
    $form_id = absint( wp_unslash( $_POST['form_id'] ?? 0 ) );

    $rows = $wpdb->get_results( $wpdb->prepare(
        "SELECT fields, submit_time FROM {$wpdb->prefix}subce_submissions WHERE form_id = %d ORDER BY submit_time DESC",
        $form_id
    ) );

    if ( empty( $rows ) ) {
        wp_die();
    }

    $filename = "submissions-form-{$form_id}-" . gmdate( 'Y-m-d' ) . ".csv";

    header( 'Content-Type: text/csv; charset=utf-8' );
    header( 'Content-Disposition: attachment; filename="' . esc_attr( $filename ) . '"' );
    header( 'Pragma: no-cache' );
    header( 'Expires: 0' );

    // ✅ UTF-8 BOM (WP-compliant: NO fputs)
    echo "\xEF\xBB\xBF";

    $out = fopen( 'php://output', 'w' );

    foreach ( $rows as $r ) {
        $row = json_decode( $r->fields, true );
        if ( is_array( $row ) ) {
            fputcsv( $out, $row );
        }
    }

    exit;
}

public static function ajax_bulk_delete() {
    check_ajax_referer( 'subce_nonce', 'nonce' );

    if ( ! current_user_can( 'manage_options' ) ) {
        wp_send_json_error();
    }

    global $wpdb;

    $ids = array_map( 'absint', $_POST['ids'] ?? [] );

    if ( empty( $ids ) ) {
        wp_send_json_error();
    }

    $placeholders = implode( ',', array_fill( 0, count( $ids ), '%d' ) );

    $wpdb->query(
        $wpdb->prepare(
            "DELETE FROM {$wpdb->prefix}subce_submissions WHERE id IN ($placeholders)",
            $ids
        )
    );

    wp_send_json_success();
}


}
