<?php
/**
 * Plugin Name:       Submissions Capture & Exporter for Contact Form 7
 * Plugin URI:        https://wordpress.org/plugins/bulbul-capture-exporter-for-contact-form-7/
 * Description:       Capture Contact Form 7 submissions to database. View, search, delete & export to CSV via modern admin modals.
 * Version:           1.0.6
 * Author:            Sk Bulbul Ahmed
 * Author URI:        https://profiles.wordpress.org/bulbul389
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       bulbul-capture-exporter-for-contact-form-7
 * Domain Path:       /languages
 * Requires at least: 6.0
 * Tested up to:      6.9
 * Requires PHP:      7.4
 * Requires Plugins:  contact-form-7
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// ─────────────────────────────────────────────
// CONSTANTS
// ─────────────────────────────────────────────
define( 'SUBCE_DB_VERSION', '1.0' );
define( 'SUBCE_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'SUBCE_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

// ─────────────────────────────────────────────
// LOAD CLASSES
// ─────────────────────────────────────────────
require_once SUBCE_PLUGIN_DIR . 'includes/installer.php';
require_once SUBCE_PLUGIN_DIR . 'includes/class-subce-capture.php';
require_once SUBCE_PLUGIN_DIR . 'includes/class-subce-admin.php';

// ─────────────────────────────────────────────
// ACTIVATE
// ─────────────────────────────────────────────
register_activation_hook( __FILE__, [ 'SUBCE_Installer', 'activate' ] );

// ─────────────────────────────────────────────
// BOOT PLUGIN
// ─────────────────────────────────────────────
add_action( 'plugins_loaded', function() {

    // Contact Form 7 required
    if ( ! class_exists( 'WPCF7_ContactForm' ) ) {

        add_action( 'admin_notices', function() {
            echo '<div class="notice notice-error"><p><strong>'
                . esc_html__( 'Submissions Capture & Exporter for Contact Form 7', 'bulbul-capture-exporter-for-contact-form-7' )
                . '</strong> '
                . esc_html__( 'requires Contact Form 7 to be active.', 'bulbul-capture-exporter-for-contact-form-7' )
                . '</p></div>';
        } );

        return;
    }

    // Boot classes
    SUBCE_Capture::init();

    if ( is_admin() ) {
        SUBCE_Admin::init();
    }

});
