jQuery(function ($) {

    let currentFormId = null;
    let currentPage = 1;


    /* ------------------------------------
     * OPEN ENTRIES MODAL
     * ---------------------------------- */
    $(document).on('click', '.subce-open-entries', function () {
        currentFormId = $(this).data('form-id');

        $('#subce-entries-modal')
            .data('form-id', currentFormId)
            .fadeIn();

        $('#subce-notice').hide();

        loadEntries(1);
    });

    /* ------------------------------------
     * CLOSE MODAL
     * ---------------------------------- */
    $(document).on('click', '.subce-close', function () {
        $(this).closest('.subce-modal').fadeOut();
    });

    /* ------------------------------------
     * LOAD ENTRIES
     * ---------------------------------- */
   function loadEntries(page = 1) {

    currentPage = page;

    $.post(subce_ajax.ajax_url, {
        action:   'subce_load_entries',
        nonce:    subce_ajax.nonce,
        form_id:  currentFormId,
        page:     page,
        per_page: $('#subce-per-page').val(),
        search:   $('#subce-search').val()
    }, function (res) {

        if (res.success) {
            $('#subce-entries-table').html(res.data.html);
            $('#subce-pagination').html(res.data.pagination);
        }
    });
}

   $(document).on('click', '#subce-pagination a', function (e) {
    e.preventDefault();

    let page = $(this).data('page');
    if (!page) return;

    loadEntries(page);
});
    /* ------------------------------------
     * SEARCH & PER PAGE CHANGE
     * ---------------------------------- */
    $(document).on('keyup', '#subce-search', function () {
        loadEntries(1);
    });

    $(document).on('change', '#subce-per-page', function () {
        loadEntries(1);
    });

    /* ------------------------------------
     * SELECT ALL CHECKBOX
     * ---------------------------------- */
    $(document).on('change', '#subce-select-all', function () {
        $('.subce-entry-checkbox').prop('checked', this.checked);
    });

    /* ------------------------------------
     * BULK DELETE
     * ---------------------------------- */
    $(document).on('click', '#subce-delete-selected', function () {

        let ids = $('.subce-entry-checkbox:checked').map(function () {
            return $(this).val();
        }).get();

        if (!ids.length) {
            alert('Please select at least one entry.');
            return;
        }

        if (!confirm(subce_ajax.delete_confirm)) {
            return;
        }

        $.post(subce_ajax.ajax_url, {
            action: 'subce_bulk_delete',
            nonce: subce_ajax.nonce,
            ids: ids
        }, function (res) {

            if (res.success) {

                // Show success notice
                $('#subce-notice').fadeIn();

                setTimeout(function () {
                    $('#subce-notice').fadeOut();
                }, 3000);

                // Reload entries without closing modal
                loadEntries(1);
            }
        });
    });

    /* ------------------------------------
     * SINGLE DELETE
     * ---------------------------------- */
    $(document).on('click', '.subce-delete-entry', function () {

        if (!confirm(subce_ajax.delete_confirm)) {
            return;
        }

        let btn = $(this);
        let id = btn.data('id');

        $.post(subce_ajax.ajax_url, {
            action: 'subce_delete_entry',
            nonce: subce_ajax.nonce,
            id: id
        }, function (res) {

            if (res.success) {
                btn.closest('tr').fadeOut(300, function () {
                    $(this).remove();
                });
            }
        });
    });

    /* ------------------------------------
     * EXPORT CSV
     * ---------------------------------- */
    $(document).on('click', '#subce-export-csv', function () {

        if (!currentFormId) {
            return;
        }

        let form = $('<form>', {
            method: 'POST',
            action: subce_ajax.ajax_url,
            target: '_blank'
        });

        form.append($('<input>', {
            type: 'hidden',
            name: 'action',
            value: 'subce_export_csv'
        }));

        form.append($('<input>', {
            type: 'hidden',
            name: 'nonce',
            value: subce_ajax.nonce
        }));

        form.append($('<input>', {
            type: 'hidden',
            name: 'form_id',
            value: currentFormId
        }));

        $('body').append(form);
        form.submit();
        form.remove();
    });

    /* ------------------------------------
 * VIEW ALL FIELDS
 * ---------------------------------- */
$(document).on('click', '.subce-view-all', function () {

    let fields = $(this).data('fields');

    if (!fields) {
        return;
    }

    let content = '';

    try {
        let data = typeof fields === 'string' ? JSON.parse(fields) : fields;

        $.each(data, function (key, value) {
            content += key + ': ' + value + "\n";
        });
    } catch (e) {
        content = fields;
    }

    $('#subce-fullfields-content').text(content);
    $('#subce-fullfields-modal').fadeIn();
});

/* ------------------------------------
 * OPEN SETTINGS MODAL
 * ---------------------------------- */
$(document).on('click', '.subce-open-settings', function () {

    let formId = $(this).data('form-id');
    let title  = $(this).closest('.subce-form-card').find('h3').text();

    $('#subce-settings-form-title').text(title);
    $('#subce-settings-modal').fadeIn();

    $.post(subce_ajax.ajax_url, {
        action: 'subce_load_settings',
        nonce: subce_ajax.nonce,
        form_id: formId
    }, function (res) {
        if (res.success) {
            $('#subce-settings-fields').html(res.data);
            $('#subce-settings-form').data('form-id', formId);
        }
    });
});

/* ------------------------------------
 * SAVE SETTINGS
 * ---------------------------------- */
$(document).on('click', '#subce-save-settings', function () {

    let form = $('#subce-settings-form');
    let formId = form.data('form-id');

    $.post(subce_ajax.ajax_url, {
        action: 'subce_save_settings',
        nonce: subce_ajax.nonce,
        form_id: formId,
        visible: form.find('input[name="visible[]"]:checked').map(function () {
            return this.value;
        }).get(),
        labels: form.find('input[type="text"]').serializeArray().reduce(function (obj, item) {
            obj[item.name.replace('labels[', '').replace(']', '')] = item.value;
            return obj;
        }, {})
    }, function (res) {
        if (res.success) {
            alert('Settings saved successfully.');
            $('#subce-settings-modal').fadeOut();
        }
    });
});


});
