<?php

if (!defined('ABSPATH')) exit;

if (!class_exists('Buildecom_NotifyProcess')) {
    require_once __DIR__ . '/class-buildecom-notifyprocess.php';
}

require_once __DIR__ . '/interface-buildecom-notfiable.php';

class Buildecom_Notify_Push extends Buildecom_NotifyProcess implements Buildecom_Notifiable
{
    /**
     * Device Id of receiver
     *
     * @var array
     */
    public $deviceId;

    public $redirectUrl;

    public $pushImage;

    /**
     * Assign value to properties
     *
     * @return void
     */
    public function __construct()
    {
        $this->statusField    = 'firebase_status';
        $this->body           = 'firebase_body';
        $this->globalTemplate = 'buildecom_firebase_template';
        $this->notifyConfig   = 'buildecom_notification_config';
    }

    /**
     * Send notification
     *
     * @return void|bool
     */
    public function send()
    {
        $message = $this->getMessage();
        if ($message) {
            try {
                $credentialsFilePath = BUILDECOM_ASSET_PATH . 'push_config.json';
                $client              = new \Google_Client();
                $client->setAuthConfig($credentialsFilePath);
                $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
                $client->fetchAccessTokenWithAssertion();
                $token        = $client->getAccessToken();
                $access_token = $token['access_token'];
                $headers      = [
                    "Authorization" => "Bearer $access_token",
                    'Content-Type'  => 'application/json'
                ];

                $data['notification'] = [
                    'body'  => $message,
                    'title' => $this->getTitle(),
                    'image' => '',
                ];

                $data['data'] = [
                    'icon'         => buildecom_get_media_file(get_option('buildecom_notification_icon')),
                    'click_action' => $this->redirectUrl ?? ''
                ];

                foreach ($this->deviceId as $toAddress) {
                    $data['token']          = $toAddress;
                    $payloadData['message'] = $data;
                    $payload                = json_encode($payloadData);

                    buildecom_post_content(
                        'https://fcm.googleapis.com/v1/projects/' . get_option('buildecom_notification_config')['projectId'] . '/messages:send',
                        $payload,
                        $headers
                    );
                }
            } catch (\Exception $e) {
            }
        }
    }

    /**
     * Configure some properties
     *
     * @return void
     */
    public function prevConfiguration()
    {
        if ($this->user) {
            $user = get_user_by('email', $this->user->email);

            global $wpdb;
            $table_name = $wpdb->prefix . 'buildecom_device_tokens';
            $deviceTokens = $wpdb->get_col(
                $wpdb->prepare(
                    "SELECT device_token FROM `$table_name` WHERE user_id = %d",
                    $user->ID
                )
            );

            $this->deviceId     = $deviceTokens;
            $this->receiverName = $this->user->fullname;
        }

        $this->toAddress = $this->deviceId;
    }

    private function getTitle()
    {
        return $this->replaceTemplateShortCode($this->template->subj ?? 'Push title');
    }
}
