<?php
    if (!defined('ABSPATH')) exit;
?>

<?php

$status_list = json_decode(get_option('buildecom_status_order'), true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $items = [];

    foreach ($_POST['order'] as $order_status) {
        $label = ucfirst(str_replace('wc-', '', $order_status));
        $items[$order_status] = $label;
    }

    update_option('buildecom_status_order', json_encode($items));

    $statusOrderArray = [];
    foreach ($items as $key => $value) {
        $newKey = 'wc-' . sanitize_title($value);
        $statusOrderArray[$newKey] = $value;
    }

    update_option('buildecom_status_sorted_order', json_encode($statusOrderArray));

    $status_list = json_decode(get_option('buildecom_status_order'), true);
}
?>

<div class="wrap">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1><?php esc_html_e('Order Status Sorting', 'buildecom'); ?></h1>
            <a href="<?php echo esc_url(admin_url('admin.php?page=buildecom-order-status')) ?>" class="btn btn-primary"><?php echo esc_html__('Order Status List', 'buildecom') ?></a>
        </div>

        <button class="btn btn-primary d-inline-flex gap-2 align-items-center modal-btn">
            <span class="dashicons dashicons-editor-ul"></span>
            <?php esc_html_e('Show List', 'buildecom') ?>
        </button>
    </div>

    <form method="post">
        <?php wp_nonce_field('save_status_order'); ?>
        <ul id="sortable-statuses">
            <?php foreach (($status_list ?? []) as $status_key => $status_name): ?>
                <li class="ui-state-default status-state" data-status="<?php echo esc_attr($status_name); ?>">
                    <span class="dashicons dashicons-move"></span> <?php echo esc_html($status_name); ?>
                    <input type="hidden" name="order[]" value="<?php echo esc_attr($status_name); ?>">
                </li>
            <?php endforeach; ?>
        </ul>
        <p class="text-end mt-2"><input type="submit" class="button button-primary" value="<?php esc_attr_e('Save Order', 'buildecom'); ?>"></p>
    </form>
</div>

<div class="list-modal modal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo esc_html__('Status List', 'buildecom') ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php 
                    $cloned      = $status_list;
                    $status_list = wc_get_order_statuses();
                ?>

                <?php foreach ($status_list as $status_key => $status_name): ?>
                    <label class="d-block mb-2" for="<?php echo esc_attr(preg_replace('/\s+/', '-', strtolower($status_name))) . '--id'; ?>">
                        <input type="checkbox" id="<?php echo esc_attr(preg_replace('/\s+/', '-', strtolower($status_name))) . '--id'; ?>">
                        <span><?php echo esc_html($status_name) ?></span>
                    </label>
                <?php endforeach; ?>

                <?php
                global $wpdb;

                $table_name = $wpdb->prefix . 'buildecom_order_statuses';

                $custom_status_list = $wpdb->get_results(
                    $wpdb->prepare(
                        "SELECT * FROM $table_name WHERE status = %d ORDER BY id DESC",
                        1
                    )
                ); 
                ?> 
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-primary"><?php echo esc_html__('Save changes', 'buildecom') ?></button>
            </div>
        </div>
    </div>
</div>